package org.cloudfoundry.client.v3.routes;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.Metadata;
import org.immutables.value.Generated;

/**
 * The request payload for the Create Route operation
 */
@Generated(from = "_CreateRouteRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class CreateRouteRequest extends org.cloudfoundry.client.v3.routes._CreateRouteRequest {
  private final @Nullable String host;
  private final @Nullable Metadata metadata;
  private final @Nullable String path;
  private final @Nullable Integer port;
  private final RouteRelationships relationships;

  private CreateRouteRequest(CreateRouteRequest.Builder builder) {
    this.host = builder.host;
    this.metadata = builder.metadata;
    this.path = builder.path;
    this.port = builder.port;
    this.relationships = builder.relationships;
  }

  /**
   * The host
   */
  @JsonProperty("host")
  @Override
  public @Nullable String getHost() {
    return host;
  }

  /**
   * The metadata
   */
  @JsonProperty("metadata")
  @Override
  public @Nullable Metadata getMetadata() {
    return metadata;
  }

  /**
   * The path
   */
  @JsonProperty("path")
  @Override
  public @Nullable String getPath() {
    return path;
  }

  /**
   * The port
   */
  @JsonProperty("port")
  @Override
  public @Nullable Integer getPort() {
    return port;
  }

  /**
   * The relationships
   */
  @JsonProperty("relationships")
  @Override
  public RouteRelationships getRelationships() {
    return relationships;
  }

  /**
   * This instance is equal to all instances of {@code CreateRouteRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof CreateRouteRequest
        && equalTo((CreateRouteRequest) another);
  }

  private boolean equalTo(CreateRouteRequest another) {
    return Objects.equals(host, another.host)
        && Objects.equals(metadata, another.metadata)
        && Objects.equals(path, another.path)
        && Objects.equals(port, another.port)
        && relationships.equals(another.relationships);
  }

  /**
   * Computes a hash code from attributes: {@code host}, {@code metadata}, {@code path}, {@code port}, {@code relationships}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(host);
    h += (h << 5) + Objects.hashCode(metadata);
    h += (h << 5) + Objects.hashCode(path);
    h += (h << 5) + Objects.hashCode(port);
    h += (h << 5) + relationships.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code CreateRouteRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CreateRouteRequest{"
        + "host=" + host
        + ", metadata=" + metadata
        + ", path=" + path
        + ", port=" + port
        + ", relationships=" + relationships
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_CreateRouteRequest", generator = "Immutables")
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.routes._CreateRouteRequest {
    String host;
    Metadata metadata;
    String path;
    Integer port;
    RouteRelationships relationships;
    @JsonProperty("host")
    public void setHost(@Nullable String host) {
      this.host = host;
    }
    @JsonProperty("metadata")
    public void setMetadata(@Nullable Metadata metadata) {
      this.metadata = metadata;
    }
    @JsonProperty("path")
    public void setPath(@Nullable String path) {
      this.path = path;
    }
    @JsonProperty("port")
    public void setPort(@Nullable Integer port) {
      this.port = port;
    }
    @JsonProperty("relationships")
    public void setRelationships(RouteRelationships relationships) {
      this.relationships = relationships;
    }
    @Override
    public String getHost() { throw new UnsupportedOperationException(); }
    @Override
    public Metadata getMetadata() { throw new UnsupportedOperationException(); }
    @Override
    public String getPath() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getPort() { throw new UnsupportedOperationException(); }
    @Override
    public RouteRelationships getRelationships() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static CreateRouteRequest fromJson(Json json) {
    CreateRouteRequest.Builder builder = CreateRouteRequest.builder();
    if (json.host != null) {
      builder.host(json.host);
    }
    if (json.metadata != null) {
      builder.metadata(json.metadata);
    }
    if (json.path != null) {
      builder.path(json.path);
    }
    if (json.port != null) {
      builder.port(json.port);
    }
    if (json.relationships != null) {
      builder.relationships(json.relationships);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link CreateRouteRequest CreateRouteRequest}.
   * <pre>
   * CreateRouteRequest.builder()
   *    .host(String | null) // nullable {@link CreateRouteRequest#getHost() host}
   *    .metadata(org.cloudfoundry.client.v3.Metadata | null) // nullable {@link CreateRouteRequest#getMetadata() metadata}
   *    .path(String | null) // nullable {@link CreateRouteRequest#getPath() path}
   *    .port(Integer | null) // nullable {@link CreateRouteRequest#getPort() port}
   *    .relationships(org.cloudfoundry.client.v3.routes.RouteRelationships) // required {@link CreateRouteRequest#getRelationships() relationships}
   *    .build();
   * </pre>
   * @return A new CreateRouteRequest builder
   */
  public static CreateRouteRequest.Builder builder() {
    return new CreateRouteRequest.Builder();
  }

  /**
   * Builds instances of type {@link CreateRouteRequest CreateRouteRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_CreateRouteRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_RELATIONSHIPS = 0x1L;
    private long initBits = 0x1L;

    private String host;
    private Metadata metadata;
    private String path;
    private Integer port;
    private RouteRelationships relationships;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CreateRouteRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CreateRouteRequest instance) {
      return from((_CreateRouteRequest) instance);
    }

    /**
     * Copy abstract value type {@code _CreateRouteRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_CreateRouteRequest instance) {
      Objects.requireNonNull(instance, "instance");
      String hostValue = instance.getHost();
      if (hostValue != null) {
        host(hostValue);
      }
      Metadata metadataValue = instance.getMetadata();
      if (metadataValue != null) {
        metadata(metadataValue);
      }
      String pathValue = instance.getPath();
      if (pathValue != null) {
        path(pathValue);
      }
      Integer portValue = instance.getPort();
      if (portValue != null) {
        port(portValue);
      }
      relationships(instance.getRelationships());
      return this;
    }

    /**
     * Initializes the value for the {@link CreateRouteRequest#getHost() host} attribute.
     * @param host The value for host (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder host(@Nullable String host) {
      this.host = host;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateRouteRequest#getMetadata() metadata} attribute.
     * @param metadata The value for metadata (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder metadata(@Nullable Metadata metadata) {
      this.metadata = metadata;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateRouteRequest#getPath() path} attribute.
     * @param path The value for path (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder path(@Nullable String path) {
      this.path = path;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateRouteRequest#getPort() port} attribute.
     * @param port The value for port (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder port(@Nullable Integer port) {
      this.port = port;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateRouteRequest#getRelationships() relationships} attribute.
     * @param relationships The value for relationships 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder relationships(RouteRelationships relationships) {
      this.relationships = Objects.requireNonNull(relationships, "relationships");
      initBits &= ~INIT_BIT_RELATIONSHIPS;
      return this;
    }

    /**
     * Builds a new {@link CreateRouteRequest CreateRouteRequest}.
     * @return An immutable instance of CreateRouteRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public CreateRouteRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new CreateRouteRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_RELATIONSHIPS) != 0) attributes.add("relationships");
      return "Cannot build CreateRouteRequest, some of required attributes are not set " + attributes;
    }
  }
}
