package org.cloudfoundry.client.v3.routes;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.*;
import org.cloudfoundry.client.v3.Metadata;
import org.cloudfoundry.client.v3.Resource;
import org.immutables.value.Generated;

/**
 * The response payload for the Get Route operation
 */
@Generated(from = "_GetRouteResponse", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class GetRouteResponse extends org.cloudfoundry.client.v3.routes._GetRouteResponse {
  private final String createdAt;
  private final String id;
  private final Map<String, Link> links;
  private final @Nullable String updatedAt;
  private final @Nullable List<Destination> destinations;
  private final String host;
  private final @Nullable Metadata metadata;
  private final String path;
  private final @Nullable Integer port;
  private final @Nullable Protocol protocol;
  private final RouteRelationships relationships;
  private final String url;

  private GetRouteResponse(GetRouteResponse.Builder builder) {
    this.createdAt = builder.createdAt;
    this.id = builder.id;
    this.links = createUnmodifiableMap(false, false, builder.links);
    this.updatedAt = builder.updatedAt;
    this.destinations = builder.destinations == null ? null : createUnmodifiableList(true, builder.destinations);
    this.host = builder.host;
    this.metadata = builder.metadata;
    this.path = builder.path;
    this.port = builder.port;
    this.protocol = builder.protocol;
    this.relationships = builder.relationships;
    this.url = builder.url;
  }

  /**
   * When the resource was created
   */
  @JsonProperty("created_at")
  @Override
  public String getCreatedAt() {
    return createdAt;
  }

  /**
   * The resource's id
   */
  @JsonProperty("guid")
  @Override
  public String getId() {
    return id;
  }

  /**
   * Links to related resources and actions for the resource
   */
  @JsonProperty("links")
  @Override
  public Map<String, Link> getLinks() {
    return links;
  }

  /**
   * When the resource was last updated
   */
  @JsonProperty("updated_at")
  @Override
  public @Nullable String getUpdatedAt() {
    return updatedAt;
  }

  /**
   * The destinations
   */
  @JsonProperty("destinations")
  @Override
  public @Nullable List<Destination> getDestinations() {
    return destinations;
  }

  /**
   * The host
   */
  @JsonProperty("host")
  @Override
  public String getHost() {
    return host;
  }

  /**
   * The metadata
   */
  @JsonProperty("metadata")
  @Override
  public @Nullable Metadata getMetadata() {
    return metadata;
  }

  /**
   * The path
   */
  @JsonProperty("path")
  @Override
  public String getPath() {
    return path;
  }

  /**
   * The port
   */
  @JsonProperty("port")
  @Override
  public @Nullable Integer getPort() {
    return port;
  }

  /**
   * The protocol
   */
  @JsonProperty("protocol")
  @Override
  public @Nullable Protocol getProtocol() {
    return protocol;
  }

  /**
   * The relationships
   */
  @JsonProperty("relationships")
  @Override
  public RouteRelationships getRelationships() {
    return relationships;
  }

  /**
   * The url
   */
  @JsonProperty("url")
  @Override
  public String getUrl() {
    return url;
  }

  /**
   * This instance is equal to all instances of {@code GetRouteResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GetRouteResponse
        && equalTo((GetRouteResponse) another);
  }

  private boolean equalTo(GetRouteResponse another) {
    return createdAt.equals(another.createdAt)
        && id.equals(another.id)
        && links.equals(another.links)
        && Objects.equals(updatedAt, another.updatedAt)
        && Objects.equals(destinations, another.destinations)
        && host.equals(another.host)
        && Objects.equals(metadata, another.metadata)
        && path.equals(another.path)
        && Objects.equals(port, another.port)
        && Objects.equals(protocol, another.protocol)
        && relationships.equals(another.relationships)
        && url.equals(another.url);
  }

  /**
   * Computes a hash code from attributes: {@code createdAt}, {@code id}, {@code links}, {@code updatedAt}, {@code destinations}, {@code host}, {@code metadata}, {@code path}, {@code port}, {@code protocol}, {@code relationships}, {@code url}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + createdAt.hashCode();
    h += (h << 5) + id.hashCode();
    h += (h << 5) + links.hashCode();
    h += (h << 5) + Objects.hashCode(updatedAt);
    h += (h << 5) + Objects.hashCode(destinations);
    h += (h << 5) + host.hashCode();
    h += (h << 5) + Objects.hashCode(metadata);
    h += (h << 5) + path.hashCode();
    h += (h << 5) + Objects.hashCode(port);
    h += (h << 5) + Objects.hashCode(protocol);
    h += (h << 5) + relationships.hashCode();
    h += (h << 5) + url.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GetRouteResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetRouteResponse{"
        + "createdAt=" + createdAt
        + ", id=" + id
        + ", links=" + links
        + ", updatedAt=" + updatedAt
        + ", destinations=" + destinations
        + ", host=" + host
        + ", metadata=" + metadata
        + ", path=" + path
        + ", port=" + port
        + ", protocol=" + protocol
        + ", relationships=" + relationships
        + ", url=" + url
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_GetRouteResponse", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.routes._GetRouteResponse {
    String createdAt;
    String id;
    Map<String, Link> links = Collections.emptyMap();
    String updatedAt;
    List<Destination> destinations = null;
    String host;
    Metadata metadata;
    String path;
    Integer port;
    Protocol protocol;
    RouteRelationships relationships;
    String url;
    @JsonProperty("created_at")
    public void setCreatedAt(String createdAt) {
      this.createdAt = createdAt;
    }
    @JsonProperty("guid")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("links")
    public void setLinks(Map<String, Link> links) {
      this.links = links;
    }
    @JsonProperty("updated_at")
    public void setUpdatedAt(@Nullable String updatedAt) {
      this.updatedAt = updatedAt;
    }
    @JsonProperty("destinations")
    public void setDestinations(@Nullable List<Destination> destinations) {
      this.destinations = destinations;
    }
    @JsonProperty("host")
    public void setHost(String host) {
      this.host = host;
    }
    @JsonProperty("metadata")
    public void setMetadata(@Nullable Metadata metadata) {
      this.metadata = metadata;
    }
    @JsonProperty("path")
    public void setPath(String path) {
      this.path = path;
    }
    @JsonProperty("port")
    public void setPort(@Nullable Integer port) {
      this.port = port;
    }
    @JsonProperty("protocol")
    public void setProtocol(@Nullable Protocol protocol) {
      this.protocol = protocol;
    }
    @JsonProperty("relationships")
    public void setRelationships(RouteRelationships relationships) {
      this.relationships = relationships;
    }
    @JsonProperty("url")
    public void setUrl(String url) {
      this.url = url;
    }
    @Override
    public String getCreatedAt() { throw new UnsupportedOperationException(); }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, Link> getLinks() { throw new UnsupportedOperationException(); }
    @Override
    public String getUpdatedAt() { throw new UnsupportedOperationException(); }
    @Override
    public List<Destination> getDestinations() { throw new UnsupportedOperationException(); }
    @Override
    public String getHost() { throw new UnsupportedOperationException(); }
    @Override
    public Metadata getMetadata() { throw new UnsupportedOperationException(); }
    @Override
    public String getPath() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getPort() { throw new UnsupportedOperationException(); }
    @Override
    public Protocol getProtocol() { throw new UnsupportedOperationException(); }
    @Override
    public RouteRelationships getRelationships() { throw new UnsupportedOperationException(); }
    @Override
    public String getUrl() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static GetRouteResponse fromJson(Json json) {
    GetRouteResponse.Builder builder = GetRouteResponse.builder();
    if (json.createdAt != null) {
      builder.createdAt(json.createdAt);
    }
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.links != null) {
      builder.putAllLinks(json.links);
    }
    if (json.updatedAt != null) {
      builder.updatedAt(json.updatedAt);
    }
    if (json.destinations != null) {
      builder.addAllDestinations(json.destinations);
    }
    if (json.host != null) {
      builder.host(json.host);
    }
    if (json.metadata != null) {
      builder.metadata(json.metadata);
    }
    if (json.path != null) {
      builder.path(json.path);
    }
    if (json.port != null) {
      builder.port(json.port);
    }
    if (json.protocol != null) {
      builder.protocol(json.protocol);
    }
    if (json.relationships != null) {
      builder.relationships(json.relationships);
    }
    if (json.url != null) {
      builder.url(json.url);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link GetRouteResponse GetRouteResponse}.
   * <pre>
   * GetRouteResponse.builder()
   *    .createdAt(String) // required {@link GetRouteResponse#getCreatedAt() createdAt}
   *    .id(String) // required {@link GetRouteResponse#getId() id}
   *    .link|putAllLinks(String =&gt; Link) // {@link GetRouteResponse#getLinks() links} mappings
   *    .updatedAt(String | null) // nullable {@link GetRouteResponse#getUpdatedAt() updatedAt}
   *    .destinations(List&amp;lt;Destination&amp;gt; | null) // nullable {@link GetRouteResponse#getDestinations() destinations}
   *    .host(String) // required {@link GetRouteResponse#getHost() host}
   *    .metadata(org.cloudfoundry.client.v3.Metadata | null) // nullable {@link GetRouteResponse#getMetadata() metadata}
   *    .path(String) // required {@link GetRouteResponse#getPath() path}
   *    .port(Integer | null) // nullable {@link GetRouteResponse#getPort() port}
   *    .protocol(org.cloudfoundry.client.v3.routes.Protocol | null) // nullable {@link GetRouteResponse#getProtocol() protocol}
   *    .relationships(org.cloudfoundry.client.v3.routes.RouteRelationships) // required {@link GetRouteResponse#getRelationships() relationships}
   *    .url(String) // required {@link GetRouteResponse#getUrl() url}
   *    .build();
   * </pre>
   * @return A new GetRouteResponse builder
   */
  public static GetRouteResponse.Builder builder() {
    return new GetRouteResponse.Builder();
  }

  /**
   * Builds instances of type {@link GetRouteResponse GetRouteResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_GetRouteResponse", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_CREATED_AT = 0x1L;
    private static final long INIT_BIT_ID = 0x2L;
    private static final long INIT_BIT_HOST = 0x4L;
    private static final long INIT_BIT_PATH = 0x8L;
    private static final long INIT_BIT_RELATIONSHIPS = 0x10L;
    private static final long INIT_BIT_URL = 0x20L;
    private long initBits = 0x3fL;

    private String createdAt;
    private String id;
    private Map<String, Link> links = new LinkedHashMap<String, Link>();
    private String updatedAt;
    private List<Destination> destinations = null;
    private String host;
    private Metadata metadata;
    private String path;
    private Integer port;
    private Protocol protocol;
    private RouteRelationships relationships;
    private String url;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v3.routes.Route} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Route instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v3.Resource} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Resource instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetRouteResponse} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GetRouteResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _GetRouteResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_GetRouteResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof Route) {
        Route instance = (Route) object;
        path(instance.getPath());
        relationships(instance.getRelationships());
        Metadata metadataValue = instance.getMetadata();
        if (metadataValue != null) {
          metadata(metadataValue);
        }
        Protocol protocolValue = instance.getProtocol();
        if (protocolValue != null) {
          protocol(protocolValue);
        }
        Integer portValue = instance.getPort();
        if (portValue != null) {
          port(portValue);
        }
        List<Destination> destinationsValue = instance.getDestinations();
        if (destinationsValue != null) {
          addAllDestinations(destinationsValue);
        }
        host(instance.getHost());
        url(instance.getUrl());
      }
      if (object instanceof Resource) {
        Resource instance = (Resource) object;
        createdAt(instance.getCreatedAt());
        putAllLinks(instance.getLinks());
        id(instance.getId());
        String updatedAtValue = instance.getUpdatedAt();
        if (updatedAtValue != null) {
          updatedAt(updatedAtValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link GetRouteResponse#getCreatedAt() createdAt} attribute.
     * @param createdAt The value for createdAt 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("created_at")
    public final Builder createdAt(String createdAt) {
      this.createdAt = Objects.requireNonNull(createdAt, "createdAt");
      initBits &= ~INIT_BIT_CREATED_AT;
      return this;
    }

    /**
     * Initializes the value for the {@link GetRouteResponse#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("guid")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Put one entry to the {@link GetRouteResponse#getLinks() links} map.
     * @param key The key in the links map
     * @param value The associated value in the links map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder link(String key, Link value) {
      this.links.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link GetRouteResponse#getLinks() links} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder link(Map.Entry<String, ? extends Link> entry) {
      String k = entry.getKey();
      Link v = entry.getValue();
      this.links.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link GetRouteResponse#getLinks() links} map. Nulls are not permitted
     * @param entries The entries that will be added to the links map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("links")
    public final Builder links(Map<String, ? extends Link> entries) {
      this.links.clear();
      return putAllLinks(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link GetRouteResponse#getLinks() links} map. Nulls are not permitted
     * @param entries The entries that will be added to the links map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllLinks(Map<String, ? extends Link> entries) {
      for (Map.Entry<String, ? extends Link> e : entries.entrySet()) {
        String k = e.getKey();
        Link v = e.getValue();
        this.links.put(k, v);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link GetRouteResponse#getUpdatedAt() updatedAt} attribute.
     * @param updatedAt The value for updatedAt (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("updated_at")
    public final Builder updatedAt(@Nullable String updatedAt) {
      this.updatedAt = updatedAt;
      return this;
    }

    /**
     * Adds one element to {@link GetRouteResponse#getDestinations() destinations} list.
     * @param element A destinations element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder destination(Destination element) {
      if (this.destinations == null) {
        this.destinations = new ArrayList<Destination>();
      }
      this.destinations.add(Objects.requireNonNull(element, "destinations element"));
      return this;
    }

    /**
     * Adds elements to {@link GetRouteResponse#getDestinations() destinations} list.
     * @param elements An array of destinations elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder destinations(Destination... elements) {
      if (this.destinations == null) {
        this.destinations = new ArrayList<Destination>();
      }
      for (Destination element : elements) {
        this.destinations.add(Objects.requireNonNull(element, "destinations element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link GetRouteResponse#getDestinations() destinations} list.
     * @param elements An iterable of destinations elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("destinations")
    public final Builder destinations(@Nullable Iterable<? extends Destination> elements) {
      if (elements == null) {
        this.destinations = null;
        return this;
      }
      this.destinations = new ArrayList<Destination>();
      return addAllDestinations(elements);
    }

    /**
     * Adds elements to {@link GetRouteResponse#getDestinations() destinations} list.
     * @param elements An iterable of destinations elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllDestinations(Iterable<? extends Destination> elements) {
      Objects.requireNonNull(elements, "destinations element");
      if (this.destinations == null) {
        this.destinations = new ArrayList<Destination>();
      }
      for (Destination element : elements) {
        this.destinations.add(Objects.requireNonNull(element, "destinations element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link GetRouteResponse#getHost() host} attribute.
     * @param host The value for host 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("host")
    public final Builder host(String host) {
      this.host = Objects.requireNonNull(host, "host");
      initBits &= ~INIT_BIT_HOST;
      return this;
    }

    /**
     * Initializes the value for the {@link GetRouteResponse#getMetadata() metadata} attribute.
     * @param metadata The value for metadata (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("metadata")
    public final Builder metadata(@Nullable Metadata metadata) {
      this.metadata = metadata;
      return this;
    }

    /**
     * Initializes the value for the {@link GetRouteResponse#getPath() path} attribute.
     * @param path The value for path 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("path")
    public final Builder path(String path) {
      this.path = Objects.requireNonNull(path, "path");
      initBits &= ~INIT_BIT_PATH;
      return this;
    }

    /**
     * Initializes the value for the {@link GetRouteResponse#getPort() port} attribute.
     * @param port The value for port (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("port")
    public final Builder port(@Nullable Integer port) {
      this.port = port;
      return this;
    }

    /**
     * Initializes the value for the {@link GetRouteResponse#getProtocol() protocol} attribute.
     * @param protocol The value for protocol (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("protocol")
    public final Builder protocol(@Nullable Protocol protocol) {
      this.protocol = protocol;
      return this;
    }

    /**
     * Initializes the value for the {@link GetRouteResponse#getRelationships() relationships} attribute.
     * @param relationships The value for relationships 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("relationships")
    public final Builder relationships(RouteRelationships relationships) {
      this.relationships = Objects.requireNonNull(relationships, "relationships");
      initBits &= ~INIT_BIT_RELATIONSHIPS;
      return this;
    }

    /**
     * Initializes the value for the {@link GetRouteResponse#getUrl() url} attribute.
     * @param url The value for url 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("url")
    public final Builder url(String url) {
      this.url = Objects.requireNonNull(url, "url");
      initBits &= ~INIT_BIT_URL;
      return this;
    }

    /**
     * Builds a new {@link GetRouteResponse GetRouteResponse}.
     * @return An immutable instance of GetRouteResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GetRouteResponse build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new GetRouteResponse(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CREATED_AT) != 0) attributes.add("createdAt");
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_HOST) != 0) attributes.add("host");
      if ((initBits & INIT_BIT_PATH) != 0) attributes.add("path");
      if ((initBits & INIT_BIT_RELATIONSHIPS) != 0) attributes.add("relationships");
      if ((initBits & INIT_BIT_URL) != 0) attributes.add("url");
      return "Cannot build GetRouteResponse, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
