package org.cloudfoundry.client.v3.serviceofferings;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The request payload for the Get Service Offering operation
 */
@Generated(from = "_GetServiceOfferingRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class GetServiceOfferingRequest
    extends org.cloudfoundry.client.v3.serviceofferings._GetServiceOfferingRequest {
  private final String serviceOfferingId;

  private GetServiceOfferingRequest(GetServiceOfferingRequest.Builder builder) {
    this.serviceOfferingId = builder.serviceOfferingId;
  }

  /**
   * The service offering id
   */
  @Override
  public String getServiceOfferingId() {
    return serviceOfferingId;
  }

  /**
   * This instance is equal to all instances of {@code GetServiceOfferingRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GetServiceOfferingRequest
        && equalTo((GetServiceOfferingRequest) another);
  }

  private boolean equalTo(GetServiceOfferingRequest another) {
    return serviceOfferingId.equals(another.serviceOfferingId);
  }

  /**
   * Computes a hash code from attributes: {@code serviceOfferingId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + serviceOfferingId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GetServiceOfferingRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetServiceOfferingRequest{"
        + "serviceOfferingId=" + serviceOfferingId
        + "}";
  }

  /**
   * Creates a builder for {@link GetServiceOfferingRequest GetServiceOfferingRequest}.
   * <pre>
   * GetServiceOfferingRequest.builder()
   *    .serviceOfferingId(String) // required {@link GetServiceOfferingRequest#getServiceOfferingId() serviceOfferingId}
   *    .build();
   * </pre>
   * @return A new GetServiceOfferingRequest builder
   */
  public static GetServiceOfferingRequest.Builder builder() {
    return new GetServiceOfferingRequest.Builder();
  }

  /**
   * Builds instances of type {@link GetServiceOfferingRequest GetServiceOfferingRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_GetServiceOfferingRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_SERVICE_OFFERING_ID = 0x1L;
    private long initBits = 0x1L;

    private String serviceOfferingId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetServiceOfferingRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GetServiceOfferingRequest instance) {
      return from((_GetServiceOfferingRequest) instance);
    }

    /**
     * Copy abstract value type {@code _GetServiceOfferingRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_GetServiceOfferingRequest instance) {
      Objects.requireNonNull(instance, "instance");
      serviceOfferingId(instance.getServiceOfferingId());
      return this;
    }

    /**
     * Initializes the value for the {@link GetServiceOfferingRequest#getServiceOfferingId() serviceOfferingId} attribute.
     * @param serviceOfferingId The value for serviceOfferingId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceOfferingId(String serviceOfferingId) {
      this.serviceOfferingId = Objects.requireNonNull(serviceOfferingId, "serviceOfferingId");
      initBits &= ~INIT_BIT_SERVICE_OFFERING_ID;
      return this;
    }

    /**
     * Builds a new {@link GetServiceOfferingRequest GetServiceOfferingRequest}.
     * @return An immutable instance of GetServiceOfferingRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GetServiceOfferingRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new GetServiceOfferingRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SERVICE_OFFERING_ID) != 0) attributes.add("serviceOfferingId");
      return "Cannot build GetServiceOfferingRequest, some of required attributes are not set " + attributes;
    }
  }
}
