/*
 * Copyright 2013-2020 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.cloudfoundry.client.v3.serviceplans;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.cloudfoundry.AllowNulls;
import org.cloudfoundry.Nullable;
import org.immutables.value.Value;

/**
 * The entity representing service plan schemas
 */
@JsonDeserialize
@Value.Immutable
abstract class _Schemas {

    /**
     * The service binding schema
     */
    @AllowNulls
    @JsonProperty("service_binding")
    @Nullable
    abstract ServiceBindingSchema getServiceBinding();

    /**
     * The service instance schema
     */
    @JsonProperty("service_instance")
    abstract ServiceInstanceSchema getServiceInstance();

}
