package org.cloudfoundry.client.v3.spaces;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The request payload for the Create Space operation
 */
@Generated(from = "_CreateSpaceRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class CreateSpaceRequest extends org.cloudfoundry.client.v3.spaces._CreateSpaceRequest {
  private final String name;
  private final SpaceRelationships relationships;

  private CreateSpaceRequest(CreateSpaceRequest.Builder builder) {
    this.name = builder.name;
    this.relationships = builder.relationships;
  }

  /**
   * The name
   */
  @JsonProperty("name")
  @Override
  public String getName() {
    return name;
  }

  /**
   * The relationships
   */
  @JsonProperty("relationships")
  @Override
  public SpaceRelationships getRelationships() {
    return relationships;
  }

  /**
   * This instance is equal to all instances of {@code CreateSpaceRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof CreateSpaceRequest
        && equalTo((CreateSpaceRequest) another);
  }

  private boolean equalTo(CreateSpaceRequest another) {
    return name.equals(another.name)
        && relationships.equals(another.relationships);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code relationships}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + name.hashCode();
    h += (h << 5) + relationships.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code CreateSpaceRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CreateSpaceRequest{"
        + "name=" + name
        + ", relationships=" + relationships
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_CreateSpaceRequest", generator = "Immutables")
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.spaces._CreateSpaceRequest {
    String name;
    SpaceRelationships relationships;
    @JsonProperty("name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("relationships")
    public void setRelationships(SpaceRelationships relationships) {
      this.relationships = relationships;
    }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public SpaceRelationships getRelationships() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static CreateSpaceRequest fromJson(Json json) {
    CreateSpaceRequest.Builder builder = CreateSpaceRequest.builder();
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.relationships != null) {
      builder.relationships(json.relationships);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link CreateSpaceRequest CreateSpaceRequest}.
   * <pre>
   * CreateSpaceRequest.builder()
   *    .name(String) // required {@link CreateSpaceRequest#getName() name}
   *    .relationships(org.cloudfoundry.client.v3.spaces.SpaceRelationships) // required {@link CreateSpaceRequest#getRelationships() relationships}
   *    .build();
   * </pre>
   * @return A new CreateSpaceRequest builder
   */
  public static CreateSpaceRequest.Builder builder() {
    return new CreateSpaceRequest.Builder();
  }

  /**
   * Builds instances of type {@link CreateSpaceRequest CreateSpaceRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_CreateSpaceRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long INIT_BIT_RELATIONSHIPS = 0x2L;
    private long initBits = 0x3L;

    private String name;
    private SpaceRelationships relationships;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CreateSpaceRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CreateSpaceRequest instance) {
      return from((_CreateSpaceRequest) instance);
    }

    /**
     * Copy abstract value type {@code _CreateSpaceRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_CreateSpaceRequest instance) {
      Objects.requireNonNull(instance, "instance");
      name(instance.getName());
      relationships(instance.getRelationships());
      return this;
    }

    /**
     * Initializes the value for the {@link CreateSpaceRequest#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateSpaceRequest#getRelationships() relationships} attribute.
     * @param relationships The value for relationships 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder relationships(SpaceRelationships relationships) {
      this.relationships = Objects.requireNonNull(relationships, "relationships");
      initBits &= ~INIT_BIT_RELATIONSHIPS;
      return this;
    }

    /**
     * Builds a new {@link CreateSpaceRequest CreateSpaceRequest}.
     * @return An immutable instance of CreateSpaceRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public CreateSpaceRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new CreateSpaceRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_RELATIONSHIPS) != 0) attributes.add("relationships");
      return "Cannot build CreateSpaceRequest, some of required attributes are not set " + attributes;
    }
  }
}
