package org.cloudfoundry.client.v3.tasks;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.client.v3.ToOneRelationship;
import org.immutables.value.Generated;

/**
 * The relationships for the Task entity
 */
@Generated(from = "_TaskRelationships", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class TaskRelationships extends org.cloudfoundry.client.v3.tasks._TaskRelationships {
  private final ToOneRelationship app;

  private TaskRelationships(TaskRelationships.Builder builder) {
    this.app = builder.app;
  }

  /**
   * The app relationship
   */
  @JsonProperty("app")
  @Override
  public ToOneRelationship getApp() {
    return app;
  }

  /**
   * This instance is equal to all instances of {@code TaskRelationships} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof TaskRelationships
        && equalTo((TaskRelationships) another);
  }

  private boolean equalTo(TaskRelationships another) {
    return app.equals(another.app);
  }

  /**
   * Computes a hash code from attributes: {@code app}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + app.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code TaskRelationships} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "TaskRelationships{"
        + "app=" + app
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_TaskRelationships", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.tasks._TaskRelationships {
    ToOneRelationship app;
    @JsonProperty("app")
    public void setApp(ToOneRelationship app) {
      this.app = app;
    }
    @Override
    public ToOneRelationship getApp() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static TaskRelationships fromJson(Json json) {
    TaskRelationships.Builder builder = TaskRelationships.builder();
    if (json.app != null) {
      builder.app(json.app);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link TaskRelationships TaskRelationships}.
   * <pre>
   * TaskRelationships.builder()
   *    .app(org.cloudfoundry.client.v3.ToOneRelationship) // required {@link TaskRelationships#getApp() app}
   *    .build();
   * </pre>
   * @return A new TaskRelationships builder
   */
  public static TaskRelationships.Builder builder() {
    return new TaskRelationships.Builder();
  }

  /**
   * Builds instances of type {@link TaskRelationships TaskRelationships}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_TaskRelationships", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_APP = 0x1L;
    private long initBits = 0x1L;

    private ToOneRelationship app;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code TaskRelationships} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(TaskRelationships instance) {
      return from((_TaskRelationships) instance);
    }

    /**
     * Copy abstract value type {@code _TaskRelationships} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_TaskRelationships instance) {
      Objects.requireNonNull(instance, "instance");
      app(instance.getApp());
      return this;
    }

    /**
     * Initializes the value for the {@link TaskRelationships#getApp() app} attribute.
     * @param app The value for app 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("app")
    public final Builder app(ToOneRelationship app) {
      this.app = Objects.requireNonNull(app, "app");
      initBits &= ~INIT_BIT_APP;
      return this;
    }

    /**
     * Builds a new {@link TaskRelationships TaskRelationships}.
     * @return An immutable instance of TaskRelationships
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public TaskRelationships build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new TaskRelationships(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_APP) != 0) attributes.add("app");
      return "Cannot build TaskRelationships, some of required attributes are not set " + attributes;
    }
  }
}
