package org.cloudfoundry.doppler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * This event represents the whole lifecycle of an HTTP request.
 */
@Generated(from = "_HttpStartStop", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class HttpStartStop extends org.cloudfoundry.doppler._HttpStartStop {
  private final @Nullable UUID applicationId;
  private final Long contentLength;
  private final List<String> forwarded;
  private final @Nullable String instanceId;
  private final @Nullable Integer instanceIndex;
  private final @Nullable Method method;
  private final PeerType peerType;
  private final String remoteAddress;
  private final UUID requestId;
  private final Long startTimestamp;
  private final Integer statusCode;
  private final Long stopTimestamp;
  private final String uri;
  private final String userAgent;

  private HttpStartStop(HttpStartStop.Builder builder) {
    this.applicationId = builder.applicationId;
    this.contentLength = builder.contentLength;
    this.forwarded = createUnmodifiableList(true, builder.forwarded);
    this.instanceId = builder.instanceId;
    this.instanceIndex = builder.instanceIndex;
    this.method = builder.method;
    this.peerType = builder.peerType;
    this.remoteAddress = builder.remoteAddress;
    this.requestId = builder.requestId;
    this.startTimestamp = builder.startTimestamp;
    this.statusCode = builder.statusCode;
    this.stopTimestamp = builder.stopTimestamp;
    this.uri = builder.uri;
    this.userAgent = builder.userAgent;
  }

  /**
   * The application id
   */
  @Override
  public @Nullable UUID getApplicationId() {
    return applicationId;
  }

  /**
   * The length of the response in bytes
   */
  @Override
  public Long getContentLength() {
    return contentLength;
  }

  /**
   * The http forwarded-for [x-forwarded-for] header from the request
   */
  @Override
  public List<String> getForwarded() {
    return forwarded;
  }

  /**
   * The ID of the application instance
   */
  @Override
  public @Nullable String getInstanceId() {
    return instanceId;
  }

  /**
   * The index of the application instance
   */
  @Override
  public @Nullable Integer getInstanceIndex() {
    return instanceIndex;
  }

  /**
   * The method of the request
   */
  @Override
  public @Nullable Method getMethod() {
    return method;
  }

  /**
   * The role of the emitting process in the request cycle
   */
  @Override
  public PeerType getPeerType() {
    return peerType;
  }

  /**
   * The remote address of the request. (For a server, this should be the origin of the request.)
   */
  @Override
  public String getRemoteAddress() {
    return remoteAddress;
  }

  /**
   * The ID for tracking lifecycle of request.
   */
  @Override
  public UUID getRequestId() {
    return requestId;
  }

  /**
   * The UNIX timestamp (in nanoseconds) when the request was sent (by a client) or received (by a server)
   */
  @Override
  public Long getStartTimestamp() {
    return startTimestamp;
  }

  /**
   * The status code returned with the response to the request
   */
  @Override
  public Integer getStatusCode() {
    return statusCode;
  }

  /**
   * The UNIX timestamp (in nanoseconds) when the request was received
   */
  @Override
  public Long getStopTimestamp() {
    return stopTimestamp;
  }

  /**
   * The uri of the request
   */
  @Override
  public String getUri() {
    return uri;
  }

  /**
   * The contents of the UserAgent header on the request
   */
  @Override
  public String getUserAgent() {
    return userAgent;
  }

  /**
   * This instance is equal to all instances of {@code HttpStartStop} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof HttpStartStop
        && equalTo((HttpStartStop) another);
  }

  private boolean equalTo(HttpStartStop another) {
    return Objects.equals(applicationId, another.applicationId)
        && contentLength.equals(another.contentLength)
        && forwarded.equals(another.forwarded)
        && Objects.equals(instanceId, another.instanceId)
        && Objects.equals(instanceIndex, another.instanceIndex)
        && Objects.equals(method, another.method)
        && peerType.equals(another.peerType)
        && remoteAddress.equals(another.remoteAddress)
        && requestId.equals(another.requestId)
        && startTimestamp.equals(another.startTimestamp)
        && statusCode.equals(another.statusCode)
        && stopTimestamp.equals(another.stopTimestamp)
        && uri.equals(another.uri)
        && userAgent.equals(another.userAgent);
  }

  /**
   * Computes a hash code from attributes: {@code applicationId}, {@code contentLength}, {@code forwarded}, {@code instanceId}, {@code instanceIndex}, {@code method}, {@code peerType}, {@code remoteAddress}, {@code requestId}, {@code startTimestamp}, {@code statusCode}, {@code stopTimestamp}, {@code uri}, {@code userAgent}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(applicationId);
    h += (h << 5) + contentLength.hashCode();
    h += (h << 5) + forwarded.hashCode();
    h += (h << 5) + Objects.hashCode(instanceId);
    h += (h << 5) + Objects.hashCode(instanceIndex);
    h += (h << 5) + Objects.hashCode(method);
    h += (h << 5) + peerType.hashCode();
    h += (h << 5) + remoteAddress.hashCode();
    h += (h << 5) + requestId.hashCode();
    h += (h << 5) + startTimestamp.hashCode();
    h += (h << 5) + statusCode.hashCode();
    h += (h << 5) + stopTimestamp.hashCode();
    h += (h << 5) + uri.hashCode();
    h += (h << 5) + userAgent.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code HttpStartStop} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "HttpStartStop{"
        + "applicationId=" + applicationId
        + ", contentLength=" + contentLength
        + ", forwarded=" + forwarded
        + ", instanceId=" + instanceId
        + ", instanceIndex=" + instanceIndex
        + ", method=" + method
        + ", peerType=" + peerType
        + ", remoteAddress=" + remoteAddress
        + ", requestId=" + requestId
        + ", startTimestamp=" + startTimestamp
        + ", statusCode=" + statusCode
        + ", stopTimestamp=" + stopTimestamp
        + ", uri=" + uri
        + ", userAgent=" + userAgent
        + "}";
  }

  /**
   * Creates a builder for {@link HttpStartStop HttpStartStop}.
   * <pre>
   * HttpStartStop.builder()
   *    .applicationId(UUID | null) // nullable {@link HttpStartStop#getApplicationId() applicationId}
   *    .contentLength(Long) // required {@link HttpStartStop#getContentLength() contentLength}
   *    .forwarded|addAllForwarded(String) // {@link HttpStartStop#getForwarded() forwarded} elements
   *    .instanceId(String | null) // nullable {@link HttpStartStop#getInstanceId() instanceId}
   *    .instanceIndex(Integer | null) // nullable {@link HttpStartStop#getInstanceIndex() instanceIndex}
   *    .method(org.cloudfoundry.doppler.Method | null) // nullable {@link HttpStartStop#getMethod() method}
   *    .peerType(org.cloudfoundry.doppler.PeerType) // required {@link HttpStartStop#getPeerType() peerType}
   *    .remoteAddress(String) // required {@link HttpStartStop#getRemoteAddress() remoteAddress}
   *    .requestId(UUID) // required {@link HttpStartStop#getRequestId() requestId}
   *    .startTimestamp(Long) // required {@link HttpStartStop#getStartTimestamp() startTimestamp}
   *    .statusCode(Integer) // required {@link HttpStartStop#getStatusCode() statusCode}
   *    .stopTimestamp(Long) // required {@link HttpStartStop#getStopTimestamp() stopTimestamp}
   *    .uri(String) // required {@link HttpStartStop#getUri() uri}
   *    .userAgent(String) // required {@link HttpStartStop#getUserAgent() userAgent}
   *    .build();
   * </pre>
   * @return A new HttpStartStop builder
   */
  public static HttpStartStop.Builder builder() {
    return new HttpStartStop.Builder();
  }

  /**
   * Builds instances of type {@link HttpStartStop HttpStartStop}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_HttpStartStop", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_CONTENT_LENGTH = 0x1L;
    private static final long INIT_BIT_PEER_TYPE = 0x2L;
    private static final long INIT_BIT_REMOTE_ADDRESS = 0x4L;
    private static final long INIT_BIT_REQUEST_ID = 0x8L;
    private static final long INIT_BIT_START_TIMESTAMP = 0x10L;
    private static final long INIT_BIT_STATUS_CODE = 0x20L;
    private static final long INIT_BIT_STOP_TIMESTAMP = 0x40L;
    private static final long INIT_BIT_URI = 0x80L;
    private static final long INIT_BIT_USER_AGENT = 0x100L;
    private long initBits = 0x1ffL;

    private UUID applicationId;
    private Long contentLength;
    private List<String> forwarded = new ArrayList<String>();
    private String instanceId;
    private Integer instanceIndex;
    private Method method;
    private PeerType peerType;
    private String remoteAddress;
    private UUID requestId;
    private Long startTimestamp;
    private Integer statusCode;
    private Long stopTimestamp;
    private String uri;
    private String userAgent;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code HttpStartStop} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(HttpStartStop instance) {
      return from((_HttpStartStop) instance);
    }

    /**
     * Copy abstract value type {@code _HttpStartStop} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_HttpStartStop instance) {
      Objects.requireNonNull(instance, "instance");
      UUID applicationIdValue = instance.getApplicationId();
      if (applicationIdValue != null) {
        applicationId(applicationIdValue);
      }
      contentLength(instance.getContentLength());
      addAllForwarded(instance.getForwarded());
      String instanceIdValue = instance.getInstanceId();
      if (instanceIdValue != null) {
        instanceId(instanceIdValue);
      }
      Integer instanceIndexValue = instance.getInstanceIndex();
      if (instanceIndexValue != null) {
        instanceIndex(instanceIndexValue);
      }
      Method methodValue = instance.getMethod();
      if (methodValue != null) {
        method(methodValue);
      }
      peerType(instance.getPeerType());
      remoteAddress(instance.getRemoteAddress());
      requestId(instance.getRequestId());
      startTimestamp(instance.getStartTimestamp());
      statusCode(instance.getStatusCode());
      stopTimestamp(instance.getStopTimestamp());
      uri(instance.getUri());
      userAgent(instance.getUserAgent());
      return this;
    }

    /**
     * Initializes the value for the {@link HttpStartStop#getApplicationId() applicationId} attribute.
     * @param applicationId The value for applicationId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationId(@Nullable UUID applicationId) {
      this.applicationId = applicationId;
      return this;
    }

    /**
     * Initializes the value for the {@link HttpStartStop#getContentLength() contentLength} attribute.
     * @param contentLength The value for contentLength 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder contentLength(Long contentLength) {
      this.contentLength = Objects.requireNonNull(contentLength, "contentLength");
      initBits &= ~INIT_BIT_CONTENT_LENGTH;
      return this;
    }

    /**
     * Adds one element to {@link HttpStartStop#getForwarded() forwarded} list.
     * @param element A forwarded element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder forwarded(String element) {
      this.forwarded.add(Objects.requireNonNull(element, "forwarded element"));
      return this;
    }

    /**
     * Adds elements to {@link HttpStartStop#getForwarded() forwarded} list.
     * @param elements An array of forwarded elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder forwarded(String... elements) {
      for (String element : elements) {
        this.forwarded.add(Objects.requireNonNull(element, "forwarded element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link HttpStartStop#getForwarded() forwarded} list.
     * @param elements An iterable of forwarded elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder forwarded(Iterable<String> elements) {
      this.forwarded.clear();
      return addAllForwarded(elements);
    }

    /**
     * Adds elements to {@link HttpStartStop#getForwarded() forwarded} list.
     * @param elements An iterable of forwarded elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllForwarded(Iterable<String> elements) {
      for (String element : elements) {
        this.forwarded.add(Objects.requireNonNull(element, "forwarded element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link HttpStartStop#getInstanceId() instanceId} attribute.
     * @param instanceId The value for instanceId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder instanceId(@Nullable String instanceId) {
      this.instanceId = instanceId;
      return this;
    }

    /**
     * Initializes the value for the {@link HttpStartStop#getInstanceIndex() instanceIndex} attribute.
     * @param instanceIndex The value for instanceIndex (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder instanceIndex(@Nullable Integer instanceIndex) {
      this.instanceIndex = instanceIndex;
      return this;
    }

    /**
     * Initializes the value for the {@link HttpStartStop#getMethod() method} attribute.
     * @param method The value for method (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder method(@Nullable Method method) {
      this.method = method;
      return this;
    }

    /**
     * Initializes the value for the {@link HttpStartStop#getPeerType() peerType} attribute.
     * @param peerType The value for peerType 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder peerType(PeerType peerType) {
      this.peerType = Objects.requireNonNull(peerType, "peerType");
      initBits &= ~INIT_BIT_PEER_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link HttpStartStop#getRemoteAddress() remoteAddress} attribute.
     * @param remoteAddress The value for remoteAddress 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder remoteAddress(String remoteAddress) {
      this.remoteAddress = Objects.requireNonNull(remoteAddress, "remoteAddress");
      initBits &= ~INIT_BIT_REMOTE_ADDRESS;
      return this;
    }

    /**
     * Initializes the value for the {@link HttpStartStop#getRequestId() requestId} attribute.
     * @param requestId The value for requestId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder requestId(UUID requestId) {
      this.requestId = Objects.requireNonNull(requestId, "requestId");
      initBits &= ~INIT_BIT_REQUEST_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link HttpStartStop#getStartTimestamp() startTimestamp} attribute.
     * @param startTimestamp The value for startTimestamp 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder startTimestamp(Long startTimestamp) {
      this.startTimestamp = Objects.requireNonNull(startTimestamp, "startTimestamp");
      initBits &= ~INIT_BIT_START_TIMESTAMP;
      return this;
    }

    /**
     * Initializes the value for the {@link HttpStartStop#getStatusCode() statusCode} attribute.
     * @param statusCode The value for statusCode 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder statusCode(Integer statusCode) {
      this.statusCode = Objects.requireNonNull(statusCode, "statusCode");
      initBits &= ~INIT_BIT_STATUS_CODE;
      return this;
    }

    /**
     * Initializes the value for the {@link HttpStartStop#getStopTimestamp() stopTimestamp} attribute.
     * @param stopTimestamp The value for stopTimestamp 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder stopTimestamp(Long stopTimestamp) {
      this.stopTimestamp = Objects.requireNonNull(stopTimestamp, "stopTimestamp");
      initBits &= ~INIT_BIT_STOP_TIMESTAMP;
      return this;
    }

    /**
     * Initializes the value for the {@link HttpStartStop#getUri() uri} attribute.
     * @param uri The value for uri 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder uri(String uri) {
      this.uri = Objects.requireNonNull(uri, "uri");
      initBits &= ~INIT_BIT_URI;
      return this;
    }

    /**
     * Initializes the value for the {@link HttpStartStop#getUserAgent() userAgent} attribute.
     * @param userAgent The value for userAgent 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder userAgent(String userAgent) {
      this.userAgent = Objects.requireNonNull(userAgent, "userAgent");
      initBits &= ~INIT_BIT_USER_AGENT;
      return this;
    }

    /**
     * Builds a new {@link HttpStartStop HttpStartStop}.
     * @return An immutable instance of HttpStartStop
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public HttpStartStop build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new HttpStartStop(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CONTENT_LENGTH) != 0) attributes.add("contentLength");
      if ((initBits & INIT_BIT_PEER_TYPE) != 0) attributes.add("peerType");
      if ((initBits & INIT_BIT_REMOTE_ADDRESS) != 0) attributes.add("remoteAddress");
      if ((initBits & INIT_BIT_REQUEST_ID) != 0) attributes.add("requestId");
      if ((initBits & INIT_BIT_START_TIMESTAMP) != 0) attributes.add("startTimestamp");
      if ((initBits & INIT_BIT_STATUS_CODE) != 0) attributes.add("statusCode");
      if ((initBits & INIT_BIT_STOP_TIMESTAMP) != 0) attributes.add("stopTimestamp");
      if ((initBits & INIT_BIT_URI) != 0) attributes.add("uri");
      if ((initBits & INIT_BIT_USER_AGENT) != 0) attributes.add("userAgent");
      return "Cannot build HttpStartStop, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
