package org.cloudfoundry.logcache.v1;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The response payload for the Meta operation
 */
@Generated(from = "_MetaResponse", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class MetaResponse extends org.cloudfoundry.logcache.v1._MetaResponse {
  private final Map<String, Metadata> meta;

  private MetaResponse(MetaResponse.Builder builder) {
    this.meta = createUnmodifiableMap(false, false, builder.meta);
  }

  /**
   * The meta data
   */
  @JsonProperty("meta")
  @Override
  public Map<String, Metadata> getMeta() {
    return meta;
  }

  /**
   * This instance is equal to all instances of {@code MetaResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof MetaResponse
        && equalTo((MetaResponse) another);
  }

  private boolean equalTo(MetaResponse another) {
    return meta.equals(another.meta);
  }

  /**
   * Computes a hash code from attributes: {@code meta}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + meta.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code MetaResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "MetaResponse{"
        + "meta=" + meta
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_MetaResponse", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.logcache.v1._MetaResponse {
    Map<String, Metadata> meta = Collections.emptyMap();
    @JsonProperty("meta")
    public void setMeta(Map<String, Metadata> meta) {
      this.meta = meta;
    }
    @Override
    public Map<String, Metadata> getMeta() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static MetaResponse fromJson(Json json) {
    MetaResponse.Builder builder = MetaResponse.builder();
    if (json.meta != null) {
      builder.putAllMeta(json.meta);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link MetaResponse MetaResponse}.
   * <pre>
   * MetaResponse.builder()
   *    .meta|putAllMeta(String =&gt; Metadata) // {@link MetaResponse#getMeta() meta} mappings
   *    .build();
   * </pre>
   * @return A new MetaResponse builder
   */
  public static MetaResponse.Builder builder() {
    return new MetaResponse.Builder();
  }

  /**
   * Builds instances of type {@link MetaResponse MetaResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_MetaResponse", generator = "Immutables")
  public static final class Builder {
    private Map<String, Metadata> meta = new LinkedHashMap<String, Metadata>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code MetaResponse} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(MetaResponse instance) {
      return from((_MetaResponse) instance);
    }

    /**
     * Copy abstract value type {@code _MetaResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_MetaResponse instance) {
      Objects.requireNonNull(instance, "instance");
      putAllMeta(instance.getMeta());
      return this;
    }

    /**
     * Put one entry to the {@link MetaResponse#getMeta() meta} map.
     * @param key The key in the meta map
     * @param value The associated value in the meta map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder meta(String key, Metadata value) {
      this.meta.put(
          Objects.requireNonNull(key, "meta key"),
          Objects.requireNonNull(value, "meta value"));
      return this;
    }

    /**
     * Put one entry to the {@link MetaResponse#getMeta() meta} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder meta(Map.Entry<String, ? extends Metadata> entry) {
      String k = entry.getKey();
      Metadata v = entry.getValue();
      this.meta.put(
          Objects.requireNonNull(k, "meta key"),
          Objects.requireNonNull(v, "meta value"));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link MetaResponse#getMeta() meta} map. Nulls are not permitted
     * @param entries The entries that will be added to the meta map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("meta")
    public final Builder meta(Map<String, ? extends Metadata> entries) {
      this.meta.clear();
      return putAllMeta(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link MetaResponse#getMeta() meta} map. Nulls are not permitted
     * @param entries The entries that will be added to the meta map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllMeta(Map<String, ? extends Metadata> entries) {
      for (Map.Entry<String, ? extends Metadata> e : entries.entrySet()) {
        String k = e.getKey();
        Metadata v = e.getValue();
        this.meta.put(
            Objects.requireNonNull(k, "meta key"),
            Objects.requireNonNull(v, "meta value"));
      }
      return this;
    }

    /**
     * Builds a new {@link MetaResponse MetaResponse}.
     * @return An immutable instance of MetaResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public MetaResponse build() {
      return new MetaResponse(this);
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
