package org.cloudfoundry.networking.v1.policies;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The payload for Policy responses
 */
@Generated(from = "_Destination", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class Destination extends org.cloudfoundry.networking.v1.policies._Destination {
  private final String id;
  private final Ports ports;
  private final String protocol;

  private Destination(Destination.Builder builder) {
    this.id = builder.id;
    this.ports = builder.ports;
    this.protocol = builder.protocol;
  }

  /**
   * The id
   */
  @JsonProperty("id")
  @Override
  public String getId() {
    return id;
  }

  /**
   * The ports
   */
  @JsonProperty("ports")
  @Override
  public Ports getPorts() {
    return ports;
  }

  /**
   * The protocol
   */
  @JsonProperty("protocol")
  @Override
  public String getProtocol() {
    return protocol;
  }

  /**
   * This instance is equal to all instances of {@code Destination} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof Destination
        && equalTo((Destination) another);
  }

  private boolean equalTo(Destination another) {
    return id.equals(another.id)
        && ports.equals(another.ports)
        && protocol.equals(another.protocol);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code ports}, {@code protocol}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + ports.hashCode();
    h += (h << 5) + protocol.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Destination} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Destination{"
        + "id=" + id
        + ", ports=" + ports
        + ", protocol=" + protocol
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_Destination", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.networking.v1.policies._Destination {
    String id;
    Ports ports;
    String protocol;
    @JsonProperty("id")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("ports")
    public void setPorts(Ports ports) {
      this.ports = ports;
    }
    @JsonProperty("protocol")
    public void setProtocol(String protocol) {
      this.protocol = protocol;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public Ports getPorts() { throw new UnsupportedOperationException(); }
    @Override
    public String getProtocol() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static Destination fromJson(Json json) {
    Destination.Builder builder = Destination.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.ports != null) {
      builder.ports(json.ports);
    }
    if (json.protocol != null) {
      builder.protocol(json.protocol);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link Destination Destination}.
   * <pre>
   * Destination.builder()
   *    .id(String) // required {@link Destination#getId() id}
   *    .ports(org.cloudfoundry.networking.v1.policies.Ports) // required {@link Destination#getPorts() ports}
   *    .protocol(String) // required {@link Destination#getProtocol() protocol}
   *    .build();
   * </pre>
   * @return A new Destination builder
   */
  public static Destination.Builder builder() {
    return new Destination.Builder();
  }

  /**
   * Builds instances of type {@link Destination Destination}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_Destination", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_PORTS = 0x2L;
    private static final long INIT_BIT_PROTOCOL = 0x4L;
    private long initBits = 0x7L;

    private String id;
    private Ports ports;
    private String protocol;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Destination} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Destination instance) {
      return from((_Destination) instance);
    }

    /**
     * Copy abstract value type {@code _Destination} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_Destination instance) {
      Objects.requireNonNull(instance, "instance");
      id(instance.getId());
      ports(instance.getPorts());
      protocol(instance.getProtocol());
      return this;
    }

    /**
     * Initializes the value for the {@link Destination#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("id")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link Destination#getPorts() ports} attribute.
     * @param ports The value for ports 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("ports")
    public final Builder ports(Ports ports) {
      this.ports = Objects.requireNonNull(ports, "ports");
      initBits &= ~INIT_BIT_PORTS;
      return this;
    }

    /**
     * Initializes the value for the {@link Destination#getProtocol() protocol} attribute.
     * @param protocol The value for protocol 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("protocol")
    public final Builder protocol(String protocol) {
      this.protocol = Objects.requireNonNull(protocol, "protocol");
      initBits &= ~INIT_BIT_PROTOCOL;
      return this;
    }

    /**
     * Builds a new {@link Destination Destination}.
     * @return An immutable instance of Destination
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public Destination build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new Destination(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_PORTS) != 0) attributes.add("ports");
      if ((initBits & INIT_BIT_PROTOCOL) != 0) attributes.add("protocol");
      return "Cannot build Destination, some of required attributes are not set " + attributes;
    }
  }
}
