package org.cloudfoundry.routing.v1.tcproutes;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The payload for TCP Route responses
 */
@Generated(from = "_TcpRouteDeletion", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class TcpRouteDeletion extends org.cloudfoundry.routing.v1.tcproutes._TcpRouteDeletion {
  private final String backendIp;
  private final Integer backendPort;
  private final Integer port;
  private final String routerGroupId;

  private TcpRouteDeletion(TcpRouteDeletion.Builder builder) {
    this.backendIp = builder.backendIp;
    this.backendPort = builder.backendPort;
    this.port = builder.port;
    this.routerGroupId = builder.routerGroupId;
  }

  /**
   * IP address of backend.
   */
  @JsonProperty("backend_ip")
  @Override
  public String getBackendIp() {
    return backendIp;
  }

  /**
   * Backend port.
   */
  @JsonProperty("backend_port")
  @Override
  public Integer getBackendPort() {
    return backendPort;
  }

  /**
   * External facing port for the TCP route.
   */
  @JsonProperty("port")
  @Override
  public Integer getPort() {
    return port;
  }

  /**
   * ID of the router group associated with this route.
   */
  @JsonProperty("router_group_guid")
  @Override
  public String getRouterGroupId() {
    return routerGroupId;
  }

  /**
   * This instance is equal to all instances of {@code TcpRouteDeletion} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof TcpRouteDeletion
        && equalTo((TcpRouteDeletion) another);
  }

  private boolean equalTo(TcpRouteDeletion another) {
    return backendIp.equals(another.backendIp)
        && backendPort.equals(another.backendPort)
        && port.equals(another.port)
        && routerGroupId.equals(another.routerGroupId);
  }

  /**
   * Computes a hash code from attributes: {@code backendIp}, {@code backendPort}, {@code port}, {@code routerGroupId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + backendIp.hashCode();
    h += (h << 5) + backendPort.hashCode();
    h += (h << 5) + port.hashCode();
    h += (h << 5) + routerGroupId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code TcpRouteDeletion} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "TcpRouteDeletion{"
        + "backendIp=" + backendIp
        + ", backendPort=" + backendPort
        + ", port=" + port
        + ", routerGroupId=" + routerGroupId
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_TcpRouteDeletion", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.routing.v1.tcproutes._TcpRouteDeletion {
    String backendIp;
    Integer backendPort;
    Integer port;
    String routerGroupId;
    @JsonProperty("backend_ip")
    public void setBackendIp(String backendIp) {
      this.backendIp = backendIp;
    }
    @JsonProperty("backend_port")
    public void setBackendPort(Integer backendPort) {
      this.backendPort = backendPort;
    }
    @JsonProperty("port")
    public void setPort(Integer port) {
      this.port = port;
    }
    @JsonProperty("router_group_guid")
    public void setRouterGroupId(String routerGroupId) {
      this.routerGroupId = routerGroupId;
    }
    @Override
    public String getBackendIp() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getBackendPort() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getPort() { throw new UnsupportedOperationException(); }
    @Override
    public String getRouterGroupId() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static TcpRouteDeletion fromJson(Json json) {
    TcpRouteDeletion.Builder builder = TcpRouteDeletion.builder();
    if (json.backendIp != null) {
      builder.backendIp(json.backendIp);
    }
    if (json.backendPort != null) {
      builder.backendPort(json.backendPort);
    }
    if (json.port != null) {
      builder.port(json.port);
    }
    if (json.routerGroupId != null) {
      builder.routerGroupId(json.routerGroupId);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link TcpRouteDeletion TcpRouteDeletion}.
   * <pre>
   * TcpRouteDeletion.builder()
   *    .backendIp(String) // required {@link TcpRouteDeletion#getBackendIp() backendIp}
   *    .backendPort(Integer) // required {@link TcpRouteDeletion#getBackendPort() backendPort}
   *    .port(Integer) // required {@link TcpRouteDeletion#getPort() port}
   *    .routerGroupId(String) // required {@link TcpRouteDeletion#getRouterGroupId() routerGroupId}
   *    .build();
   * </pre>
   * @return A new TcpRouteDeletion builder
   */
  public static TcpRouteDeletion.Builder builder() {
    return new TcpRouteDeletion.Builder();
  }

  /**
   * Builds instances of type {@link TcpRouteDeletion TcpRouteDeletion}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_TcpRouteDeletion", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_BACKEND_IP = 0x1L;
    private static final long INIT_BIT_BACKEND_PORT = 0x2L;
    private static final long INIT_BIT_PORT = 0x4L;
    private static final long INIT_BIT_ROUTER_GROUP_ID = 0x8L;
    private long initBits = 0xfL;

    private String backendIp;
    private Integer backendPort;
    private Integer port;
    private String routerGroupId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code TcpRouteDeletion} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(TcpRouteDeletion instance) {
      return from((_TcpRouteDeletion) instance);
    }

    /**
     * Copy abstract value type {@code _TcpRouteDeletion} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_TcpRouteDeletion instance) {
      Objects.requireNonNull(instance, "instance");
      backendIp(instance.getBackendIp());
      backendPort(instance.getBackendPort());
      port(instance.getPort());
      routerGroupId(instance.getRouterGroupId());
      return this;
    }

    /**
     * Initializes the value for the {@link TcpRouteDeletion#getBackendIp() backendIp} attribute.
     * @param backendIp The value for backendIp 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("backend_ip")
    public final Builder backendIp(String backendIp) {
      this.backendIp = Objects.requireNonNull(backendIp, "backendIp");
      initBits &= ~INIT_BIT_BACKEND_IP;
      return this;
    }

    /**
     * Initializes the value for the {@link TcpRouteDeletion#getBackendPort() backendPort} attribute.
     * @param backendPort The value for backendPort 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("backend_port")
    public final Builder backendPort(Integer backendPort) {
      this.backendPort = Objects.requireNonNull(backendPort, "backendPort");
      initBits &= ~INIT_BIT_BACKEND_PORT;
      return this;
    }

    /**
     * Initializes the value for the {@link TcpRouteDeletion#getPort() port} attribute.
     * @param port The value for port 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("port")
    public final Builder port(Integer port) {
      this.port = Objects.requireNonNull(port, "port");
      initBits &= ~INIT_BIT_PORT;
      return this;
    }

    /**
     * Initializes the value for the {@link TcpRouteDeletion#getRouterGroupId() routerGroupId} attribute.
     * @param routerGroupId The value for routerGroupId 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("router_group_guid")
    public final Builder routerGroupId(String routerGroupId) {
      this.routerGroupId = Objects.requireNonNull(routerGroupId, "routerGroupId");
      initBits &= ~INIT_BIT_ROUTER_GROUP_ID;
      return this;
    }

    /**
     * Builds a new {@link TcpRouteDeletion TcpRouteDeletion}.
     * @return An immutable instance of TcpRouteDeletion
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public TcpRouteDeletion build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new TcpRouteDeletion(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_BACKEND_IP) != 0) attributes.add("backendIp");
      if ((initBits & INIT_BIT_BACKEND_PORT) != 0) attributes.add("backendPort");
      if ((initBits & INIT_BIT_PORT) != 0) attributes.add("port");
      if ((initBits & INIT_BIT_ROUTER_GROUP_ID) != 0) attributes.add("routerGroupId");
      return "Cannot build TcpRouteDeletion, some of required attributes are not set " + attributes;
    }
  }
}
