package org.cloudfoundry.uaa.authorizations;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The response from the Get Open ID Provider Configuration request
 */
@Generated(from = "_GetOpenIdProviderConfigurationResponse", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class GetOpenIdProviderConfigurationResponse
    extends org.cloudfoundry.uaa.authorizations._GetOpenIdProviderConfigurationResponse {
  private final String authorizationEndpoint;
  private final Boolean claimsParameterSupported;
  private final String issuer;
  private final String javaWebKeySetEndpoint;
  private final String serviceDocumentation;
  private final List<String> supportedClaimTypes;
  private final List<String> supportedClaims;
  private final List<String> supportedIdTokenEncryptionAlgorithms;
  private final List<String> supportedIdTokenSigningAlgorithms;
  private final List<String> supportedResponseTypes;
  private final List<String> supportedScopes;
  private final List<String> supportedSubjectTypes;
  private final List<String> supportedTokenEndpointAuthorizationMethods;
  private final List<String> supportedTokenEndpointAuthorizationSigningAlgorithms;
  private final List<Locale> supportedUiLocales;
  private final String tokenEndpoint;
  private final String userInfoEndpoint;

  private GetOpenIdProviderConfigurationResponse(GetOpenIdProviderConfigurationResponse.Builder builder) {
    this.authorizationEndpoint = builder.authorizationEndpoint;
    this.claimsParameterSupported = builder.claimsParameterSupported;
    this.issuer = builder.issuer;
    this.javaWebKeySetEndpoint = builder.javaWebKeySetEndpoint;
    this.serviceDocumentation = builder.serviceDocumentation;
    this.supportedClaimTypes = createUnmodifiableList(true, builder.supportedClaimTypes);
    this.supportedClaims = createUnmodifiableList(true, builder.supportedClaims);
    this.supportedIdTokenEncryptionAlgorithms = createUnmodifiableList(true, builder.supportedIdTokenEncryptionAlgorithms);
    this.supportedIdTokenSigningAlgorithms = createUnmodifiableList(true, builder.supportedIdTokenSigningAlgorithms);
    this.supportedResponseTypes = createUnmodifiableList(true, builder.supportedResponseTypes);
    this.supportedScopes = createUnmodifiableList(true, builder.supportedScopes);
    this.supportedSubjectTypes = createUnmodifiableList(true, builder.supportedSubjectTypes);
    this.supportedTokenEndpointAuthorizationMethods = createUnmodifiableList(true, builder.supportedTokenEndpointAuthorizationMethods);
    this.supportedTokenEndpointAuthorizationSigningAlgorithms = createUnmodifiableList(true, builder.supportedTokenEndpointAuthorizationSigningAlgorithms);
    this.supportedUiLocales = createUnmodifiableList(true, builder.supportedUiLocales);
    this.tokenEndpoint = builder.tokenEndpoint;
    this.userInfoEndpoint = builder.userInfoEndpoint;
  }

  /**
   * The authorization endpoint
   */
  @JsonProperty("authorization_endpoint")
  @Override
  public String getAuthorizationEndpoint() {
    return authorizationEndpoint;
  }

  /**
   * Whether the claims parameter is supported
   */
  @JsonProperty("claims_parameter_supported")
  @Override
  public Boolean getClaimsParameterSupported() {
    return claimsParameterSupported;
  }

  /**
   * The issuer
   */
  @JsonProperty("issuer")
  @Override
  public String getIssuer() {
    return issuer;
  }

  /**
   * The Java Web Key Set endpoint
   */
  @JsonProperty("jwks_uri")
  @Override
  public String getJavaWebKeySetEndpoint() {
    return javaWebKeySetEndpoint;
  }

  /**
   * The location of human-readable documentation
   */
  @JsonProperty("service_documentation")
  @Override
  public String getServiceDocumentation() {
    return serviceDocumentation;
  }

  /**
   * The claim types supported
   */
  @JsonProperty("claim_types_supported")
  @Override
  public List<String> getSupportedClaimTypes() {
    return supportedClaimTypes;
  }

  /**
   * The claims supported
   */
  @JsonProperty("claims_supported")
  @Override
  public List<String> getSupportedClaims() {
    return supportedClaims;
  }

  /**
   * The id token encryption algorithms supported
   */
  @JsonProperty("id_token_encryption_alg_values_supported")
  @Override
  public List<String> getSupportedIdTokenEncryptionAlgorithms() {
    return supportedIdTokenEncryptionAlgorithms;
  }

  /**
   * The id token signing algorithms supported
   */
  @JsonProperty("id_token_signing_alg_values_supported")
  @Override
  public List<String> getSupportedIdTokenSigningAlgorithms() {
    return supportedIdTokenSigningAlgorithms;
  }

  /**
   * The response types supported
   */
  @JsonProperty("response_types_supported")
  @Override
  public List<String> getSupportedResponseTypes() {
    return supportedResponseTypes;
  }

  /**
   * The scopes supported
   */
  @JsonProperty("scopes_supported")
  @Override
  public List<String> getSupportedScopes() {
    return supportedScopes;
  }

  /**
   * The subject types supported
   */
  @JsonProperty("subject_types_supported")
  @Override
  public List<String> getSupportedSubjectTypes() {
    return supportedSubjectTypes;
  }

  /**
   * The token endpoint authorization methods supported
   */
  @JsonProperty("token_endpoint_auth_methods_supported")
  @Override
  public List<String> getSupportedTokenEndpointAuthorizationMethods() {
    return supportedTokenEndpointAuthorizationMethods;
  }

  /**
   * The token endpoint authorization signing algorithms supported
   */
  @JsonProperty("token_endpoint_auth_signing_alg_values_supported")
  @Override
  public List<String> getSupportedTokenEndpointAuthorizationSigningAlgorithms() {
    return supportedTokenEndpointAuthorizationSigningAlgorithms;
  }

  /**
   * The UI locales supported
   */
  @JsonProperty("ui_locales_supported")
  @Override
  public List<Locale> getSupportedUiLocales() {
    return supportedUiLocales;
  }

  /**
   * The token endpoint
   */
  @JsonProperty("token_endpoint")
  @Override
  public String getTokenEndpoint() {
    return tokenEndpoint;
  }

  /**
   * The user info endpoint
   */
  @JsonProperty("userinfo_endpoint")
  @Override
  public String getUserInfoEndpoint() {
    return userInfoEndpoint;
  }

  /**
   * This instance is equal to all instances of {@code GetOpenIdProviderConfigurationResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GetOpenIdProviderConfigurationResponse
        && equalTo((GetOpenIdProviderConfigurationResponse) another);
  }

  private boolean equalTo(GetOpenIdProviderConfigurationResponse another) {
    return authorizationEndpoint.equals(another.authorizationEndpoint)
        && claimsParameterSupported.equals(another.claimsParameterSupported)
        && issuer.equals(another.issuer)
        && javaWebKeySetEndpoint.equals(another.javaWebKeySetEndpoint)
        && serviceDocumentation.equals(another.serviceDocumentation)
        && supportedClaimTypes.equals(another.supportedClaimTypes)
        && supportedClaims.equals(another.supportedClaims)
        && supportedIdTokenEncryptionAlgorithms.equals(another.supportedIdTokenEncryptionAlgorithms)
        && supportedIdTokenSigningAlgorithms.equals(another.supportedIdTokenSigningAlgorithms)
        && supportedResponseTypes.equals(another.supportedResponseTypes)
        && supportedScopes.equals(another.supportedScopes)
        && supportedSubjectTypes.equals(another.supportedSubjectTypes)
        && supportedTokenEndpointAuthorizationMethods.equals(another.supportedTokenEndpointAuthorizationMethods)
        && supportedTokenEndpointAuthorizationSigningAlgorithms.equals(another.supportedTokenEndpointAuthorizationSigningAlgorithms)
        && supportedUiLocales.equals(another.supportedUiLocales)
        && tokenEndpoint.equals(another.tokenEndpoint)
        && userInfoEndpoint.equals(another.userInfoEndpoint);
  }

  /**
   * Computes a hash code from attributes: {@code authorizationEndpoint}, {@code claimsParameterSupported}, {@code issuer}, {@code javaWebKeySetEndpoint}, {@code serviceDocumentation}, {@code supportedClaimTypes}, {@code supportedClaims}, {@code supportedIdTokenEncryptionAlgorithms}, {@code supportedIdTokenSigningAlgorithms}, {@code supportedResponseTypes}, {@code supportedScopes}, {@code supportedSubjectTypes}, {@code supportedTokenEndpointAuthorizationMethods}, {@code supportedTokenEndpointAuthorizationSigningAlgorithms}, {@code supportedUiLocales}, {@code tokenEndpoint}, {@code userInfoEndpoint}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + authorizationEndpoint.hashCode();
    h += (h << 5) + claimsParameterSupported.hashCode();
    h += (h << 5) + issuer.hashCode();
    h += (h << 5) + javaWebKeySetEndpoint.hashCode();
    h += (h << 5) + serviceDocumentation.hashCode();
    h += (h << 5) + supportedClaimTypes.hashCode();
    h += (h << 5) + supportedClaims.hashCode();
    h += (h << 5) + supportedIdTokenEncryptionAlgorithms.hashCode();
    h += (h << 5) + supportedIdTokenSigningAlgorithms.hashCode();
    h += (h << 5) + supportedResponseTypes.hashCode();
    h += (h << 5) + supportedScopes.hashCode();
    h += (h << 5) + supportedSubjectTypes.hashCode();
    h += (h << 5) + supportedTokenEndpointAuthorizationMethods.hashCode();
    h += (h << 5) + supportedTokenEndpointAuthorizationSigningAlgorithms.hashCode();
    h += (h << 5) + supportedUiLocales.hashCode();
    h += (h << 5) + tokenEndpoint.hashCode();
    h += (h << 5) + userInfoEndpoint.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GetOpenIdProviderConfigurationResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetOpenIdProviderConfigurationResponse{"
        + "authorizationEndpoint=" + authorizationEndpoint
        + ", claimsParameterSupported=" + claimsParameterSupported
        + ", issuer=" + issuer
        + ", javaWebKeySetEndpoint=" + javaWebKeySetEndpoint
        + ", serviceDocumentation=" + serviceDocumentation
        + ", supportedClaimTypes=" + supportedClaimTypes
        + ", supportedClaims=" + supportedClaims
        + ", supportedIdTokenEncryptionAlgorithms=" + supportedIdTokenEncryptionAlgorithms
        + ", supportedIdTokenSigningAlgorithms=" + supportedIdTokenSigningAlgorithms
        + ", supportedResponseTypes=" + supportedResponseTypes
        + ", supportedScopes=" + supportedScopes
        + ", supportedSubjectTypes=" + supportedSubjectTypes
        + ", supportedTokenEndpointAuthorizationMethods=" + supportedTokenEndpointAuthorizationMethods
        + ", supportedTokenEndpointAuthorizationSigningAlgorithms=" + supportedTokenEndpointAuthorizationSigningAlgorithms
        + ", supportedUiLocales=" + supportedUiLocales
        + ", tokenEndpoint=" + tokenEndpoint
        + ", userInfoEndpoint=" + userInfoEndpoint
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_GetOpenIdProviderConfigurationResponse", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.uaa.authorizations._GetOpenIdProviderConfigurationResponse {
    String authorizationEndpoint;
    Boolean claimsParameterSupported;
    String issuer;
    String javaWebKeySetEndpoint;
    String serviceDocumentation;
    List<String> supportedClaimTypes = Collections.emptyList();
    List<String> supportedClaims = Collections.emptyList();
    List<String> supportedIdTokenEncryptionAlgorithms = Collections.emptyList();
    List<String> supportedIdTokenSigningAlgorithms = Collections.emptyList();
    List<String> supportedResponseTypes = Collections.emptyList();
    List<String> supportedScopes = Collections.emptyList();
    List<String> supportedSubjectTypes = Collections.emptyList();
    List<String> supportedTokenEndpointAuthorizationMethods = Collections.emptyList();
    List<String> supportedTokenEndpointAuthorizationSigningAlgorithms = Collections.emptyList();
    List<Locale> supportedUiLocales = Collections.emptyList();
    String tokenEndpoint;
    String userInfoEndpoint;
    @JsonProperty("authorization_endpoint")
    public void setAuthorizationEndpoint(String authorizationEndpoint) {
      this.authorizationEndpoint = authorizationEndpoint;
    }
    @JsonProperty("claims_parameter_supported")
    public void setClaimsParameterSupported(Boolean claimsParameterSupported) {
      this.claimsParameterSupported = claimsParameterSupported;
    }
    @JsonProperty("issuer")
    public void setIssuer(String issuer) {
      this.issuer = issuer;
    }
    @JsonProperty("jwks_uri")
    public void setJavaWebKeySetEndpoint(String javaWebKeySetEndpoint) {
      this.javaWebKeySetEndpoint = javaWebKeySetEndpoint;
    }
    @JsonProperty("service_documentation")
    public void setServiceDocumentation(String serviceDocumentation) {
      this.serviceDocumentation = serviceDocumentation;
    }
    @JsonProperty("claim_types_supported")
    public void setSupportedClaimTypes(List<String> supportedClaimTypes) {
      this.supportedClaimTypes = supportedClaimTypes;
    }
    @JsonProperty("claims_supported")
    public void setSupportedClaims(List<String> supportedClaims) {
      this.supportedClaims = supportedClaims;
    }
    @JsonProperty("id_token_encryption_alg_values_supported")
    public void setSupportedIdTokenEncryptionAlgorithms(List<String> supportedIdTokenEncryptionAlgorithms) {
      this.supportedIdTokenEncryptionAlgorithms = supportedIdTokenEncryptionAlgorithms;
    }
    @JsonProperty("id_token_signing_alg_values_supported")
    public void setSupportedIdTokenSigningAlgorithms(List<String> supportedIdTokenSigningAlgorithms) {
      this.supportedIdTokenSigningAlgorithms = supportedIdTokenSigningAlgorithms;
    }
    @JsonProperty("response_types_supported")
    public void setSupportedResponseTypes(List<String> supportedResponseTypes) {
      this.supportedResponseTypes = supportedResponseTypes;
    }
    @JsonProperty("scopes_supported")
    public void setSupportedScopes(List<String> supportedScopes) {
      this.supportedScopes = supportedScopes;
    }
    @JsonProperty("subject_types_supported")
    public void setSupportedSubjectTypes(List<String> supportedSubjectTypes) {
      this.supportedSubjectTypes = supportedSubjectTypes;
    }
    @JsonProperty("token_endpoint_auth_methods_supported")
    public void setSupportedTokenEndpointAuthorizationMethods(List<String> supportedTokenEndpointAuthorizationMethods) {
      this.supportedTokenEndpointAuthorizationMethods = supportedTokenEndpointAuthorizationMethods;
    }
    @JsonProperty("token_endpoint_auth_signing_alg_values_supported")
    public void setSupportedTokenEndpointAuthorizationSigningAlgorithms(List<String> supportedTokenEndpointAuthorizationSigningAlgorithms) {
      this.supportedTokenEndpointAuthorizationSigningAlgorithms = supportedTokenEndpointAuthorizationSigningAlgorithms;
    }
    @JsonProperty("ui_locales_supported")
    public void setSupportedUiLocales(List<Locale> supportedUiLocales) {
      this.supportedUiLocales = supportedUiLocales;
    }
    @JsonProperty("token_endpoint")
    public void setTokenEndpoint(String tokenEndpoint) {
      this.tokenEndpoint = tokenEndpoint;
    }
    @JsonProperty("userinfo_endpoint")
    public void setUserInfoEndpoint(String userInfoEndpoint) {
      this.userInfoEndpoint = userInfoEndpoint;
    }
    @Override
    public String getAuthorizationEndpoint() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getClaimsParameterSupported() { throw new UnsupportedOperationException(); }
    @Override
    public String getIssuer() { throw new UnsupportedOperationException(); }
    @Override
    public String getJavaWebKeySetEndpoint() { throw new UnsupportedOperationException(); }
    @Override
    public String getServiceDocumentation() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getSupportedClaimTypes() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getSupportedClaims() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getSupportedIdTokenEncryptionAlgorithms() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getSupportedIdTokenSigningAlgorithms() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getSupportedResponseTypes() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getSupportedScopes() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getSupportedSubjectTypes() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getSupportedTokenEndpointAuthorizationMethods() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getSupportedTokenEndpointAuthorizationSigningAlgorithms() { throw new UnsupportedOperationException(); }
    @Override
    public List<Locale> getSupportedUiLocales() { throw new UnsupportedOperationException(); }
    @Override
    public String getTokenEndpoint() { throw new UnsupportedOperationException(); }
    @Override
    public String getUserInfoEndpoint() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static GetOpenIdProviderConfigurationResponse fromJson(Json json) {
    GetOpenIdProviderConfigurationResponse.Builder builder = GetOpenIdProviderConfigurationResponse.builder();
    if (json.authorizationEndpoint != null) {
      builder.authorizationEndpoint(json.authorizationEndpoint);
    }
    if (json.claimsParameterSupported != null) {
      builder.claimsParameterSupported(json.claimsParameterSupported);
    }
    if (json.issuer != null) {
      builder.issuer(json.issuer);
    }
    if (json.javaWebKeySetEndpoint != null) {
      builder.javaWebKeySetEndpoint(json.javaWebKeySetEndpoint);
    }
    if (json.serviceDocumentation != null) {
      builder.serviceDocumentation(json.serviceDocumentation);
    }
    if (json.supportedClaimTypes != null) {
      builder.addAllSupportedClaimTypes(json.supportedClaimTypes);
    }
    if (json.supportedClaims != null) {
      builder.addAllSupportedClaims(json.supportedClaims);
    }
    if (json.supportedIdTokenEncryptionAlgorithms != null) {
      builder.addAllSupportedIdTokenEncryptionAlgorithms(json.supportedIdTokenEncryptionAlgorithms);
    }
    if (json.supportedIdTokenSigningAlgorithms != null) {
      builder.addAllSupportedIdTokenSigningAlgorithms(json.supportedIdTokenSigningAlgorithms);
    }
    if (json.supportedResponseTypes != null) {
      builder.addAllSupportedResponseTypes(json.supportedResponseTypes);
    }
    if (json.supportedScopes != null) {
      builder.addAllSupportedScopes(json.supportedScopes);
    }
    if (json.supportedSubjectTypes != null) {
      builder.addAllSupportedSubjectTypes(json.supportedSubjectTypes);
    }
    if (json.supportedTokenEndpointAuthorizationMethods != null) {
      builder.addAllSupportedTokenEndpointAuthorizationMethods(json.supportedTokenEndpointAuthorizationMethods);
    }
    if (json.supportedTokenEndpointAuthorizationSigningAlgorithms != null) {
      builder.addAllSupportedTokenEndpointAuthorizationSigningAlgorithms(json.supportedTokenEndpointAuthorizationSigningAlgorithms);
    }
    if (json.supportedUiLocales != null) {
      builder.addAllSupportedUiLocales(json.supportedUiLocales);
    }
    if (json.tokenEndpoint != null) {
      builder.tokenEndpoint(json.tokenEndpoint);
    }
    if (json.userInfoEndpoint != null) {
      builder.userInfoEndpoint(json.userInfoEndpoint);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link GetOpenIdProviderConfigurationResponse GetOpenIdProviderConfigurationResponse}.
   * <pre>
   * GetOpenIdProviderConfigurationResponse.builder()
   *    .authorizationEndpoint(String) // required {@link GetOpenIdProviderConfigurationResponse#getAuthorizationEndpoint() authorizationEndpoint}
   *    .claimsParameterSupported(Boolean) // required {@link GetOpenIdProviderConfigurationResponse#getClaimsParameterSupported() claimsParameterSupported}
   *    .issuer(String) // required {@link GetOpenIdProviderConfigurationResponse#getIssuer() issuer}
   *    .javaWebKeySetEndpoint(String) // required {@link GetOpenIdProviderConfigurationResponse#getJavaWebKeySetEndpoint() javaWebKeySetEndpoint}
   *    .serviceDocumentation(String) // required {@link GetOpenIdProviderConfigurationResponse#getServiceDocumentation() serviceDocumentation}
   *    .supportedClaimType|addAllSupportedClaimTypes(String) // {@link GetOpenIdProviderConfigurationResponse#getSupportedClaimTypes() supportedClaimTypes} elements
   *    .supportedClaim|addAllSupportedClaims(String) // {@link GetOpenIdProviderConfigurationResponse#getSupportedClaims() supportedClaims} elements
   *    .supportedIdTokenEncryptionAlgorithm|addAllSupportedIdTokenEncryptionAlgorithms(String) // {@link GetOpenIdProviderConfigurationResponse#getSupportedIdTokenEncryptionAlgorithms() supportedIdTokenEncryptionAlgorithms} elements
   *    .supportedIdTokenSigningAlgorithm|addAllSupportedIdTokenSigningAlgorithms(String) // {@link GetOpenIdProviderConfigurationResponse#getSupportedIdTokenSigningAlgorithms() supportedIdTokenSigningAlgorithms} elements
   *    .supportedResponseType|addAllSupportedResponseTypes(String) // {@link GetOpenIdProviderConfigurationResponse#getSupportedResponseTypes() supportedResponseTypes} elements
   *    .supportedScope|addAllSupportedScopes(String) // {@link GetOpenIdProviderConfigurationResponse#getSupportedScopes() supportedScopes} elements
   *    .supportedSubjectType|addAllSupportedSubjectTypes(String) // {@link GetOpenIdProviderConfigurationResponse#getSupportedSubjectTypes() supportedSubjectTypes} elements
   *    .supportedTokenEndpointAuthorizationMethod|addAllSupportedTokenEndpointAuthorizationMethods(String) // {@link GetOpenIdProviderConfigurationResponse#getSupportedTokenEndpointAuthorizationMethods() supportedTokenEndpointAuthorizationMethods} elements
   *    .supportedTokenEndpointAuthorizationSigningAlgorithm|addAllSupportedTokenEndpointAuthorizationSigningAlgorithms(String) // {@link GetOpenIdProviderConfigurationResponse#getSupportedTokenEndpointAuthorizationSigningAlgorithms() supportedTokenEndpointAuthorizationSigningAlgorithms} elements
   *    .supportedUiLocale|addAllSupportedUiLocales(Locale) // {@link GetOpenIdProviderConfigurationResponse#getSupportedUiLocales() supportedUiLocales} elements
   *    .tokenEndpoint(String) // required {@link GetOpenIdProviderConfigurationResponse#getTokenEndpoint() tokenEndpoint}
   *    .userInfoEndpoint(String) // required {@link GetOpenIdProviderConfigurationResponse#getUserInfoEndpoint() userInfoEndpoint}
   *    .build();
   * </pre>
   * @return A new GetOpenIdProviderConfigurationResponse builder
   */
  public static GetOpenIdProviderConfigurationResponse.Builder builder() {
    return new GetOpenIdProviderConfigurationResponse.Builder();
  }

  /**
   * Builds instances of type {@link GetOpenIdProviderConfigurationResponse GetOpenIdProviderConfigurationResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_GetOpenIdProviderConfigurationResponse", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_AUTHORIZATION_ENDPOINT = 0x1L;
    private static final long INIT_BIT_CLAIMS_PARAMETER_SUPPORTED = 0x2L;
    private static final long INIT_BIT_ISSUER = 0x4L;
    private static final long INIT_BIT_JAVA_WEB_KEY_SET_ENDPOINT = 0x8L;
    private static final long INIT_BIT_SERVICE_DOCUMENTATION = 0x10L;
    private static final long INIT_BIT_TOKEN_ENDPOINT = 0x20L;
    private static final long INIT_BIT_USER_INFO_ENDPOINT = 0x40L;
    private long initBits = 0x7fL;

    private String authorizationEndpoint;
    private Boolean claimsParameterSupported;
    private String issuer;
    private String javaWebKeySetEndpoint;
    private String serviceDocumentation;
    private List<String> supportedClaimTypes = new ArrayList<String>();
    private List<String> supportedClaims = new ArrayList<String>();
    private List<String> supportedIdTokenEncryptionAlgorithms = new ArrayList<String>();
    private List<String> supportedIdTokenSigningAlgorithms = new ArrayList<String>();
    private List<String> supportedResponseTypes = new ArrayList<String>();
    private List<String> supportedScopes = new ArrayList<String>();
    private List<String> supportedSubjectTypes = new ArrayList<String>();
    private List<String> supportedTokenEndpointAuthorizationMethods = new ArrayList<String>();
    private List<String> supportedTokenEndpointAuthorizationSigningAlgorithms = new ArrayList<String>();
    private List<Locale> supportedUiLocales = new ArrayList<Locale>();
    private String tokenEndpoint;
    private String userInfoEndpoint;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetOpenIdProviderConfigurationResponse} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GetOpenIdProviderConfigurationResponse instance) {
      return from((_GetOpenIdProviderConfigurationResponse) instance);
    }

    /**
     * Copy abstract value type {@code _GetOpenIdProviderConfigurationResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_GetOpenIdProviderConfigurationResponse instance) {
      Objects.requireNonNull(instance, "instance");
      authorizationEndpoint(instance.getAuthorizationEndpoint());
      claimsParameterSupported(instance.getClaimsParameterSupported());
      issuer(instance.getIssuer());
      javaWebKeySetEndpoint(instance.getJavaWebKeySetEndpoint());
      serviceDocumentation(instance.getServiceDocumentation());
      addAllSupportedClaimTypes(instance.getSupportedClaimTypes());
      addAllSupportedClaims(instance.getSupportedClaims());
      addAllSupportedIdTokenEncryptionAlgorithms(instance.getSupportedIdTokenEncryptionAlgorithms());
      addAllSupportedIdTokenSigningAlgorithms(instance.getSupportedIdTokenSigningAlgorithms());
      addAllSupportedResponseTypes(instance.getSupportedResponseTypes());
      addAllSupportedScopes(instance.getSupportedScopes());
      addAllSupportedSubjectTypes(instance.getSupportedSubjectTypes());
      addAllSupportedTokenEndpointAuthorizationMethods(instance.getSupportedTokenEndpointAuthorizationMethods());
      addAllSupportedTokenEndpointAuthorizationSigningAlgorithms(instance.getSupportedTokenEndpointAuthorizationSigningAlgorithms());
      addAllSupportedUiLocales(instance.getSupportedUiLocales());
      tokenEndpoint(instance.getTokenEndpoint());
      userInfoEndpoint(instance.getUserInfoEndpoint());
      return this;
    }

    /**
     * Initializes the value for the {@link GetOpenIdProviderConfigurationResponse#getAuthorizationEndpoint() authorizationEndpoint} attribute.
     * @param authorizationEndpoint The value for authorizationEndpoint 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("authorization_endpoint")
    public final Builder authorizationEndpoint(String authorizationEndpoint) {
      this.authorizationEndpoint = Objects.requireNonNull(authorizationEndpoint, "authorizationEndpoint");
      initBits &= ~INIT_BIT_AUTHORIZATION_ENDPOINT;
      return this;
    }

    /**
     * Initializes the value for the {@link GetOpenIdProviderConfigurationResponse#getClaimsParameterSupported() claimsParameterSupported} attribute.
     * @param claimsParameterSupported The value for claimsParameterSupported 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("claims_parameter_supported")
    public final Builder claimsParameterSupported(Boolean claimsParameterSupported) {
      this.claimsParameterSupported = Objects.requireNonNull(claimsParameterSupported, "claimsParameterSupported");
      initBits &= ~INIT_BIT_CLAIMS_PARAMETER_SUPPORTED;
      return this;
    }

    /**
     * Initializes the value for the {@link GetOpenIdProviderConfigurationResponse#getIssuer() issuer} attribute.
     * @param issuer The value for issuer 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("issuer")
    public final Builder issuer(String issuer) {
      this.issuer = Objects.requireNonNull(issuer, "issuer");
      initBits &= ~INIT_BIT_ISSUER;
      return this;
    }

    /**
     * Initializes the value for the {@link GetOpenIdProviderConfigurationResponse#getJavaWebKeySetEndpoint() javaWebKeySetEndpoint} attribute.
     * @param javaWebKeySetEndpoint The value for javaWebKeySetEndpoint 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("jwks_uri")
    public final Builder javaWebKeySetEndpoint(String javaWebKeySetEndpoint) {
      this.javaWebKeySetEndpoint = Objects.requireNonNull(javaWebKeySetEndpoint, "javaWebKeySetEndpoint");
      initBits &= ~INIT_BIT_JAVA_WEB_KEY_SET_ENDPOINT;
      return this;
    }

    /**
     * Initializes the value for the {@link GetOpenIdProviderConfigurationResponse#getServiceDocumentation() serviceDocumentation} attribute.
     * @param serviceDocumentation The value for serviceDocumentation 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("service_documentation")
    public final Builder serviceDocumentation(String serviceDocumentation) {
      this.serviceDocumentation = Objects.requireNonNull(serviceDocumentation, "serviceDocumentation");
      initBits &= ~INIT_BIT_SERVICE_DOCUMENTATION;
      return this;
    }

    /**
     * Adds one element to {@link GetOpenIdProviderConfigurationResponse#getSupportedClaimTypes() supportedClaimTypes} list.
     * @param element A supportedClaimTypes element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder supportedClaimType(String element) {
      this.supportedClaimTypes.add(Objects.requireNonNull(element, "supportedClaimTypes element"));
      return this;
    }

    /**
     * Adds elements to {@link GetOpenIdProviderConfigurationResponse#getSupportedClaimTypes() supportedClaimTypes} list.
     * @param elements An array of supportedClaimTypes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder supportedClaimTypes(String... elements) {
      for (String element : elements) {
        this.supportedClaimTypes.add(Objects.requireNonNull(element, "supportedClaimTypes element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link GetOpenIdProviderConfigurationResponse#getSupportedClaimTypes() supportedClaimTypes} list.
     * @param elements An iterable of supportedClaimTypes elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("claim_types_supported")
    public final Builder supportedClaimTypes(Iterable<String> elements) {
      this.supportedClaimTypes.clear();
      return addAllSupportedClaimTypes(elements);
    }

    /**
     * Adds elements to {@link GetOpenIdProviderConfigurationResponse#getSupportedClaimTypes() supportedClaimTypes} list.
     * @param elements An iterable of supportedClaimTypes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllSupportedClaimTypes(Iterable<String> elements) {
      for (String element : elements) {
        this.supportedClaimTypes.add(Objects.requireNonNull(element, "supportedClaimTypes element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link GetOpenIdProviderConfigurationResponse#getSupportedClaims() supportedClaims} list.
     * @param element A supportedClaims element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder supportedClaim(String element) {
      this.supportedClaims.add(Objects.requireNonNull(element, "supportedClaims element"));
      return this;
    }

    /**
     * Adds elements to {@link GetOpenIdProviderConfigurationResponse#getSupportedClaims() supportedClaims} list.
     * @param elements An array of supportedClaims elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder supportedClaims(String... elements) {
      for (String element : elements) {
        this.supportedClaims.add(Objects.requireNonNull(element, "supportedClaims element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link GetOpenIdProviderConfigurationResponse#getSupportedClaims() supportedClaims} list.
     * @param elements An iterable of supportedClaims elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("claims_supported")
    public final Builder supportedClaims(Iterable<String> elements) {
      this.supportedClaims.clear();
      return addAllSupportedClaims(elements);
    }

    /**
     * Adds elements to {@link GetOpenIdProviderConfigurationResponse#getSupportedClaims() supportedClaims} list.
     * @param elements An iterable of supportedClaims elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllSupportedClaims(Iterable<String> elements) {
      for (String element : elements) {
        this.supportedClaims.add(Objects.requireNonNull(element, "supportedClaims element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link GetOpenIdProviderConfigurationResponse#getSupportedIdTokenEncryptionAlgorithms() supportedIdTokenEncryptionAlgorithms} list.
     * @param element A supportedIdTokenEncryptionAlgorithms element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder supportedIdTokenEncryptionAlgorithm(String element) {
      this.supportedIdTokenEncryptionAlgorithms.add(Objects.requireNonNull(element, "supportedIdTokenEncryptionAlgorithms element"));
      return this;
    }

    /**
     * Adds elements to {@link GetOpenIdProviderConfigurationResponse#getSupportedIdTokenEncryptionAlgorithms() supportedIdTokenEncryptionAlgorithms} list.
     * @param elements An array of supportedIdTokenEncryptionAlgorithms elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder supportedIdTokenEncryptionAlgorithms(String... elements) {
      for (String element : elements) {
        this.supportedIdTokenEncryptionAlgorithms.add(Objects.requireNonNull(element, "supportedIdTokenEncryptionAlgorithms element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link GetOpenIdProviderConfigurationResponse#getSupportedIdTokenEncryptionAlgorithms() supportedIdTokenEncryptionAlgorithms} list.
     * @param elements An iterable of supportedIdTokenEncryptionAlgorithms elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("id_token_encryption_alg_values_supported")
    public final Builder supportedIdTokenEncryptionAlgorithms(Iterable<String> elements) {
      this.supportedIdTokenEncryptionAlgorithms.clear();
      return addAllSupportedIdTokenEncryptionAlgorithms(elements);
    }

    /**
     * Adds elements to {@link GetOpenIdProviderConfigurationResponse#getSupportedIdTokenEncryptionAlgorithms() supportedIdTokenEncryptionAlgorithms} list.
     * @param elements An iterable of supportedIdTokenEncryptionAlgorithms elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllSupportedIdTokenEncryptionAlgorithms(Iterable<String> elements) {
      for (String element : elements) {
        this.supportedIdTokenEncryptionAlgorithms.add(Objects.requireNonNull(element, "supportedIdTokenEncryptionAlgorithms element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link GetOpenIdProviderConfigurationResponse#getSupportedIdTokenSigningAlgorithms() supportedIdTokenSigningAlgorithms} list.
     * @param element A supportedIdTokenSigningAlgorithms element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder supportedIdTokenSigningAlgorithm(String element) {
      this.supportedIdTokenSigningAlgorithms.add(Objects.requireNonNull(element, "supportedIdTokenSigningAlgorithms element"));
      return this;
    }

    /**
     * Adds elements to {@link GetOpenIdProviderConfigurationResponse#getSupportedIdTokenSigningAlgorithms() supportedIdTokenSigningAlgorithms} list.
     * @param elements An array of supportedIdTokenSigningAlgorithms elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder supportedIdTokenSigningAlgorithms(String... elements) {
      for (String element : elements) {
        this.supportedIdTokenSigningAlgorithms.add(Objects.requireNonNull(element, "supportedIdTokenSigningAlgorithms element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link GetOpenIdProviderConfigurationResponse#getSupportedIdTokenSigningAlgorithms() supportedIdTokenSigningAlgorithms} list.
     * @param elements An iterable of supportedIdTokenSigningAlgorithms elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("id_token_signing_alg_values_supported")
    public final Builder supportedIdTokenSigningAlgorithms(Iterable<String> elements) {
      this.supportedIdTokenSigningAlgorithms.clear();
      return addAllSupportedIdTokenSigningAlgorithms(elements);
    }

    /**
     * Adds elements to {@link GetOpenIdProviderConfigurationResponse#getSupportedIdTokenSigningAlgorithms() supportedIdTokenSigningAlgorithms} list.
     * @param elements An iterable of supportedIdTokenSigningAlgorithms elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllSupportedIdTokenSigningAlgorithms(Iterable<String> elements) {
      for (String element : elements) {
        this.supportedIdTokenSigningAlgorithms.add(Objects.requireNonNull(element, "supportedIdTokenSigningAlgorithms element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link GetOpenIdProviderConfigurationResponse#getSupportedResponseTypes() supportedResponseTypes} list.
     * @param element A supportedResponseTypes element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder supportedResponseType(String element) {
      this.supportedResponseTypes.add(Objects.requireNonNull(element, "supportedResponseTypes element"));
      return this;
    }

    /**
     * Adds elements to {@link GetOpenIdProviderConfigurationResponse#getSupportedResponseTypes() supportedResponseTypes} list.
     * @param elements An array of supportedResponseTypes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder supportedResponseTypes(String... elements) {
      for (String element : elements) {
        this.supportedResponseTypes.add(Objects.requireNonNull(element, "supportedResponseTypes element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link GetOpenIdProviderConfigurationResponse#getSupportedResponseTypes() supportedResponseTypes} list.
     * @param elements An iterable of supportedResponseTypes elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("response_types_supported")
    public final Builder supportedResponseTypes(Iterable<String> elements) {
      this.supportedResponseTypes.clear();
      return addAllSupportedResponseTypes(elements);
    }

    /**
     * Adds elements to {@link GetOpenIdProviderConfigurationResponse#getSupportedResponseTypes() supportedResponseTypes} list.
     * @param elements An iterable of supportedResponseTypes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllSupportedResponseTypes(Iterable<String> elements) {
      for (String element : elements) {
        this.supportedResponseTypes.add(Objects.requireNonNull(element, "supportedResponseTypes element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link GetOpenIdProviderConfigurationResponse#getSupportedScopes() supportedScopes} list.
     * @param element A supportedScopes element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder supportedScope(String element) {
      this.supportedScopes.add(Objects.requireNonNull(element, "supportedScopes element"));
      return this;
    }

    /**
     * Adds elements to {@link GetOpenIdProviderConfigurationResponse#getSupportedScopes() supportedScopes} list.
     * @param elements An array of supportedScopes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder supportedScopes(String... elements) {
      for (String element : elements) {
        this.supportedScopes.add(Objects.requireNonNull(element, "supportedScopes element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link GetOpenIdProviderConfigurationResponse#getSupportedScopes() supportedScopes} list.
     * @param elements An iterable of supportedScopes elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("scopes_supported")
    public final Builder supportedScopes(Iterable<String> elements) {
      this.supportedScopes.clear();
      return addAllSupportedScopes(elements);
    }

    /**
     * Adds elements to {@link GetOpenIdProviderConfigurationResponse#getSupportedScopes() supportedScopes} list.
     * @param elements An iterable of supportedScopes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllSupportedScopes(Iterable<String> elements) {
      for (String element : elements) {
        this.supportedScopes.add(Objects.requireNonNull(element, "supportedScopes element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link GetOpenIdProviderConfigurationResponse#getSupportedSubjectTypes() supportedSubjectTypes} list.
     * @param element A supportedSubjectTypes element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder supportedSubjectType(String element) {
      this.supportedSubjectTypes.add(Objects.requireNonNull(element, "supportedSubjectTypes element"));
      return this;
    }

    /**
     * Adds elements to {@link GetOpenIdProviderConfigurationResponse#getSupportedSubjectTypes() supportedSubjectTypes} list.
     * @param elements An array of supportedSubjectTypes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder supportedSubjectTypes(String... elements) {
      for (String element : elements) {
        this.supportedSubjectTypes.add(Objects.requireNonNull(element, "supportedSubjectTypes element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link GetOpenIdProviderConfigurationResponse#getSupportedSubjectTypes() supportedSubjectTypes} list.
     * @param elements An iterable of supportedSubjectTypes elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("subject_types_supported")
    public final Builder supportedSubjectTypes(Iterable<String> elements) {
      this.supportedSubjectTypes.clear();
      return addAllSupportedSubjectTypes(elements);
    }

    /**
     * Adds elements to {@link GetOpenIdProviderConfigurationResponse#getSupportedSubjectTypes() supportedSubjectTypes} list.
     * @param elements An iterable of supportedSubjectTypes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllSupportedSubjectTypes(Iterable<String> elements) {
      for (String element : elements) {
        this.supportedSubjectTypes.add(Objects.requireNonNull(element, "supportedSubjectTypes element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link GetOpenIdProviderConfigurationResponse#getSupportedTokenEndpointAuthorizationMethods() supportedTokenEndpointAuthorizationMethods} list.
     * @param element A supportedTokenEndpointAuthorizationMethods element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder supportedTokenEndpointAuthorizationMethod(String element) {
      this.supportedTokenEndpointAuthorizationMethods.add(Objects.requireNonNull(element, "supportedTokenEndpointAuthorizationMethods element"));
      return this;
    }

    /**
     * Adds elements to {@link GetOpenIdProviderConfigurationResponse#getSupportedTokenEndpointAuthorizationMethods() supportedTokenEndpointAuthorizationMethods} list.
     * @param elements An array of supportedTokenEndpointAuthorizationMethods elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder supportedTokenEndpointAuthorizationMethods(String... elements) {
      for (String element : elements) {
        this.supportedTokenEndpointAuthorizationMethods.add(Objects.requireNonNull(element, "supportedTokenEndpointAuthorizationMethods element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link GetOpenIdProviderConfigurationResponse#getSupportedTokenEndpointAuthorizationMethods() supportedTokenEndpointAuthorizationMethods} list.
     * @param elements An iterable of supportedTokenEndpointAuthorizationMethods elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("token_endpoint_auth_methods_supported")
    public final Builder supportedTokenEndpointAuthorizationMethods(Iterable<String> elements) {
      this.supportedTokenEndpointAuthorizationMethods.clear();
      return addAllSupportedTokenEndpointAuthorizationMethods(elements);
    }

    /**
     * Adds elements to {@link GetOpenIdProviderConfigurationResponse#getSupportedTokenEndpointAuthorizationMethods() supportedTokenEndpointAuthorizationMethods} list.
     * @param elements An iterable of supportedTokenEndpointAuthorizationMethods elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllSupportedTokenEndpointAuthorizationMethods(Iterable<String> elements) {
      for (String element : elements) {
        this.supportedTokenEndpointAuthorizationMethods.add(Objects.requireNonNull(element, "supportedTokenEndpointAuthorizationMethods element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link GetOpenIdProviderConfigurationResponse#getSupportedTokenEndpointAuthorizationSigningAlgorithms() supportedTokenEndpointAuthorizationSigningAlgorithms} list.
     * @param element A supportedTokenEndpointAuthorizationSigningAlgorithms element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder supportedTokenEndpointAuthorizationSigningAlgorithm(String element) {
      this.supportedTokenEndpointAuthorizationSigningAlgorithms.add(Objects.requireNonNull(element, "supportedTokenEndpointAuthorizationSigningAlgorithms element"));
      return this;
    }

    /**
     * Adds elements to {@link GetOpenIdProviderConfigurationResponse#getSupportedTokenEndpointAuthorizationSigningAlgorithms() supportedTokenEndpointAuthorizationSigningAlgorithms} list.
     * @param elements An array of supportedTokenEndpointAuthorizationSigningAlgorithms elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder supportedTokenEndpointAuthorizationSigningAlgorithms(String... elements) {
      for (String element : elements) {
        this.supportedTokenEndpointAuthorizationSigningAlgorithms.add(Objects.requireNonNull(element, "supportedTokenEndpointAuthorizationSigningAlgorithms element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link GetOpenIdProviderConfigurationResponse#getSupportedTokenEndpointAuthorizationSigningAlgorithms() supportedTokenEndpointAuthorizationSigningAlgorithms} list.
     * @param elements An iterable of supportedTokenEndpointAuthorizationSigningAlgorithms elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("token_endpoint_auth_signing_alg_values_supported")
    public final Builder supportedTokenEndpointAuthorizationSigningAlgorithms(Iterable<String> elements) {
      this.supportedTokenEndpointAuthorizationSigningAlgorithms.clear();
      return addAllSupportedTokenEndpointAuthorizationSigningAlgorithms(elements);
    }

    /**
     * Adds elements to {@link GetOpenIdProviderConfigurationResponse#getSupportedTokenEndpointAuthorizationSigningAlgorithms() supportedTokenEndpointAuthorizationSigningAlgorithms} list.
     * @param elements An iterable of supportedTokenEndpointAuthorizationSigningAlgorithms elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllSupportedTokenEndpointAuthorizationSigningAlgorithms(Iterable<String> elements) {
      for (String element : elements) {
        this.supportedTokenEndpointAuthorizationSigningAlgorithms.add(Objects.requireNonNull(element, "supportedTokenEndpointAuthorizationSigningAlgorithms element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link GetOpenIdProviderConfigurationResponse#getSupportedUiLocales() supportedUiLocales} list.
     * @param element A supportedUiLocales element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder supportedUiLocale(Locale element) {
      this.supportedUiLocales.add(Objects.requireNonNull(element, "supportedUiLocales element"));
      return this;
    }

    /**
     * Adds elements to {@link GetOpenIdProviderConfigurationResponse#getSupportedUiLocales() supportedUiLocales} list.
     * @param elements An array of supportedUiLocales elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder supportedUiLocales(Locale... elements) {
      for (Locale element : elements) {
        this.supportedUiLocales.add(Objects.requireNonNull(element, "supportedUiLocales element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link GetOpenIdProviderConfigurationResponse#getSupportedUiLocales() supportedUiLocales} list.
     * @param elements An iterable of supportedUiLocales elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("ui_locales_supported")
    public final Builder supportedUiLocales(Iterable<? extends Locale> elements) {
      this.supportedUiLocales.clear();
      return addAllSupportedUiLocales(elements);
    }

    /**
     * Adds elements to {@link GetOpenIdProviderConfigurationResponse#getSupportedUiLocales() supportedUiLocales} list.
     * @param elements An iterable of supportedUiLocales elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllSupportedUiLocales(Iterable<? extends Locale> elements) {
      for (Locale element : elements) {
        this.supportedUiLocales.add(Objects.requireNonNull(element, "supportedUiLocales element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link GetOpenIdProviderConfigurationResponse#getTokenEndpoint() tokenEndpoint} attribute.
     * @param tokenEndpoint The value for tokenEndpoint 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("token_endpoint")
    public final Builder tokenEndpoint(String tokenEndpoint) {
      this.tokenEndpoint = Objects.requireNonNull(tokenEndpoint, "tokenEndpoint");
      initBits &= ~INIT_BIT_TOKEN_ENDPOINT;
      return this;
    }

    /**
     * Initializes the value for the {@link GetOpenIdProviderConfigurationResponse#getUserInfoEndpoint() userInfoEndpoint} attribute.
     * @param userInfoEndpoint The value for userInfoEndpoint 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("userinfo_endpoint")
    public final Builder userInfoEndpoint(String userInfoEndpoint) {
      this.userInfoEndpoint = Objects.requireNonNull(userInfoEndpoint, "userInfoEndpoint");
      initBits &= ~INIT_BIT_USER_INFO_ENDPOINT;
      return this;
    }

    /**
     * Builds a new {@link GetOpenIdProviderConfigurationResponse GetOpenIdProviderConfigurationResponse}.
     * @return An immutable instance of GetOpenIdProviderConfigurationResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GetOpenIdProviderConfigurationResponse build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new GetOpenIdProviderConfigurationResponse(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_AUTHORIZATION_ENDPOINT) != 0) attributes.add("authorizationEndpoint");
      if ((initBits & INIT_BIT_CLAIMS_PARAMETER_SUPPORTED) != 0) attributes.add("claimsParameterSupported");
      if ((initBits & INIT_BIT_ISSUER) != 0) attributes.add("issuer");
      if ((initBits & INIT_BIT_JAVA_WEB_KEY_SET_ENDPOINT) != 0) attributes.add("javaWebKeySetEndpoint");
      if ((initBits & INIT_BIT_SERVICE_DOCUMENTATION) != 0) attributes.add("serviceDocumentation");
      if ((initBits & INIT_BIT_TOKEN_ENDPOINT) != 0) attributes.add("tokenEndpoint");
      if ((initBits & INIT_BIT_USER_INFO_ENDPOINT) != 0) attributes.add("userInfoEndpoint");
      return "Cannot build GetOpenIdProviderConfigurationResponse, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
