package org.cloudfoundry.uaa.clients;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.IdentityZoned;
import org.immutables.value.Generated;

/**
 * The request payload for the Batch Delete Clients operation
 */
@Generated(from = "_BatchDeleteClientsRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class BatchDeleteClientsRequest extends org.cloudfoundry.uaa.clients._BatchDeleteClientsRequest {
  private final @Nullable String identityZoneId;
  private final @Nullable String identityZoneSubdomain;
  private final List<String> clientIds;

  private BatchDeleteClientsRequest(BatchDeleteClientsRequest.Builder builder) {
    this.identityZoneId = builder.identityZoneId;
    this.identityZoneSubdomain = builder.identityZoneSubdomain;
    this.clientIds = createUnmodifiableList(true, builder.clientIds);
  }

  /**
   * Returns the identity zone id
   * @return the identity zone id
   */
  @JsonProperty("identityZoneId")
  @JsonIgnore
  @Override
  public @Nullable String getIdentityZoneId() {
    return identityZoneId;
  }

  /**
   * Returns the identity zone subdomain
   * @return the identity zone subdomain
   */
  @JsonProperty("identityZoneSubdomain")
  @JsonIgnore
  @Override
  public @Nullable String getIdentityZoneSubdomain() {
    return identityZoneSubdomain;
  }

  /**
   * A list of identifiers of clients to delete
   */
  @JsonProperty("clientIds")
  @JsonIgnore
  @Override
  public List<String> getClientIds() {
    return clientIds;
  }

  /**
   * This instance is equal to all instances of {@code BatchDeleteClientsRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof BatchDeleteClientsRequest
        && equalTo((BatchDeleteClientsRequest) another);
  }

  private boolean equalTo(BatchDeleteClientsRequest another) {
    return Objects.equals(identityZoneId, another.identityZoneId)
        && Objects.equals(identityZoneSubdomain, another.identityZoneSubdomain)
        && clientIds.equals(another.clientIds);
  }

  /**
   * Computes a hash code from attributes: {@code identityZoneId}, {@code identityZoneSubdomain}, {@code clientIds}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(identityZoneId);
    h += (h << 5) + Objects.hashCode(identityZoneSubdomain);
    h += (h << 5) + clientIds.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code BatchDeleteClientsRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "BatchDeleteClientsRequest{"
        + "identityZoneId=" + identityZoneId
        + ", identityZoneSubdomain=" + identityZoneSubdomain
        + ", clientIds=" + clientIds
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_BatchDeleteClientsRequest", generator = "Immutables")
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.uaa.clients._BatchDeleteClientsRequest {
    String identityZoneId;
    String identityZoneSubdomain;
    List<String> clientIds = Collections.emptyList();
    @JsonProperty("identityZoneId")
    @JsonIgnore
    public void setIdentityZoneId(@Nullable String identityZoneId) {
      this.identityZoneId = identityZoneId;
    }
    @JsonProperty("identityZoneSubdomain")
    @JsonIgnore
    public void setIdentityZoneSubdomain(@Nullable String identityZoneSubdomain) {
      this.identityZoneSubdomain = identityZoneSubdomain;
    }
    @JsonProperty("clientIds")
    @JsonIgnore
    public void setClientIds(List<String> clientIds) {
      this.clientIds = clientIds;
    }
    @Override
    public String getIdentityZoneId() { throw new UnsupportedOperationException(); }
    @Override
    public String getIdentityZoneSubdomain() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getClientIds() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static BatchDeleteClientsRequest fromJson(Json json) {
    BatchDeleteClientsRequest.Builder builder = BatchDeleteClientsRequest.builder();
    if (json.identityZoneId != null) {
      builder.identityZoneId(json.identityZoneId);
    }
    if (json.identityZoneSubdomain != null) {
      builder.identityZoneSubdomain(json.identityZoneSubdomain);
    }
    if (json.clientIds != null) {
      builder.addAllClientIds(json.clientIds);
    }
    return builder.build();
  }

  private static BatchDeleteClientsRequest validate(BatchDeleteClientsRequest instance) {
    instance.checkClientIds();
    return instance;
  }

  /**
   * Creates a builder for {@link BatchDeleteClientsRequest BatchDeleteClientsRequest}.
   * <pre>
   * BatchDeleteClientsRequest.builder()
   *    .identityZoneId(String | null) // nullable {@link BatchDeleteClientsRequest#getIdentityZoneId() identityZoneId}
   *    .identityZoneSubdomain(String | null) // nullable {@link BatchDeleteClientsRequest#getIdentityZoneSubdomain() identityZoneSubdomain}
   *    .clientId|addAllClientIds(String) // {@link BatchDeleteClientsRequest#getClientIds() clientIds} elements
   *    .build();
   * </pre>
   * @return A new BatchDeleteClientsRequest builder
   */
  public static BatchDeleteClientsRequest.Builder builder() {
    return new BatchDeleteClientsRequest.Builder();
  }

  /**
   * Builds instances of type {@link BatchDeleteClientsRequest BatchDeleteClientsRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_BatchDeleteClientsRequest", generator = "Immutables")
  public static final class Builder {
    private String identityZoneId;
    private String identityZoneSubdomain;
    private List<String> clientIds = new ArrayList<String>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.uaa.IdentityZoned} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(IdentityZoned instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code BatchDeleteClientsRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(BatchDeleteClientsRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _BatchDeleteClientsRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_BatchDeleteClientsRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof IdentityZoned) {
        IdentityZoned instance = (IdentityZoned) object;
        String identityZoneSubdomainValue = instance.getIdentityZoneSubdomain();
        if (identityZoneSubdomainValue != null) {
          identityZoneSubdomain(identityZoneSubdomainValue);
        }
        String identityZoneIdValue = instance.getIdentityZoneId();
        if (identityZoneIdValue != null) {
          identityZoneId(identityZoneIdValue);
        }
      }
      if (object instanceof org.cloudfoundry.uaa.clients._BatchDeleteClientsRequest) {
        org.cloudfoundry.uaa.clients._BatchDeleteClientsRequest instance = (org.cloudfoundry.uaa.clients._BatchDeleteClientsRequest) object;
        addAllClientIds(instance.getClientIds());
      }
    }

    /**
     * Initializes the value for the {@link BatchDeleteClientsRequest#getIdentityZoneId() identityZoneId} attribute.
     * @param identityZoneId The value for identityZoneId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder identityZoneId(@Nullable String identityZoneId) {
      this.identityZoneId = identityZoneId;
      return this;
    }

    /**
     * Initializes the value for the {@link BatchDeleteClientsRequest#getIdentityZoneSubdomain() identityZoneSubdomain} attribute.
     * @param identityZoneSubdomain The value for identityZoneSubdomain (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder identityZoneSubdomain(@Nullable String identityZoneSubdomain) {
      this.identityZoneSubdomain = identityZoneSubdomain;
      return this;
    }

    /**
     * Adds one element to {@link BatchDeleteClientsRequest#getClientIds() clientIds} list.
     * @param element A clientIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder clientId(String element) {
      this.clientIds.add(Objects.requireNonNull(element, "clientIds element"));
      return this;
    }

    /**
     * Adds elements to {@link BatchDeleteClientsRequest#getClientIds() clientIds} list.
     * @param elements An array of clientIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder clientIds(String... elements) {
      for (String element : elements) {
        this.clientIds.add(Objects.requireNonNull(element, "clientIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link BatchDeleteClientsRequest#getClientIds() clientIds} list.
     * @param elements An iterable of clientIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder clientIds(Iterable<String> elements) {
      this.clientIds.clear();
      return addAllClientIds(elements);
    }

    /**
     * Adds elements to {@link BatchDeleteClientsRequest#getClientIds() clientIds} list.
     * @param elements An iterable of clientIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllClientIds(Iterable<String> elements) {
      for (String element : elements) {
        this.clientIds.add(Objects.requireNonNull(element, "clientIds element"));
      }
      return this;
    }

    /**
     * Builds a new {@link BatchDeleteClientsRequest BatchDeleteClientsRequest}.
     * @return An immutable instance of BatchDeleteClientsRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public BatchDeleteClientsRequest build() {
      return BatchDeleteClientsRequest.validate(new BatchDeleteClientsRequest(this));
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
