package org.cloudfoundry.uaa.clients;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The payload for the delete client action
 */
@Generated(from = "_DeleteClientAction", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class DeleteClientAction extends org.cloudfoundry.uaa.clients._DeleteClientAction {
  private transient final String action;
  private final String clientId;

  private DeleteClientAction(DeleteClientAction.Builder builder) {
    this.clientId = builder.clientId;
    this.action = Objects.requireNonNull(super.getAction(), "action");
  }

  /**
   * @return The computed-at-construction value of the {@code action} attribute
   */
  @Override
  public String getAction() {
    return action;
  }

  /**
   * The client id
   */
  @Override
  public String getClientId() {
    return clientId;
  }

  /**
   * This instance is equal to all instances of {@code DeleteClientAction} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof DeleteClientAction
        && equalTo((DeleteClientAction) another);
  }

  private boolean equalTo(DeleteClientAction another) {
    return action.equals(another.action)
        && clientId.equals(another.clientId);
  }

  /**
   * Computes a hash code from attributes: {@code action}, {@code clientId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + action.hashCode();
    h += (h << 5) + clientId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code DeleteClientAction} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DeleteClientAction{"
        + "action=" + action
        + ", clientId=" + clientId
        + "}";
  }

  /**
   * Creates a builder for {@link DeleteClientAction DeleteClientAction}.
   * <pre>
   * DeleteClientAction.builder()
   *    .clientId(String) // required {@link DeleteClientAction#getClientId() clientId}
   *    .build();
   * </pre>
   * @return A new DeleteClientAction builder
   */
  public static DeleteClientAction.Builder builder() {
    return new DeleteClientAction.Builder();
  }

  /**
   * Builds instances of type {@link DeleteClientAction DeleteClientAction}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_DeleteClientAction", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_CLIENT_ID = 0x1L;
    private long initBits = 0x1L;

    private String clientId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DeleteClientAction} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DeleteClientAction instance) {
      return from((_DeleteClientAction) instance);
    }

    /**
     * Copy abstract value type {@code _DeleteClientAction} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_DeleteClientAction instance) {
      Objects.requireNonNull(instance, "instance");
      clientId(instance.getClientId());
      return this;
    }

    /**
     * Initializes the value for the {@link DeleteClientAction#getClientId() clientId} attribute.
     * @param clientId The value for clientId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder clientId(String clientId) {
      this.clientId = Objects.requireNonNull(clientId, "clientId");
      initBits &= ~INIT_BIT_CLIENT_ID;
      return this;
    }

    /**
     * Builds a new {@link DeleteClientAction DeleteClientAction}.
     * @return An immutable instance of DeleteClientAction
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public DeleteClientAction build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new DeleteClientAction(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CLIENT_ID) != 0) attributes.add("clientId");
      return "Cannot build DeleteClientAction, some of required attributes are not set " + attributes;
    }
  }
}
