package org.cloudfoundry.uaa.groups;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.IdentityZoned;
import org.immutables.value.Generated;

/**
 * The request payload for the list members operation
 */
@Generated(from = "_ListMembersRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ListMembersRequest extends org.cloudfoundry.uaa.groups._ListMembersRequest {
  private final @Nullable String identityZoneId;
  private final @Nullable String identityZoneSubdomain;
  private final String groupId;
  private final @Nullable Boolean returnEntities;

  private ListMembersRequest(ListMembersRequest.Builder builder) {
    this.identityZoneId = builder.identityZoneId;
    this.identityZoneSubdomain = builder.identityZoneSubdomain;
    this.groupId = builder.groupId;
    this.returnEntities = builder.returnEntities;
  }

  /**
   * Returns the identity zone id
   * @return the identity zone id
   */
  @Override
  public @Nullable String getIdentityZoneId() {
    return identityZoneId;
  }

  /**
   * Returns the identity zone subdomain
   * @return the identity zone subdomain
   */
  @Override
  public @Nullable String getIdentityZoneSubdomain() {
    return identityZoneSubdomain;
  }

  /**
   * The group id
   */
  @Override
  public String getGroupId() {
    return groupId;
  }

  /**
   * Set to true to return the SCIM entities that have membership in the group
   */
  @Override
  public @Nullable Boolean getReturnEntities() {
    return returnEntities;
  }

  /**
   * This instance is equal to all instances of {@code ListMembersRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ListMembersRequest
        && equalTo((ListMembersRequest) another);
  }

  private boolean equalTo(ListMembersRequest another) {
    return Objects.equals(identityZoneId, another.identityZoneId)
        && Objects.equals(identityZoneSubdomain, another.identityZoneSubdomain)
        && groupId.equals(another.groupId)
        && Objects.equals(returnEntities, another.returnEntities);
  }

  /**
   * Computes a hash code from attributes: {@code identityZoneId}, {@code identityZoneSubdomain}, {@code groupId}, {@code returnEntities}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(identityZoneId);
    h += (h << 5) + Objects.hashCode(identityZoneSubdomain);
    h += (h << 5) + groupId.hashCode();
    h += (h << 5) + Objects.hashCode(returnEntities);
    return h;
  }

  /**
   * Prints the immutable value {@code ListMembersRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ListMembersRequest{"
        + "identityZoneId=" + identityZoneId
        + ", identityZoneSubdomain=" + identityZoneSubdomain
        + ", groupId=" + groupId
        + ", returnEntities=" + returnEntities
        + "}";
  }

  /**
   * Creates a builder for {@link ListMembersRequest ListMembersRequest}.
   * <pre>
   * ListMembersRequest.builder()
   *    .identityZoneId(String | null) // nullable {@link ListMembersRequest#getIdentityZoneId() identityZoneId}
   *    .identityZoneSubdomain(String | null) // nullable {@link ListMembersRequest#getIdentityZoneSubdomain() identityZoneSubdomain}
   *    .groupId(String) // required {@link ListMembersRequest#getGroupId() groupId}
   *    .returnEntities(Boolean | null) // nullable {@link ListMembersRequest#getReturnEntities() returnEntities}
   *    .build();
   * </pre>
   * @return A new ListMembersRequest builder
   */
  public static ListMembersRequest.Builder builder() {
    return new ListMembersRequest.Builder();
  }

  /**
   * Builds instances of type {@link ListMembersRequest ListMembersRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ListMembersRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_GROUP_ID = 0x1L;
    private long initBits = 0x1L;

    private String identityZoneId;
    private String identityZoneSubdomain;
    private String groupId;
    private Boolean returnEntities;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.uaa.IdentityZoned} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(IdentityZoned instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code ListMembersRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ListMembersRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _ListMembersRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_ListMembersRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof IdentityZoned) {
        IdentityZoned instance = (IdentityZoned) object;
        String identityZoneSubdomainValue = instance.getIdentityZoneSubdomain();
        if (identityZoneSubdomainValue != null) {
          identityZoneSubdomain(identityZoneSubdomainValue);
        }
        String identityZoneIdValue = instance.getIdentityZoneId();
        if (identityZoneIdValue != null) {
          identityZoneId(identityZoneIdValue);
        }
      }
      if (object instanceof org.cloudfoundry.uaa.groups._ListMembersRequest) {
        org.cloudfoundry.uaa.groups._ListMembersRequest instance = (org.cloudfoundry.uaa.groups._ListMembersRequest) object;
        Boolean returnEntitiesValue = instance.getReturnEntities();
        if (returnEntitiesValue != null) {
          returnEntities(returnEntitiesValue);
        }
        groupId(instance.getGroupId());
      }
    }

    /**
     * Initializes the value for the {@link ListMembersRequest#getIdentityZoneId() identityZoneId} attribute.
     * @param identityZoneId The value for identityZoneId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder identityZoneId(@Nullable String identityZoneId) {
      this.identityZoneId = identityZoneId;
      return this;
    }

    /**
     * Initializes the value for the {@link ListMembersRequest#getIdentityZoneSubdomain() identityZoneSubdomain} attribute.
     * @param identityZoneSubdomain The value for identityZoneSubdomain (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder identityZoneSubdomain(@Nullable String identityZoneSubdomain) {
      this.identityZoneSubdomain = identityZoneSubdomain;
      return this;
    }

    /**
     * Initializes the value for the {@link ListMembersRequest#getGroupId() groupId} attribute.
     * @param groupId The value for groupId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder groupId(String groupId) {
      this.groupId = Objects.requireNonNull(groupId, "groupId");
      initBits &= ~INIT_BIT_GROUP_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link ListMembersRequest#getReturnEntities() returnEntities} attribute.
     * @param returnEntities The value for returnEntities (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder returnEntities(@Nullable Boolean returnEntities) {
      this.returnEntities = returnEntities;
      return this;
    }

    /**
     * Builds a new {@link ListMembersRequest ListMembersRequest}.
     * @return An immutable instance of ListMembersRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ListMembersRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ListMembersRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_GROUP_ID) != 0) attributes.add("groupId");
      return "Cannot build ListMembersRequest, some of required attributes are not set " + attributes;
    }
  }
}
