package org.cloudfoundry.uaa.groups;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.IdentityZoned;
import org.immutables.value.Generated;

/**
 * The request payload for the remove member
 */
@Generated(from = "_RemoveMemberRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class RemoveMemberRequest extends org.cloudfoundry.uaa.groups._RemoveMemberRequest {
  private final @Nullable String identityZoneId;
  private final @Nullable String identityZoneSubdomain;
  private final String groupId;
  private final String memberId;

  private RemoveMemberRequest(RemoveMemberRequest.Builder builder) {
    this.identityZoneId = builder.identityZoneId;
    this.identityZoneSubdomain = builder.identityZoneSubdomain;
    this.groupId = builder.groupId;
    this.memberId = builder.memberId;
  }

  /**
   * Returns the identity zone id
   * @return the identity zone id
   */
  @Override
  public @Nullable String getIdentityZoneId() {
    return identityZoneId;
  }

  /**
   * Returns the identity zone subdomain
   * @return the identity zone subdomain
   */
  @Override
  public @Nullable String getIdentityZoneSubdomain() {
    return identityZoneSubdomain;
  }

  /**
   * The group id
   */
  @Override
  public String getGroupId() {
    return groupId;
  }

  /**
   * The member id
   */
  @Override
  public String getMemberId() {
    return memberId;
  }

  /**
   * This instance is equal to all instances of {@code RemoveMemberRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof RemoveMemberRequest
        && equalTo((RemoveMemberRequest) another);
  }

  private boolean equalTo(RemoveMemberRequest another) {
    return Objects.equals(identityZoneId, another.identityZoneId)
        && Objects.equals(identityZoneSubdomain, another.identityZoneSubdomain)
        && groupId.equals(another.groupId)
        && memberId.equals(another.memberId);
  }

  /**
   * Computes a hash code from attributes: {@code identityZoneId}, {@code identityZoneSubdomain}, {@code groupId}, {@code memberId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(identityZoneId);
    h += (h << 5) + Objects.hashCode(identityZoneSubdomain);
    h += (h << 5) + groupId.hashCode();
    h += (h << 5) + memberId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code RemoveMemberRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "RemoveMemberRequest{"
        + "identityZoneId=" + identityZoneId
        + ", identityZoneSubdomain=" + identityZoneSubdomain
        + ", groupId=" + groupId
        + ", memberId=" + memberId
        + "}";
  }

  /**
   * Creates a builder for {@link RemoveMemberRequest RemoveMemberRequest}.
   * <pre>
   * RemoveMemberRequest.builder()
   *    .identityZoneId(String | null) // nullable {@link RemoveMemberRequest#getIdentityZoneId() identityZoneId}
   *    .identityZoneSubdomain(String | null) // nullable {@link RemoveMemberRequest#getIdentityZoneSubdomain() identityZoneSubdomain}
   *    .groupId(String) // required {@link RemoveMemberRequest#getGroupId() groupId}
   *    .memberId(String) // required {@link RemoveMemberRequest#getMemberId() memberId}
   *    .build();
   * </pre>
   * @return A new RemoveMemberRequest builder
   */
  public static RemoveMemberRequest.Builder builder() {
    return new RemoveMemberRequest.Builder();
  }

  /**
   * Builds instances of type {@link RemoveMemberRequest RemoveMemberRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_RemoveMemberRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_GROUP_ID = 0x1L;
    private static final long INIT_BIT_MEMBER_ID = 0x2L;
    private long initBits = 0x3L;

    private String identityZoneId;
    private String identityZoneSubdomain;
    private String groupId;
    private String memberId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.uaa.IdentityZoned} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(IdentityZoned instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code RemoveMemberRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(RemoveMemberRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _RemoveMemberRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_RemoveMemberRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof IdentityZoned) {
        IdentityZoned instance = (IdentityZoned) object;
        String identityZoneSubdomainValue = instance.getIdentityZoneSubdomain();
        if (identityZoneSubdomainValue != null) {
          identityZoneSubdomain(identityZoneSubdomainValue);
        }
        String identityZoneIdValue = instance.getIdentityZoneId();
        if (identityZoneIdValue != null) {
          identityZoneId(identityZoneIdValue);
        }
      }
      if (object instanceof org.cloudfoundry.uaa.groups._RemoveMemberRequest) {
        org.cloudfoundry.uaa.groups._RemoveMemberRequest instance = (org.cloudfoundry.uaa.groups._RemoveMemberRequest) object;
        groupId(instance.getGroupId());
        memberId(instance.getMemberId());
      }
    }

    /**
     * Initializes the value for the {@link RemoveMemberRequest#getIdentityZoneId() identityZoneId} attribute.
     * @param identityZoneId The value for identityZoneId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder identityZoneId(@Nullable String identityZoneId) {
      this.identityZoneId = identityZoneId;
      return this;
    }

    /**
     * Initializes the value for the {@link RemoveMemberRequest#getIdentityZoneSubdomain() identityZoneSubdomain} attribute.
     * @param identityZoneSubdomain The value for identityZoneSubdomain (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder identityZoneSubdomain(@Nullable String identityZoneSubdomain) {
      this.identityZoneSubdomain = identityZoneSubdomain;
      return this;
    }

    /**
     * Initializes the value for the {@link RemoveMemberRequest#getGroupId() groupId} attribute.
     * @param groupId The value for groupId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder groupId(String groupId) {
      this.groupId = Objects.requireNonNull(groupId, "groupId");
      initBits &= ~INIT_BIT_GROUP_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link RemoveMemberRequest#getMemberId() memberId} attribute.
     * @param memberId The value for memberId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder memberId(String memberId) {
      this.memberId = Objects.requireNonNull(memberId, "memberId");
      initBits &= ~INIT_BIT_MEMBER_ID;
      return this;
    }

    /**
     * Builds a new {@link RemoveMemberRequest RemoveMemberRequest}.
     * @return An immutable instance of RemoveMemberRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public RemoveMemberRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new RemoveMemberRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_GROUP_ID) != 0) attributes.add("groupId");
      if ((initBits & INIT_BIT_MEMBER_ID) != 0) attributes.add("memberId");
      return "Cannot build RemoveMemberRequest, some of required attributes are not set " + attributes;
    }
  }
}
