package org.cloudfoundry.uaa.groups;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.IdentityZoned;
import org.immutables.value.Generated;

/**
 * The request payload for the unmap external group by group display name request
 */
@Generated(from = "_UnmapExternalGroupByGroupDisplayNameRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class UnmapExternalGroupByGroupDisplayNameRequest
    extends org.cloudfoundry.uaa.groups._UnmapExternalGroupByGroupDisplayNameRequest {
  private final @Nullable String identityZoneId;
  private final @Nullable String identityZoneSubdomain;
  private final String externalGroup;
  private final String groupDisplayName;
  private final String origin;

  private UnmapExternalGroupByGroupDisplayNameRequest(UnmapExternalGroupByGroupDisplayNameRequest.Builder builder) {
    this.identityZoneId = builder.identityZoneId;
    this.identityZoneSubdomain = builder.identityZoneSubdomain;
    this.externalGroup = builder.externalGroup;
    this.groupDisplayName = builder.groupDisplayName;
    this.origin = builder.origin;
  }

  /**
   * Returns the identity zone id
   * @return the identity zone id
   */
  @Override
  public @Nullable String getIdentityZoneId() {
    return identityZoneId;
  }

  /**
   * Returns the identity zone subdomain
   * @return the identity zone subdomain
   */
  @Override
  public @Nullable String getIdentityZoneSubdomain() {
    return identityZoneSubdomain;
  }

  /**
   * The identifier for the group in external identity provider that needs to be unmapped to internal UAA groups
   */
  @Override
  public String getExternalGroup() {
    return externalGroup;
  }

  /**
   * The group's displayed name
   */
  @Override
  public String getGroupDisplayName() {
    return groupDisplayName;
  }

  /**
   * Unique alias of the identity provider
   */
  @Override
  public String getOrigin() {
    return origin;
  }

  /**
   * This instance is equal to all instances of {@code UnmapExternalGroupByGroupDisplayNameRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UnmapExternalGroupByGroupDisplayNameRequest
        && equalTo((UnmapExternalGroupByGroupDisplayNameRequest) another);
  }

  private boolean equalTo(UnmapExternalGroupByGroupDisplayNameRequest another) {
    return Objects.equals(identityZoneId, another.identityZoneId)
        && Objects.equals(identityZoneSubdomain, another.identityZoneSubdomain)
        && externalGroup.equals(another.externalGroup)
        && groupDisplayName.equals(another.groupDisplayName)
        && origin.equals(another.origin);
  }

  /**
   * Computes a hash code from attributes: {@code identityZoneId}, {@code identityZoneSubdomain}, {@code externalGroup}, {@code groupDisplayName}, {@code origin}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(identityZoneId);
    h += (h << 5) + Objects.hashCode(identityZoneSubdomain);
    h += (h << 5) + externalGroup.hashCode();
    h += (h << 5) + groupDisplayName.hashCode();
    h += (h << 5) + origin.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code UnmapExternalGroupByGroupDisplayNameRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UnmapExternalGroupByGroupDisplayNameRequest{"
        + "identityZoneId=" + identityZoneId
        + ", identityZoneSubdomain=" + identityZoneSubdomain
        + ", externalGroup=" + externalGroup
        + ", groupDisplayName=" + groupDisplayName
        + ", origin=" + origin
        + "}";
  }

  /**
   * Creates a builder for {@link UnmapExternalGroupByGroupDisplayNameRequest UnmapExternalGroupByGroupDisplayNameRequest}.
   * <pre>
   * UnmapExternalGroupByGroupDisplayNameRequest.builder()
   *    .identityZoneId(String | null) // nullable {@link UnmapExternalGroupByGroupDisplayNameRequest#getIdentityZoneId() identityZoneId}
   *    .identityZoneSubdomain(String | null) // nullable {@link UnmapExternalGroupByGroupDisplayNameRequest#getIdentityZoneSubdomain() identityZoneSubdomain}
   *    .externalGroup(String) // required {@link UnmapExternalGroupByGroupDisplayNameRequest#getExternalGroup() externalGroup}
   *    .groupDisplayName(String) // required {@link UnmapExternalGroupByGroupDisplayNameRequest#getGroupDisplayName() groupDisplayName}
   *    .origin(String) // required {@link UnmapExternalGroupByGroupDisplayNameRequest#getOrigin() origin}
   *    .build();
   * </pre>
   * @return A new UnmapExternalGroupByGroupDisplayNameRequest builder
   */
  public static UnmapExternalGroupByGroupDisplayNameRequest.Builder builder() {
    return new UnmapExternalGroupByGroupDisplayNameRequest.Builder();
  }

  /**
   * Builds instances of type {@link UnmapExternalGroupByGroupDisplayNameRequest UnmapExternalGroupByGroupDisplayNameRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_UnmapExternalGroupByGroupDisplayNameRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_EXTERNAL_GROUP = 0x1L;
    private static final long INIT_BIT_GROUP_DISPLAY_NAME = 0x2L;
    private static final long INIT_BIT_ORIGIN = 0x4L;
    private long initBits = 0x7L;

    private String identityZoneId;
    private String identityZoneSubdomain;
    private String externalGroup;
    private String groupDisplayName;
    private String origin;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.uaa.IdentityZoned} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(IdentityZoned instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code UnmapExternalGroupByGroupDisplayNameRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UnmapExternalGroupByGroupDisplayNameRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _UnmapExternalGroupByGroupDisplayNameRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_UnmapExternalGroupByGroupDisplayNameRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof IdentityZoned) {
        IdentityZoned instance = (IdentityZoned) object;
        String identityZoneSubdomainValue = instance.getIdentityZoneSubdomain();
        if (identityZoneSubdomainValue != null) {
          identityZoneSubdomain(identityZoneSubdomainValue);
        }
        String identityZoneIdValue = instance.getIdentityZoneId();
        if (identityZoneIdValue != null) {
          identityZoneId(identityZoneIdValue);
        }
      }
      if (object instanceof org.cloudfoundry.uaa.groups._UnmapExternalGroupByGroupDisplayNameRequest) {
        org.cloudfoundry.uaa.groups._UnmapExternalGroupByGroupDisplayNameRequest instance = (org.cloudfoundry.uaa.groups._UnmapExternalGroupByGroupDisplayNameRequest) object;
        groupDisplayName(instance.getGroupDisplayName());
        externalGroup(instance.getExternalGroup());
        origin(instance.getOrigin());
      }
    }

    /**
     * Initializes the value for the {@link UnmapExternalGroupByGroupDisplayNameRequest#getIdentityZoneId() identityZoneId} attribute.
     * @param identityZoneId The value for identityZoneId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder identityZoneId(@Nullable String identityZoneId) {
      this.identityZoneId = identityZoneId;
      return this;
    }

    /**
     * Initializes the value for the {@link UnmapExternalGroupByGroupDisplayNameRequest#getIdentityZoneSubdomain() identityZoneSubdomain} attribute.
     * @param identityZoneSubdomain The value for identityZoneSubdomain (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder identityZoneSubdomain(@Nullable String identityZoneSubdomain) {
      this.identityZoneSubdomain = identityZoneSubdomain;
      return this;
    }

    /**
     * Initializes the value for the {@link UnmapExternalGroupByGroupDisplayNameRequest#getExternalGroup() externalGroup} attribute.
     * @param externalGroup The value for externalGroup 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder externalGroup(String externalGroup) {
      this.externalGroup = Objects.requireNonNull(externalGroup, "externalGroup");
      initBits &= ~INIT_BIT_EXTERNAL_GROUP;
      return this;
    }

    /**
     * Initializes the value for the {@link UnmapExternalGroupByGroupDisplayNameRequest#getGroupDisplayName() groupDisplayName} attribute.
     * @param groupDisplayName The value for groupDisplayName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder groupDisplayName(String groupDisplayName) {
      this.groupDisplayName = Objects.requireNonNull(groupDisplayName, "groupDisplayName");
      initBits &= ~INIT_BIT_GROUP_DISPLAY_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link UnmapExternalGroupByGroupDisplayNameRequest#getOrigin() origin} attribute.
     * @param origin The value for origin 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder origin(String origin) {
      this.origin = Objects.requireNonNull(origin, "origin");
      initBits &= ~INIT_BIT_ORIGIN;
      return this;
    }

    /**
     * Builds a new {@link UnmapExternalGroupByGroupDisplayNameRequest UnmapExternalGroupByGroupDisplayNameRequest}.
     * @return An immutable instance of UnmapExternalGroupByGroupDisplayNameRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UnmapExternalGroupByGroupDisplayNameRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new UnmapExternalGroupByGroupDisplayNameRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_EXTERNAL_GROUP) != 0) attributes.add("externalGroup");
      if ((initBits & INIT_BIT_GROUP_DISPLAY_NAME) != 0) attributes.add("groupDisplayName");
      if ((initBits & INIT_BIT_ORIGIN) != 0) attributes.add("origin");
      return "Cannot build UnmapExternalGroupByGroupDisplayNameRequest, some of required attributes are not set " + attributes;
    }
  }
}
