package org.cloudfoundry.uaa.serverinformation;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * The payload for the server information links
 */
@Generated(from = "_Links", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class Links extends org.cloudfoundry.uaa.serverinformation._Links {
  private final @Nullable String login;
  private final @Nullable String password;
  private final @Nullable String register;
  private final @Nullable String uaa;

  private Links(Links.Builder builder) {
    this.login = builder.login;
    this.password = builder.password;
    this.register = builder.register;
    this.uaa = builder.uaa;
  }

  /**
   * The link to the login host alias of the UAA
   */
  @JsonProperty("login")
  @Override
  public @Nullable String getLogin() {
    return login;
  }

  /**
   * The link to the 'Forgot Password' functionality
   */
  @JsonProperty("passwd")
  @Override
  public @Nullable String getPassword() {
    return password;
  }

  /**
   * The link to the 'Create Account' functionality
   */
  @JsonProperty("register")
  @Override
  public @Nullable String getRegister() {
    return register;
  }

  /**
   * The link to the uaa alias host of the UAA
   */
  @JsonProperty("uaa")
  @Override
  public @Nullable String getUaa() {
    return uaa;
  }

  /**
   * This instance is equal to all instances of {@code Links} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof Links
        && equalTo((Links) another);
  }

  private boolean equalTo(Links another) {
    return Objects.equals(login, another.login)
        && Objects.equals(password, another.password)
        && Objects.equals(register, another.register)
        && Objects.equals(uaa, another.uaa);
  }

  /**
   * Computes a hash code from attributes: {@code login}, {@code password}, {@code register}, {@code uaa}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(login);
    h += (h << 5) + Objects.hashCode(password);
    h += (h << 5) + Objects.hashCode(register);
    h += (h << 5) + Objects.hashCode(uaa);
    return h;
  }

  /**
   * Prints the immutable value {@code Links} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Links{"
        + "login=" + login
        + ", password=" + password
        + ", register=" + register
        + ", uaa=" + uaa
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_Links", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.uaa.serverinformation._Links {
    String login;
    String password;
    String register;
    String uaa;
    @JsonProperty("login")
    public void setLogin(@Nullable String login) {
      this.login = login;
    }
    @JsonProperty("passwd")
    public void setPassword(@Nullable String password) {
      this.password = password;
    }
    @JsonProperty("register")
    public void setRegister(@Nullable String register) {
      this.register = register;
    }
    @JsonProperty("uaa")
    public void setUaa(@Nullable String uaa) {
      this.uaa = uaa;
    }
    @Override
    public String getLogin() { throw new UnsupportedOperationException(); }
    @Override
    public String getPassword() { throw new UnsupportedOperationException(); }
    @Override
    public String getRegister() { throw new UnsupportedOperationException(); }
    @Override
    public String getUaa() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static Links fromJson(Json json) {
    Links.Builder builder = Links.builder();
    if (json.login != null) {
      builder.login(json.login);
    }
    if (json.password != null) {
      builder.password(json.password);
    }
    if (json.register != null) {
      builder.register(json.register);
    }
    if (json.uaa != null) {
      builder.uaa(json.uaa);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link Links Links}.
   * <pre>
   * Links.builder()
   *    .login(String | null) // nullable {@link Links#getLogin() login}
   *    .password(String | null) // nullable {@link Links#getPassword() password}
   *    .register(String | null) // nullable {@link Links#getRegister() register}
   *    .uaa(String | null) // nullable {@link Links#getUaa() uaa}
   *    .build();
   * </pre>
   * @return A new Links builder
   */
  public static Links.Builder builder() {
    return new Links.Builder();
  }

  /**
   * Builds instances of type {@link Links Links}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_Links", generator = "Immutables")
  public static final class Builder {
    private String login;
    private String password;
    private String register;
    private String uaa;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Links} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Links instance) {
      return from((_Links) instance);
    }

    /**
     * Copy abstract value type {@code _Links} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_Links instance) {
      Objects.requireNonNull(instance, "instance");
      String loginValue = instance.getLogin();
      if (loginValue != null) {
        login(loginValue);
      }
      String passwordValue = instance.getPassword();
      if (passwordValue != null) {
        password(passwordValue);
      }
      String registerValue = instance.getRegister();
      if (registerValue != null) {
        register(registerValue);
      }
      String uaaValue = instance.getUaa();
      if (uaaValue != null) {
        uaa(uaaValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Links#getLogin() login} attribute.
     * @param login The value for login (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("login")
    public final Builder login(@Nullable String login) {
      this.login = login;
      return this;
    }

    /**
     * Initializes the value for the {@link Links#getPassword() password} attribute.
     * @param password The value for password (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("passwd")
    public final Builder password(@Nullable String password) {
      this.password = password;
      return this;
    }

    /**
     * Initializes the value for the {@link Links#getRegister() register} attribute.
     * @param register The value for register (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("register")
    public final Builder register(@Nullable String register) {
      this.register = register;
      return this;
    }

    /**
     * Initializes the value for the {@link Links#getUaa() uaa} attribute.
     * @param uaa The value for uaa (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("uaa")
    public final Builder uaa(@Nullable String uaa) {
      this.uaa = uaa;
      return this;
    }

    /**
     * Builds a new {@link Links Links}.
     * @return An immutable instance of Links
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public Links build() {
      return new Links(this);
    }
  }
}
