package org.cloudfoundry.uaa.tokens;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * The response from the get token by passcode operation
 */
@Generated(from = "_GetTokenByOneTimePasscodeResponse", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class GetTokenByOneTimePasscodeResponse
    extends org.cloudfoundry.uaa.tokens._GetTokenByOneTimePasscodeResponse {
  private final String accessToken;
  private final Integer expiresInSeconds;
  private final String scopes;
  private final String tokenId;
  private final String tokenType;
  private final @Nullable String openIdToken;
  private final String refreshToken;

  private GetTokenByOneTimePasscodeResponse(GetTokenByOneTimePasscodeResponse.Builder builder) {
    this.accessToken = builder.accessToken;
    this.expiresInSeconds = builder.expiresInSeconds;
    this.scopes = builder.scopes;
    this.tokenId = builder.tokenId;
    this.tokenType = builder.tokenType;
    this.openIdToken = builder.openIdToken;
    this.refreshToken = builder.refreshToken;
  }

  /**
   * The access token
   */
  @JsonProperty("access_token")
  @Override
  public String getAccessToken() {
    return accessToken;
  }

  /**
   * The number of seconds until token expiry
   */
  @JsonProperty("expires_in")
  @Override
  public Integer getExpiresInSeconds() {
    return expiresInSeconds;
  }

  /**
   * The space-delimited list of scopes authorized by the user for this client
   */
  @JsonProperty("scope")
  @Override
  public String getScopes() {
    return scopes;
  }

  /**
   * The identifier for this token
   */
  @JsonProperty("jti")
  @Override
  public String getTokenId() {
    return tokenId;
  }

  /**
   * The type of the access token issued
   */
  @JsonProperty("token_type")
  @Override
  public String getTokenType() {
    return tokenType;
  }

  /**
   * The OpenId token
   */
  @JsonProperty("id_token")
  @Override
  public @Nullable String getOpenIdToken() {
    return openIdToken;
  }

  /**
   * The refresh token
   */
  @JsonProperty("refresh_token")
  @Override
  public String getRefreshToken() {
    return refreshToken;
  }

  /**
   * This instance is equal to all instances of {@code GetTokenByOneTimePasscodeResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GetTokenByOneTimePasscodeResponse
        && equalTo((GetTokenByOneTimePasscodeResponse) another);
  }

  private boolean equalTo(GetTokenByOneTimePasscodeResponse another) {
    return accessToken.equals(another.accessToken)
        && expiresInSeconds.equals(another.expiresInSeconds)
        && scopes.equals(another.scopes)
        && tokenId.equals(another.tokenId)
        && tokenType.equals(another.tokenType)
        && Objects.equals(openIdToken, another.openIdToken)
        && refreshToken.equals(another.refreshToken);
  }

  /**
   * Computes a hash code from attributes: {@code accessToken}, {@code expiresInSeconds}, {@code scopes}, {@code tokenId}, {@code tokenType}, {@code openIdToken}, {@code refreshToken}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + accessToken.hashCode();
    h += (h << 5) + expiresInSeconds.hashCode();
    h += (h << 5) + scopes.hashCode();
    h += (h << 5) + tokenId.hashCode();
    h += (h << 5) + tokenType.hashCode();
    h += (h << 5) + Objects.hashCode(openIdToken);
    h += (h << 5) + refreshToken.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GetTokenByOneTimePasscodeResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetTokenByOneTimePasscodeResponse{"
        + "accessToken=" + accessToken
        + ", expiresInSeconds=" + expiresInSeconds
        + ", scopes=" + scopes
        + ", tokenId=" + tokenId
        + ", tokenType=" + tokenType
        + ", openIdToken=" + openIdToken
        + ", refreshToken=" + refreshToken
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_GetTokenByOneTimePasscodeResponse", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.uaa.tokens._GetTokenByOneTimePasscodeResponse {
    String accessToken;
    Integer expiresInSeconds;
    String scopes;
    String tokenId;
    String tokenType;
    String openIdToken;
    String refreshToken;
    @JsonProperty("access_token")
    public void setAccessToken(String accessToken) {
      this.accessToken = accessToken;
    }
    @JsonProperty("expires_in")
    public void setExpiresInSeconds(Integer expiresInSeconds) {
      this.expiresInSeconds = expiresInSeconds;
    }
    @JsonProperty("scope")
    public void setScopes(String scopes) {
      this.scopes = scopes;
    }
    @JsonProperty("jti")
    public void setTokenId(String tokenId) {
      this.tokenId = tokenId;
    }
    @JsonProperty("token_type")
    public void setTokenType(String tokenType) {
      this.tokenType = tokenType;
    }
    @JsonProperty("id_token")
    public void setOpenIdToken(@Nullable String openIdToken) {
      this.openIdToken = openIdToken;
    }
    @JsonProperty("refresh_token")
    public void setRefreshToken(String refreshToken) {
      this.refreshToken = refreshToken;
    }
    @Override
    public String getAccessToken() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getExpiresInSeconds() { throw new UnsupportedOperationException(); }
    @Override
    public String getScopes() { throw new UnsupportedOperationException(); }
    @Override
    public String getTokenId() { throw new UnsupportedOperationException(); }
    @Override
    public String getTokenType() { throw new UnsupportedOperationException(); }
    @Override
    public String getOpenIdToken() { throw new UnsupportedOperationException(); }
    @Override
    public String getRefreshToken() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static GetTokenByOneTimePasscodeResponse fromJson(Json json) {
    GetTokenByOneTimePasscodeResponse.Builder builder = GetTokenByOneTimePasscodeResponse.builder();
    if (json.accessToken != null) {
      builder.accessToken(json.accessToken);
    }
    if (json.expiresInSeconds != null) {
      builder.expiresInSeconds(json.expiresInSeconds);
    }
    if (json.scopes != null) {
      builder.scopes(json.scopes);
    }
    if (json.tokenId != null) {
      builder.tokenId(json.tokenId);
    }
    if (json.tokenType != null) {
      builder.tokenType(json.tokenType);
    }
    if (json.openIdToken != null) {
      builder.openIdToken(json.openIdToken);
    }
    if (json.refreshToken != null) {
      builder.refreshToken(json.refreshToken);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link GetTokenByOneTimePasscodeResponse GetTokenByOneTimePasscodeResponse}.
   * <pre>
   * GetTokenByOneTimePasscodeResponse.builder()
   *    .accessToken(String) // required {@link GetTokenByOneTimePasscodeResponse#getAccessToken() accessToken}
   *    .expiresInSeconds(Integer) // required {@link GetTokenByOneTimePasscodeResponse#getExpiresInSeconds() expiresInSeconds}
   *    .scopes(String) // required {@link GetTokenByOneTimePasscodeResponse#getScopes() scopes}
   *    .tokenId(String) // required {@link GetTokenByOneTimePasscodeResponse#getTokenId() tokenId}
   *    .tokenType(String) // required {@link GetTokenByOneTimePasscodeResponse#getTokenType() tokenType}
   *    .openIdToken(String | null) // nullable {@link GetTokenByOneTimePasscodeResponse#getOpenIdToken() openIdToken}
   *    .refreshToken(String) // required {@link GetTokenByOneTimePasscodeResponse#getRefreshToken() refreshToken}
   *    .build();
   * </pre>
   * @return A new GetTokenByOneTimePasscodeResponse builder
   */
  public static GetTokenByOneTimePasscodeResponse.Builder builder() {
    return new GetTokenByOneTimePasscodeResponse.Builder();
  }

  /**
   * Builds instances of type {@link GetTokenByOneTimePasscodeResponse GetTokenByOneTimePasscodeResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_GetTokenByOneTimePasscodeResponse", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_ACCESS_TOKEN = 0x1L;
    private static final long INIT_BIT_EXPIRES_IN_SECONDS = 0x2L;
    private static final long INIT_BIT_SCOPES = 0x4L;
    private static final long INIT_BIT_TOKEN_ID = 0x8L;
    private static final long INIT_BIT_TOKEN_TYPE = 0x10L;
    private static final long INIT_BIT_REFRESH_TOKEN = 0x20L;
    private long initBits = 0x3fL;

    private String accessToken;
    private Integer expiresInSeconds;
    private String scopes;
    private String tokenId;
    private String tokenType;
    private String openIdToken;
    private String refreshToken;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetTokenByOneTimePasscodeResponse} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GetTokenByOneTimePasscodeResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _GetTokenByOneTimePasscodeResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_GetTokenByOneTimePasscodeResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.uaa.tokens.AbstractToken} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractToken instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof org.cloudfoundry.uaa.tokens._GetTokenByOneTimePasscodeResponse) {
        org.cloudfoundry.uaa.tokens._GetTokenByOneTimePasscodeResponse instance = (org.cloudfoundry.uaa.tokens._GetTokenByOneTimePasscodeResponse) object;
        String openIdTokenValue = instance.getOpenIdToken();
        if (openIdTokenValue != null) {
          openIdToken(openIdTokenValue);
        }
        refreshToken(instance.getRefreshToken());
      }
      if (object instanceof AbstractToken) {
        AbstractToken instance = (AbstractToken) object;
        scopes(instance.getScopes());
        tokenId(instance.getTokenId());
        accessToken(instance.getAccessToken());
        tokenType(instance.getTokenType());
        expiresInSeconds(instance.getExpiresInSeconds());
      }
    }

    /**
     * Initializes the value for the {@link GetTokenByOneTimePasscodeResponse#getAccessToken() accessToken} attribute.
     * @param accessToken The value for accessToken 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("access_token")
    public final Builder accessToken(String accessToken) {
      this.accessToken = Objects.requireNonNull(accessToken, "accessToken");
      initBits &= ~INIT_BIT_ACCESS_TOKEN;
      return this;
    }

    /**
     * Initializes the value for the {@link GetTokenByOneTimePasscodeResponse#getExpiresInSeconds() expiresInSeconds} attribute.
     * @param expiresInSeconds The value for expiresInSeconds 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("expires_in")
    public final Builder expiresInSeconds(Integer expiresInSeconds) {
      this.expiresInSeconds = Objects.requireNonNull(expiresInSeconds, "expiresInSeconds");
      initBits &= ~INIT_BIT_EXPIRES_IN_SECONDS;
      return this;
    }

    /**
     * Initializes the value for the {@link GetTokenByOneTimePasscodeResponse#getScopes() scopes} attribute.
     * @param scopes The value for scopes 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("scope")
    public final Builder scopes(String scopes) {
      this.scopes = Objects.requireNonNull(scopes, "scopes");
      initBits &= ~INIT_BIT_SCOPES;
      return this;
    }

    /**
     * Initializes the value for the {@link GetTokenByOneTimePasscodeResponse#getTokenId() tokenId} attribute.
     * @param tokenId The value for tokenId 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("jti")
    public final Builder tokenId(String tokenId) {
      this.tokenId = Objects.requireNonNull(tokenId, "tokenId");
      initBits &= ~INIT_BIT_TOKEN_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link GetTokenByOneTimePasscodeResponse#getTokenType() tokenType} attribute.
     * @param tokenType The value for tokenType 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("token_type")
    public final Builder tokenType(String tokenType) {
      this.tokenType = Objects.requireNonNull(tokenType, "tokenType");
      initBits &= ~INIT_BIT_TOKEN_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link GetTokenByOneTimePasscodeResponse#getOpenIdToken() openIdToken} attribute.
     * @param openIdToken The value for openIdToken (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("id_token")
    public final Builder openIdToken(@Nullable String openIdToken) {
      this.openIdToken = openIdToken;
      return this;
    }

    /**
     * Initializes the value for the {@link GetTokenByOneTimePasscodeResponse#getRefreshToken() refreshToken} attribute.
     * @param refreshToken The value for refreshToken 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("refresh_token")
    public final Builder refreshToken(String refreshToken) {
      this.refreshToken = Objects.requireNonNull(refreshToken, "refreshToken");
      initBits &= ~INIT_BIT_REFRESH_TOKEN;
      return this;
    }

    /**
     * Builds a new {@link GetTokenByOneTimePasscodeResponse GetTokenByOneTimePasscodeResponse}.
     * @return An immutable instance of GetTokenByOneTimePasscodeResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GetTokenByOneTimePasscodeResponse build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new GetTokenByOneTimePasscodeResponse(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ACCESS_TOKEN) != 0) attributes.add("accessToken");
      if ((initBits & INIT_BIT_EXPIRES_IN_SECONDS) != 0) attributes.add("expiresInSeconds");
      if ((initBits & INIT_BIT_SCOPES) != 0) attributes.add("scopes");
      if ((initBits & INIT_BIT_TOKEN_ID) != 0) attributes.add("tokenId");
      if ((initBits & INIT_BIT_TOKEN_TYPE) != 0) attributes.add("tokenType");
      if ((initBits & INIT_BIT_REFRESH_TOKEN) != 0) attributes.add("refreshToken");
      return "Cannot build GetTokenByOneTimePasscodeResponse, some of required attributes are not set " + attributes;
    }
  }
}
