package org.cloudfoundry.uaa.users;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.IdentityZoned;
import org.cloudfoundry.uaa.Versioned;
import org.immutables.value.Generated;

/**
 * The request payload for the verify user operation
 */
@Generated(from = "_VerifyUserRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class VerifyUserRequest extends org.cloudfoundry.uaa.users._VerifyUserRequest {
  private final @Nullable String identityZoneId;
  private final @Nullable String identityZoneSubdomain;
  private final @Nullable String version;
  private final String userId;

  private VerifyUserRequest(VerifyUserRequest.Builder builder) {
    this.identityZoneId = builder.identityZoneId;
    this.identityZoneSubdomain = builder.identityZoneSubdomain;
    this.version = builder.version;
    this.userId = builder.userId;
  }

  /**
   * Returns the identity zone id
   * @return the identity zone id
   */
  @Override
  public @Nullable String getIdentityZoneId() {
    return identityZoneId;
  }

  /**
   * Returns the identity zone subdomain
   * @return the identity zone subdomain
   */
  @Override
  public @Nullable String getIdentityZoneSubdomain() {
    return identityZoneSubdomain;
  }

  /**
   * Returns the version
   */
  @Override
  public @Nullable String getVersion() {
    return version;
  }

  /**
   * The user id
   */
  @Override
  public String getUserId() {
    return userId;
  }

  /**
   * This instance is equal to all instances of {@code VerifyUserRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof VerifyUserRequest
        && equalTo((VerifyUserRequest) another);
  }

  private boolean equalTo(VerifyUserRequest another) {
    return Objects.equals(identityZoneId, another.identityZoneId)
        && Objects.equals(identityZoneSubdomain, another.identityZoneSubdomain)
        && Objects.equals(version, another.version)
        && userId.equals(another.userId);
  }

  /**
   * Computes a hash code from attributes: {@code identityZoneId}, {@code identityZoneSubdomain}, {@code version}, {@code userId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(identityZoneId);
    h += (h << 5) + Objects.hashCode(identityZoneSubdomain);
    h += (h << 5) + Objects.hashCode(version);
    h += (h << 5) + userId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code VerifyUserRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "VerifyUserRequest{"
        + "identityZoneId=" + identityZoneId
        + ", identityZoneSubdomain=" + identityZoneSubdomain
        + ", version=" + version
        + ", userId=" + userId
        + "}";
  }

  /**
   * Creates a builder for {@link VerifyUserRequest VerifyUserRequest}.
   * <pre>
   * VerifyUserRequest.builder()
   *    .identityZoneId(String | null) // nullable {@link VerifyUserRequest#getIdentityZoneId() identityZoneId}
   *    .identityZoneSubdomain(String | null) // nullable {@link VerifyUserRequest#getIdentityZoneSubdomain() identityZoneSubdomain}
   *    .version(String | null) // nullable {@link VerifyUserRequest#getVersion() version}
   *    .userId(String) // required {@link VerifyUserRequest#getUserId() userId}
   *    .build();
   * </pre>
   * @return A new VerifyUserRequest builder
   */
  public static VerifyUserRequest.Builder builder() {
    return new VerifyUserRequest.Builder();
  }

  /**
   * Builds instances of type {@link VerifyUserRequest VerifyUserRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_VerifyUserRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_USER_ID = 0x1L;
    private long initBits = 0x1L;

    private String identityZoneId;
    private String identityZoneSubdomain;
    private String version;
    private String userId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.uaa.IdentityZoned} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(IdentityZoned instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.uaa.Versioned} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Versioned instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code VerifyUserRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(VerifyUserRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _VerifyUserRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_VerifyUserRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof IdentityZoned) {
        IdentityZoned instance = (IdentityZoned) object;
        String identityZoneSubdomainValue = instance.getIdentityZoneSubdomain();
        if (identityZoneSubdomainValue != null) {
          identityZoneSubdomain(identityZoneSubdomainValue);
        }
        String identityZoneIdValue = instance.getIdentityZoneId();
        if (identityZoneIdValue != null) {
          identityZoneId(identityZoneIdValue);
        }
      }
      if (object instanceof Versioned) {
        Versioned instance = (Versioned) object;
        String versionValue = instance.getVersion();
        if (versionValue != null) {
          version(versionValue);
        }
      }
      if (object instanceof org.cloudfoundry.uaa.users._VerifyUserRequest) {
        org.cloudfoundry.uaa.users._VerifyUserRequest instance = (org.cloudfoundry.uaa.users._VerifyUserRequest) object;
        userId(instance.getUserId());
      }
    }

    /**
     * Initializes the value for the {@link VerifyUserRequest#getIdentityZoneId() identityZoneId} attribute.
     * @param identityZoneId The value for identityZoneId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder identityZoneId(@Nullable String identityZoneId) {
      this.identityZoneId = identityZoneId;
      return this;
    }

    /**
     * Initializes the value for the {@link VerifyUserRequest#getIdentityZoneSubdomain() identityZoneSubdomain} attribute.
     * @param identityZoneSubdomain The value for identityZoneSubdomain (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder identityZoneSubdomain(@Nullable String identityZoneSubdomain) {
      this.identityZoneSubdomain = identityZoneSubdomain;
      return this;
    }

    /**
     * Initializes the value for the {@link VerifyUserRequest#getVersion() version} attribute.
     * @param version The value for version (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder version(@Nullable String version) {
      this.version = version;
      return this;
    }

    /**
     * Initializes the value for the {@link VerifyUserRequest#getUserId() userId} attribute.
     * @param userId The value for userId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder userId(String userId) {
      this.userId = Objects.requireNonNull(userId, "userId");
      initBits &= ~INIT_BIT_USER_ID;
      return this;
    }

    /**
     * Builds a new {@link VerifyUserRequest VerifyUserRequest}.
     * @return An immutable instance of VerifyUserRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public VerifyUserRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new VerifyUserRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_USER_ID) != 0) attributes.add("userId");
      return "Cannot build VerifyUserRequest, some of required attributes are not set " + attributes;
    }
  }
}
