package org.cloudfoundry.operations.serviceadmin;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * Immutable implementation of {@link _CreateServiceBrokerRequest}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code CreateServiceBrokerRequest.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_CreateServiceBrokerRequest"})
public final class CreateServiceBrokerRequest
    extends org.cloudfoundry.operations.serviceadmin._CreateServiceBrokerRequest {
  private final String name;
  private final String password;
  private final @Nullable Boolean spaceScoped;
  private final String url;
  private final String username;

  private CreateServiceBrokerRequest(CreateServiceBrokerRequest.Builder builder) {
    this.name = builder.name;
    this.password = builder.password;
    this.spaceScoped = builder.spaceScoped;
    this.url = builder.url;
    this.username = builder.username;
  }

  /**
   * The name of the service broker
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * The password to authenticate with the broker
   */
  @Override
  public String getPassword() {
    return password;
  }

  /**
   * Whether the service broker should be space scoped
   */
  @Override
  public @Nullable Boolean getSpaceScoped() {
    return spaceScoped;
  }

  /**
   * The url of the service broker
   */
  @Override
  public String getUrl() {
    return url;
  }

  /**
   * The username to authenticate with the broker
   */
  @Override
  public String getUsername() {
    return username;
  }

  /**
   * This instance is equal to all instances of {@code CreateServiceBrokerRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof CreateServiceBrokerRequest
        && equalTo((CreateServiceBrokerRequest) another);
  }

  private boolean equalTo(CreateServiceBrokerRequest another) {
    return name.equals(another.name)
        && password.equals(another.password)
        && Objects.equals(spaceScoped, another.spaceScoped)
        && url.equals(another.url)
        && username.equals(another.username);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code password}, {@code spaceScoped}, {@code url}, {@code username}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + name.hashCode();
    h = h * 17 + password.hashCode();
    h = h * 17 + Objects.hashCode(spaceScoped);
    h = h * 17 + url.hashCode();
    h = h * 17 + username.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code CreateServiceBrokerRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CreateServiceBrokerRequest{"
        + "name=" + name
        + ", password=" + password
        + ", spaceScoped=" + spaceScoped
        + ", url=" + url
        + ", username=" + username
        + "}";
  }

  /**
   * Creates a builder for {@link CreateServiceBrokerRequest CreateServiceBrokerRequest}.
   * @return A new CreateServiceBrokerRequest builder
   */
  public static CreateServiceBrokerRequest.Builder builder() {
    return new CreateServiceBrokerRequest.Builder();
  }

  /**
   * Builds instances of type {@link CreateServiceBrokerRequest CreateServiceBrokerRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long INIT_BIT_PASSWORD = 0x2L;
    private static final long INIT_BIT_URL = 0x4L;
    private static final long INIT_BIT_USERNAME = 0x8L;
    private long initBits = 0xfL;

    private String name;
    private String password;
    private Boolean spaceScoped;
    private String url;
    private String username;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CreateServiceBrokerRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CreateServiceBrokerRequest instance) {
      return from((_CreateServiceBrokerRequest) instance);
    }

    /**
     * Copy abstract value type {@code _CreateServiceBrokerRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_CreateServiceBrokerRequest instance) {
      Objects.requireNonNull(instance, "instance");
      name(instance.getName());
      password(instance.getPassword());
      Boolean spaceScopedValue = instance.getSpaceScoped();
      if (spaceScopedValue != null) {
        spaceScoped(spaceScopedValue);
      }
      url(instance.getUrl());
      username(instance.getUsername());
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateServiceBrokerRequest#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateServiceBrokerRequest#getPassword() password} attribute.
     * @param password The value for password 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder password(String password) {
      this.password = Objects.requireNonNull(password, "password");
      initBits &= ~INIT_BIT_PASSWORD;
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateServiceBrokerRequest#getSpaceScoped() spaceScoped} attribute.
     * @param spaceScoped The value for spaceScoped (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceScoped(@Nullable Boolean spaceScoped) {
      this.spaceScoped = spaceScoped;
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateServiceBrokerRequest#getUrl() url} attribute.
     * @param url The value for url 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder url(String url) {
      this.url = Objects.requireNonNull(url, "url");
      initBits &= ~INIT_BIT_URL;
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateServiceBrokerRequest#getUsername() username} attribute.
     * @param username The value for username 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder username(String username) {
      this.username = Objects.requireNonNull(username, "username");
      initBits &= ~INIT_BIT_USERNAME;
      return this;
    }

    /**
     * Builds a new {@link CreateServiceBrokerRequest CreateServiceBrokerRequest}.
     * @return An immutable instance of CreateServiceBrokerRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public CreateServiceBrokerRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new CreateServiceBrokerRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_PASSWORD) != 0) attributes.add("password");
      if ((initBits & INIT_BIT_URL) != 0) attributes.add("url");
      if ((initBits & INIT_BIT_USERNAME) != 0) attributes.add("username");
      return "Cannot build CreateServiceBrokerRequest, some of required attributes are not set " + attributes;
    }
  }
}
