package org.cloudfoundry.operations.services;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link _GetServiceKeyRequest}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code GetServiceKeyRequest.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_GetServiceKeyRequest"})
public final class GetServiceKeyRequest extends org.cloudfoundry.operations.services._GetServiceKeyRequest {
  private final String serviceInstanceName;
  private final String serviceKeyName;

  private GetServiceKeyRequest(GetServiceKeyRequest.Builder builder) {
    this.serviceInstanceName = builder.serviceInstanceName;
    this.serviceKeyName = builder.serviceKeyName;
  }

  /**
   * The name of the service instance
   */
  @Override
  public String getServiceInstanceName() {
    return serviceInstanceName;
  }

  /**
   * The name of the service key
   */
  @Override
  public String getServiceKeyName() {
    return serviceKeyName;
  }

  /**
   * This instance is equal to all instances of {@code GetServiceKeyRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GetServiceKeyRequest
        && equalTo((GetServiceKeyRequest) another);
  }

  private boolean equalTo(GetServiceKeyRequest another) {
    return serviceInstanceName.equals(another.serviceInstanceName)
        && serviceKeyName.equals(another.serviceKeyName);
  }

  /**
   * Computes a hash code from attributes: {@code serviceInstanceName}, {@code serviceKeyName}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + serviceInstanceName.hashCode();
    h = h * 17 + serviceKeyName.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GetServiceKeyRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetServiceKeyRequest{"
        + "serviceInstanceName=" + serviceInstanceName
        + ", serviceKeyName=" + serviceKeyName
        + "}";
  }

  /**
   * Creates a builder for {@link GetServiceKeyRequest GetServiceKeyRequest}.
   * @return A new GetServiceKeyRequest builder
   */
  public static GetServiceKeyRequest.Builder builder() {
    return new GetServiceKeyRequest.Builder();
  }

  /**
   * Builds instances of type {@link GetServiceKeyRequest GetServiceKeyRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_SERVICE_INSTANCE_NAME = 0x1L;
    private static final long INIT_BIT_SERVICE_KEY_NAME = 0x2L;
    private long initBits = 0x3L;

    private String serviceInstanceName;
    private String serviceKeyName;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetServiceKeyRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GetServiceKeyRequest instance) {
      return from((_GetServiceKeyRequest) instance);
    }

    /**
     * Copy abstract value type {@code _GetServiceKeyRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_GetServiceKeyRequest instance) {
      Objects.requireNonNull(instance, "instance");
      serviceInstanceName(instance.getServiceInstanceName());
      serviceKeyName(instance.getServiceKeyName());
      return this;
    }

    /**
     * Initializes the value for the {@link _GetServiceKeyRequest#getServiceInstanceName() serviceInstanceName} attribute.
     * @param serviceInstanceName The value for serviceInstanceName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceInstanceName(String serviceInstanceName) {
      this.serviceInstanceName = Objects.requireNonNull(serviceInstanceName, "serviceInstanceName");
      initBits &= ~INIT_BIT_SERVICE_INSTANCE_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link _GetServiceKeyRequest#getServiceKeyName() serviceKeyName} attribute.
     * @param serviceKeyName The value for serviceKeyName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceKeyName(String serviceKeyName) {
      this.serviceKeyName = Objects.requireNonNull(serviceKeyName, "serviceKeyName");
      initBits &= ~INIT_BIT_SERVICE_KEY_NAME;
      return this;
    }

    /**
     * Builds a new {@link GetServiceKeyRequest GetServiceKeyRequest}.
     * @return An immutable instance of GetServiceKeyRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GetServiceKeyRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new GetServiceKeyRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_SERVICE_INSTANCE_NAME) != 0) attributes.add("serviceInstanceName");
      if ((initBits & INIT_BIT_SERVICE_KEY_NAME) != 0) attributes.add("serviceKeyName");
      return "Cannot build GetServiceKeyRequest, some of required attributes are not set " + attributes;
    }
  }
}
