/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.operations;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.CloudFoundryClient;
import org.cloudfoundry.doppler.DopplerClient;
import org.cloudfoundry.operations._DefaultCloudFoundryOperations;
import org.cloudfoundry.operations.advanced.Advanced;
import org.cloudfoundry.operations.applications.Applications;
import org.cloudfoundry.operations.buildpacks.Buildpacks;
import org.cloudfoundry.operations.domains.Domains;
import org.cloudfoundry.operations.organizationadmin.OrganizationAdmin;
import org.cloudfoundry.operations.organizations.Organizations;
import org.cloudfoundry.operations.routes.Routes;
import org.cloudfoundry.operations.serviceadmin.ServiceAdmin;
import org.cloudfoundry.operations.services.Services;
import org.cloudfoundry.operations.spaceadmin.SpaceAdmin;
import org.cloudfoundry.operations.spaces.Spaces;
import org.cloudfoundry.operations.stacks.Stacks;
import org.cloudfoundry.uaa.UaaClient;
import reactor.core.publisher.Mono;

public final class DefaultCloudFoundryOperations
extends _DefaultCloudFoundryOperations {
    private final Advanced advanced;
    private final Applications applications;
    private final Buildpacks buildpacks;
    private final Domains domains;
    private final OrganizationAdmin organizationAdmin;
    private final Organizations organizations;
    private final Routes routes;
    private final ServiceAdmin serviceAdmin;
    private final Services services;
    private final SpaceAdmin spaceAdmin;
    private final Spaces spaces;
    private final Stacks stacks;
    @Nullable
    private final CloudFoundryClient cloudFoundryClient;
    private final Mono<CloudFoundryClient> cloudFoundryClientPublisher;
    @Nullable
    private final DopplerClient dopplerClient;
    private final Mono<DopplerClient> dopplerClientPublisher;
    @Nullable
    private final String organization;
    private final Mono<String> organizationId;
    @Nullable
    private final String space;
    private final Mono<String> spaceId;
    @Nullable
    private final UaaClient uaaClient;
    private final Mono<UaaClient> uaaClientPublisher;
    private final Mono<String> username;
    private static final int STAGE_INITIALIZING = -1;
    private static final int STAGE_UNINITIALIZED = 0;
    private static final int STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private DefaultCloudFoundryOperations(Builder builder) {
        this.cloudFoundryClient = builder.cloudFoundryClient;
        this.dopplerClient = builder.dopplerClient;
        this.organization = builder.organization;
        this.space = builder.space;
        this.uaaClient = builder.uaaClient;
        this.advanced = this.initShim.advanced();
        this.applications = this.initShim.applications();
        this.buildpacks = this.initShim.buildpacks();
        this.domains = this.initShim.domains();
        this.organizationAdmin = this.initShim.organizationAdmin();
        this.organizations = this.initShim.organizations();
        this.routes = this.initShim.routes();
        this.serviceAdmin = this.initShim.serviceAdmin();
        this.services = this.initShim.services();
        this.spaceAdmin = this.initShim.spaceAdmin();
        this.spaces = this.initShim.spaces();
        this.stacks = this.initShim.stacks();
        this.cloudFoundryClientPublisher = this.initShim.getCloudFoundryClientPublisher();
        this.dopplerClientPublisher = this.initShim.getDopplerClientPublisher();
        this.organizationId = this.initShim.getOrganizationId();
        this.spaceId = this.initShim.getSpaceId();
        this.uaaClientPublisher = this.initShim.getUaaClientPublisher();
        this.username = this.initShim.getUsername();
        this.initShim = null;
    }

    @Override
    public Advanced advanced() {
        InitShim shim = this.initShim;
        return shim != null ? shim.advanced() : this.advanced;
    }

    @Override
    public Applications applications() {
        InitShim shim = this.initShim;
        return shim != null ? shim.applications() : this.applications;
    }

    @Override
    public Buildpacks buildpacks() {
        InitShim shim = this.initShim;
        return shim != null ? shim.buildpacks() : this.buildpacks;
    }

    @Override
    public Domains domains() {
        InitShim shim = this.initShim;
        return shim != null ? shim.domains() : this.domains;
    }

    @Override
    public OrganizationAdmin organizationAdmin() {
        InitShim shim = this.initShim;
        return shim != null ? shim.organizationAdmin() : this.organizationAdmin;
    }

    @Override
    public Organizations organizations() {
        InitShim shim = this.initShim;
        return shim != null ? shim.organizations() : this.organizations;
    }

    @Override
    public Routes routes() {
        InitShim shim = this.initShim;
        return shim != null ? shim.routes() : this.routes;
    }

    @Override
    public ServiceAdmin serviceAdmin() {
        InitShim shim = this.initShim;
        return shim != null ? shim.serviceAdmin() : this.serviceAdmin;
    }

    @Override
    public Services services() {
        InitShim shim = this.initShim;
        return shim != null ? shim.services() : this.services;
    }

    @Override
    public SpaceAdmin spaceAdmin() {
        InitShim shim = this.initShim;
        return shim != null ? shim.spaceAdmin() : this.spaceAdmin;
    }

    @Override
    public Spaces spaces() {
        InitShim shim = this.initShim;
        return shim != null ? shim.spaces() : this.spaces;
    }

    @Override
    public Stacks stacks() {
        InitShim shim = this.initShim;
        return shim != null ? shim.stacks() : this.stacks;
    }

    @Override
    @Nullable
    public CloudFoundryClient getCloudFoundryClient() {
        return this.cloudFoundryClient;
    }

    @Override
    public Mono<CloudFoundryClient> getCloudFoundryClientPublisher() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getCloudFoundryClientPublisher() : this.cloudFoundryClientPublisher;
    }

    @Override
    @Nullable
    public DopplerClient getDopplerClient() {
        return this.dopplerClient;
    }

    @Override
    public Mono<DopplerClient> getDopplerClientPublisher() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getDopplerClientPublisher() : this.dopplerClientPublisher;
    }

    @Override
    @Nullable
    public String getOrganization() {
        return this.organization;
    }

    @Override
    public Mono<String> getOrganizationId() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getOrganizationId() : this.organizationId;
    }

    @Override
    @Nullable
    public String getSpace() {
        return this.space;
    }

    @Override
    public Mono<String> getSpaceId() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getSpaceId() : this.spaceId;
    }

    @Override
    @Nullable
    public UaaClient getUaaClient() {
        return this.uaaClient;
    }

    @Override
    public Mono<UaaClient> getUaaClientPublisher() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getUaaClientPublisher() : this.uaaClientPublisher;
    }

    @Override
    public Mono<String> getUsername() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getUsername() : this.username;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof DefaultCloudFoundryOperations && this.equalTo((DefaultCloudFoundryOperations)another);
    }

    private boolean equalTo(DefaultCloudFoundryOperations another) {
        return this.advanced.equals(another.advanced) && this.applications.equals(another.applications) && this.buildpacks.equals(another.buildpacks) && this.domains.equals(another.domains) && this.organizationAdmin.equals(another.organizationAdmin) && this.organizations.equals(another.organizations) && this.routes.equals(another.routes) && this.serviceAdmin.equals(another.serviceAdmin) && this.services.equals(another.services) && this.spaceAdmin.equals(another.spaceAdmin) && this.spaces.equals(another.spaces) && this.stacks.equals(another.stacks) && Objects.equals(this.cloudFoundryClient, another.cloudFoundryClient) && this.cloudFoundryClientPublisher.equals(another.cloudFoundryClientPublisher) && Objects.equals(this.dopplerClient, another.dopplerClient) && this.dopplerClientPublisher.equals(another.dopplerClientPublisher) && Objects.equals(this.organization, another.organization) && this.organizationId.equals(another.organizationId) && Objects.equals(this.space, another.space) && this.spaceId.equals(another.spaceId) && Objects.equals(this.uaaClient, another.uaaClient) && this.uaaClientPublisher.equals(another.uaaClientPublisher) && this.username.equals(another.username);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.advanced.hashCode();
        h = h * 17 + this.applications.hashCode();
        h = h * 17 + this.buildpacks.hashCode();
        h = h * 17 + this.domains.hashCode();
        h = h * 17 + this.organizationAdmin.hashCode();
        h = h * 17 + this.organizations.hashCode();
        h = h * 17 + this.routes.hashCode();
        h = h * 17 + this.serviceAdmin.hashCode();
        h = h * 17 + this.services.hashCode();
        h = h * 17 + this.spaceAdmin.hashCode();
        h = h * 17 + this.spaces.hashCode();
        h = h * 17 + this.stacks.hashCode();
        h = h * 17 + Objects.hashCode(this.cloudFoundryClient);
        h = h * 17 + this.cloudFoundryClientPublisher.hashCode();
        h = h * 17 + Objects.hashCode(this.dopplerClient);
        h = h * 17 + this.dopplerClientPublisher.hashCode();
        h = h * 17 + Objects.hashCode(this.organization);
        h = h * 17 + this.organizationId.hashCode();
        h = h * 17 + Objects.hashCode(this.space);
        h = h * 17 + this.spaceId.hashCode();
        h = h * 17 + Objects.hashCode(this.uaaClient);
        h = h * 17 + this.uaaClientPublisher.hashCode();
        h = h * 17 + this.username.hashCode();
        return h;
    }

    public String toString() {
        return "DefaultCloudFoundryOperations{advanced=" + this.advanced + ", applications=" + this.applications + ", buildpacks=" + this.buildpacks + ", domains=" + this.domains + ", organizationAdmin=" + this.organizationAdmin + ", organizations=" + this.organizations + ", routes=" + this.routes + ", serviceAdmin=" + this.serviceAdmin + ", services=" + this.services + ", spaceAdmin=" + this.spaceAdmin + ", spaces=" + this.spaces + ", stacks=" + this.stacks + ", cloudFoundryClient=" + this.cloudFoundryClient + ", cloudFoundryClientPublisher=" + this.cloudFoundryClientPublisher + ", dopplerClient=" + this.dopplerClient + ", dopplerClientPublisher=" + this.dopplerClientPublisher + ", organization=" + this.organization + ", organizationId=" + this.organizationId + ", space=" + this.space + ", spaceId=" + this.spaceId + ", uaaClient=" + this.uaaClient + ", uaaClientPublisher=" + this.uaaClientPublisher + ", username=" + this.username + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private CloudFoundryClient cloudFoundryClient;
        private DopplerClient dopplerClient;
        private String organization;
        private String space;
        private UaaClient uaaClient;

        private Builder() {
        }

        public final Builder from(DefaultCloudFoundryOperations instance) {
            return this.from((_DefaultCloudFoundryOperations)instance);
        }

        final Builder from(_DefaultCloudFoundryOperations instance) {
            UaaClient uaaClientValue;
            String spaceValue;
            String organizationValue;
            DopplerClient dopplerClientValue;
            Objects.requireNonNull(instance, "instance");
            CloudFoundryClient cloudFoundryClientValue = instance.getCloudFoundryClient();
            if (cloudFoundryClientValue != null) {
                this.cloudFoundryClient(cloudFoundryClientValue);
            }
            if ((dopplerClientValue = instance.getDopplerClient()) != null) {
                this.dopplerClient(dopplerClientValue);
            }
            if ((organizationValue = instance.getOrganization()) != null) {
                this.organization(organizationValue);
            }
            if ((spaceValue = instance.getSpace()) != null) {
                this.space(spaceValue);
            }
            if ((uaaClientValue = instance.getUaaClient()) != null) {
                this.uaaClient(uaaClientValue);
            }
            return this;
        }

        public final Builder cloudFoundryClient(@Nullable CloudFoundryClient cloudFoundryClient) {
            this.cloudFoundryClient = cloudFoundryClient;
            return this;
        }

        public final Builder dopplerClient(@Nullable DopplerClient dopplerClient) {
            this.dopplerClient = dopplerClient;
            return this;
        }

        public final Builder organization(@Nullable String organization) {
            this.organization = organization;
            return this;
        }

        public final Builder space(@Nullable String space) {
            this.space = space;
            return this;
        }

        public final Builder uaaClient(@Nullable UaaClient uaaClient) {
            this.uaaClient = uaaClient;
            return this;
        }

        public DefaultCloudFoundryOperations build() {
            return new DefaultCloudFoundryOperations(this);
        }
    }

    private final class InitShim {
        private Advanced advanced;
        private int advancedStage;
        private Applications applications;
        private int applicationsStage;
        private Buildpacks buildpacks;
        private int buildpacksStage;
        private Domains domains;
        private int domainsStage;
        private OrganizationAdmin organizationAdmin;
        private int organizationAdminStage;
        private Organizations organizations;
        private int organizationsStage;
        private Routes routes;
        private int routesStage;
        private ServiceAdmin serviceAdmin;
        private int serviceAdminStage;
        private Services services;
        private int servicesStage;
        private SpaceAdmin spaceAdmin;
        private int spaceAdminStage;
        private Spaces spaces;
        private int spacesStage;
        private Stacks stacks;
        private int stacksStage;
        private Mono<CloudFoundryClient> cloudFoundryClientPublisher;
        private int cloudFoundryClientPublisherStage;
        private Mono<DopplerClient> dopplerClientPublisher;
        private int dopplerClientPublisherStage;
        private Mono<String> organizationId;
        private int organizationIdStage;
        private Mono<String> spaceId;
        private int spaceIdStage;
        private Mono<UaaClient> uaaClientPublisher;
        private int uaaClientPublisherStage;
        private Mono<String> username;
        private int usernameStage;

        private InitShim() {
        }

        Advanced advanced() {
            if (this.advancedStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.advancedStage == 0) {
                this.advancedStage = -1;
                this.advanced = Objects.requireNonNull(DefaultCloudFoundryOperations.super.advanced(), "advanced");
                this.advancedStage = 1;
            }
            return this.advanced;
        }

        Applications applications() {
            if (this.applicationsStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.applicationsStage == 0) {
                this.applicationsStage = -1;
                this.applications = Objects.requireNonNull(DefaultCloudFoundryOperations.super.applications(), "applications");
                this.applicationsStage = 1;
            }
            return this.applications;
        }

        Buildpacks buildpacks() {
            if (this.buildpacksStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.buildpacksStage == 0) {
                this.buildpacksStage = -1;
                this.buildpacks = Objects.requireNonNull(DefaultCloudFoundryOperations.super.buildpacks(), "buildpacks");
                this.buildpacksStage = 1;
            }
            return this.buildpacks;
        }

        Domains domains() {
            if (this.domainsStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.domainsStage == 0) {
                this.domainsStage = -1;
                this.domains = Objects.requireNonNull(DefaultCloudFoundryOperations.super.domains(), "domains");
                this.domainsStage = 1;
            }
            return this.domains;
        }

        OrganizationAdmin organizationAdmin() {
            if (this.organizationAdminStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.organizationAdminStage == 0) {
                this.organizationAdminStage = -1;
                this.organizationAdmin = Objects.requireNonNull(DefaultCloudFoundryOperations.super.organizationAdmin(), "organizationAdmin");
                this.organizationAdminStage = 1;
            }
            return this.organizationAdmin;
        }

        Organizations organizations() {
            if (this.organizationsStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.organizationsStage == 0) {
                this.organizationsStage = -1;
                this.organizations = Objects.requireNonNull(DefaultCloudFoundryOperations.super.organizations(), "organizations");
                this.organizationsStage = 1;
            }
            return this.organizations;
        }

        Routes routes() {
            if (this.routesStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.routesStage == 0) {
                this.routesStage = -1;
                this.routes = Objects.requireNonNull(DefaultCloudFoundryOperations.super.routes(), "routes");
                this.routesStage = 1;
            }
            return this.routes;
        }

        ServiceAdmin serviceAdmin() {
            if (this.serviceAdminStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.serviceAdminStage == 0) {
                this.serviceAdminStage = -1;
                this.serviceAdmin = Objects.requireNonNull(DefaultCloudFoundryOperations.super.serviceAdmin(), "serviceAdmin");
                this.serviceAdminStage = 1;
            }
            return this.serviceAdmin;
        }

        Services services() {
            if (this.servicesStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.servicesStage == 0) {
                this.servicesStage = -1;
                this.services = Objects.requireNonNull(DefaultCloudFoundryOperations.super.services(), "services");
                this.servicesStage = 1;
            }
            return this.services;
        }

        SpaceAdmin spaceAdmin() {
            if (this.spaceAdminStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.spaceAdminStage == 0) {
                this.spaceAdminStage = -1;
                this.spaceAdmin = Objects.requireNonNull(DefaultCloudFoundryOperations.super.spaceAdmin(), "spaceAdmin");
                this.spaceAdminStage = 1;
            }
            return this.spaceAdmin;
        }

        Spaces spaces() {
            if (this.spacesStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.spacesStage == 0) {
                this.spacesStage = -1;
                this.spaces = Objects.requireNonNull(DefaultCloudFoundryOperations.super.spaces(), "spaces");
                this.spacesStage = 1;
            }
            return this.spaces;
        }

        Stacks stacks() {
            if (this.stacksStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.stacksStage == 0) {
                this.stacksStage = -1;
                this.stacks = Objects.requireNonNull(DefaultCloudFoundryOperations.super.stacks(), "stacks");
                this.stacksStage = 1;
            }
            return this.stacks;
        }

        Mono<CloudFoundryClient> getCloudFoundryClientPublisher() {
            if (this.cloudFoundryClientPublisherStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.cloudFoundryClientPublisherStage == 0) {
                this.cloudFoundryClientPublisherStage = -1;
                this.cloudFoundryClientPublisher = Objects.requireNonNull(DefaultCloudFoundryOperations.super.getCloudFoundryClientPublisher(), "cloudFoundryClientPublisher");
                this.cloudFoundryClientPublisherStage = 1;
            }
            return this.cloudFoundryClientPublisher;
        }

        Mono<DopplerClient> getDopplerClientPublisher() {
            if (this.dopplerClientPublisherStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.dopplerClientPublisherStage == 0) {
                this.dopplerClientPublisherStage = -1;
                this.dopplerClientPublisher = Objects.requireNonNull(DefaultCloudFoundryOperations.super.getDopplerClientPublisher(), "dopplerClientPublisher");
                this.dopplerClientPublisherStage = 1;
            }
            return this.dopplerClientPublisher;
        }

        Mono<String> getOrganizationId() {
            if (this.organizationIdStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.organizationIdStage == 0) {
                this.organizationIdStage = -1;
                this.organizationId = Objects.requireNonNull(DefaultCloudFoundryOperations.super.getOrganizationId(), "organizationId");
                this.organizationIdStage = 1;
            }
            return this.organizationId;
        }

        Mono<String> getSpaceId() {
            if (this.spaceIdStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.spaceIdStage == 0) {
                this.spaceIdStage = -1;
                this.spaceId = Objects.requireNonNull(DefaultCloudFoundryOperations.super.getSpaceId(), "spaceId");
                this.spaceIdStage = 1;
            }
            return this.spaceId;
        }

        Mono<UaaClient> getUaaClientPublisher() {
            if (this.uaaClientPublisherStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.uaaClientPublisherStage == 0) {
                this.uaaClientPublisherStage = -1;
                this.uaaClientPublisher = Objects.requireNonNull(DefaultCloudFoundryOperations.super.getUaaClientPublisher(), "uaaClientPublisher");
                this.uaaClientPublisherStage = 1;
            }
            return this.uaaClientPublisher;
        }

        Mono<String> getUsername() {
            if (this.usernameStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.usernameStage == 0) {
                this.usernameStage = -1;
                this.username = Objects.requireNonNull(DefaultCloudFoundryOperations.super.getUsername(), "username");
                this.usernameStage = 1;
            }
            return this.username;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.advancedStage == -1) {
                attributes.add("advanced");
            }
            if (this.applicationsStage == -1) {
                attributes.add("applications");
            }
            if (this.buildpacksStage == -1) {
                attributes.add("buildpacks");
            }
            if (this.domainsStage == -1) {
                attributes.add("domains");
            }
            if (this.organizationAdminStage == -1) {
                attributes.add("organizationAdmin");
            }
            if (this.organizationsStage == -1) {
                attributes.add("organizations");
            }
            if (this.routesStage == -1) {
                attributes.add("routes");
            }
            if (this.serviceAdminStage == -1) {
                attributes.add("serviceAdmin");
            }
            if (this.servicesStage == -1) {
                attributes.add("services");
            }
            if (this.spaceAdminStage == -1) {
                attributes.add("spaceAdmin");
            }
            if (this.spacesStage == -1) {
                attributes.add("spaces");
            }
            if (this.stacksStage == -1) {
                attributes.add("stacks");
            }
            if (this.cloudFoundryClientPublisherStage == -1) {
                attributes.add("cloudFoundryClientPublisher");
            }
            if (this.dopplerClientPublisherStage == -1) {
                attributes.add("dopplerClientPublisher");
            }
            if (this.organizationIdStage == -1) {
                attributes.add("organizationId");
            }
            if (this.spaceIdStage == -1) {
                attributes.add("spaceId");
            }
            if (this.uaaClientPublisherStage == -1) {
                attributes.add("uaaClientPublisher");
            }
            if (this.usernameStage == -1) {
                attributes.add("username");
            }
            return "Cannot build DefaultCloudFoundryOperations, attribute initializers form cycle" + attributes;
        }
    }
}

