/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.operations.applications;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.operations.applications._ApplicationEnvironments;

public final class ApplicationEnvironments
extends _ApplicationEnvironments {
    private final Map<String, Object> running;
    private final Map<String, Object> staging;
    private final Map<String, Object> systemProvided;
    private final Map<String, Object> userProvided;

    private ApplicationEnvironments(Builder builder) {
        this.running = ApplicationEnvironments.createUnmodifiableMap(false, false, builder.running);
        this.staging = ApplicationEnvironments.createUnmodifiableMap(false, false, builder.staging);
        this.systemProvided = ApplicationEnvironments.createUnmodifiableMap(false, false, builder.systemProvided);
        this.userProvided = ApplicationEnvironments.createUnmodifiableMap(false, false, builder.userProvided);
    }

    @Override
    public Map<String, Object> getRunning() {
        return this.running;
    }

    @Override
    public Map<String, Object> getStaging() {
        return this.staging;
    }

    @Override
    public Map<String, Object> getSystemProvided() {
        return this.systemProvided;
    }

    @Override
    public Map<String, Object> getUserProvided() {
        return this.userProvided;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ApplicationEnvironments && this.equalTo((ApplicationEnvironments)another);
    }

    private boolean equalTo(ApplicationEnvironments another) {
        return this.running.equals(another.running) && this.staging.equals(another.staging) && this.systemProvided.equals(another.systemProvided) && this.userProvided.equals(another.userProvided);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.running.hashCode();
        h = h * 17 + this.staging.hashCode();
        h = h * 17 + this.systemProvided.hashCode();
        h = h * 17 + this.userProvided.hashCode();
        return h;
    }

    public String toString() {
        return "ApplicationEnvironments{running=" + this.running + ", staging=" + this.staging + ", systemProvided=" + this.systemProvided + ", userProvided=" + this.userProvided + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    public static final class Builder {
        private Map<String, Object> running = new LinkedHashMap<String, Object>();
        private Map<String, Object> staging = new LinkedHashMap<String, Object>();
        private Map<String, Object> systemProvided = new LinkedHashMap<String, Object>();
        private Map<String, Object> userProvided = new LinkedHashMap<String, Object>();

        private Builder() {
        }

        public final Builder from(ApplicationEnvironments instance) {
            return this.from((_ApplicationEnvironments)instance);
        }

        final Builder from(_ApplicationEnvironments instance) {
            Objects.requireNonNull(instance, "instance");
            this.putAllRunning(instance.getRunning());
            this.putAllStaging(instance.getStaging());
            this.putAllSystemProvided(instance.getSystemProvided());
            this.putAllUserProvided(instance.getUserProvided());
            return this;
        }

        public final Builder running(String key, Object value) {
            this.running.put(Objects.requireNonNull(key, "running key"), Objects.requireNonNull(value, "running value"));
            return this;
        }

        public final Builder running(Map.Entry<String, ? extends Object> entry) {
            String k = entry.getKey();
            Object v = entry.getValue();
            this.running.put(Objects.requireNonNull(k, "running key"), Objects.requireNonNull(v, "running value"));
            return this;
        }

        public final Builder running(Map<String, ? extends Object> running) {
            this.running.clear();
            return this.putAllRunning(running);
        }

        public final Builder putAllRunning(Map<String, ? extends Object> running) {
            for (Map.Entry<String, ? extends Object> entry : running.entrySet()) {
                String k = entry.getKey();
                Object v = entry.getValue();
                this.running.put(Objects.requireNonNull(k, "running key"), Objects.requireNonNull(v, "running value"));
            }
            return this;
        }

        public final Builder staging(String key, Object value) {
            this.staging.put(Objects.requireNonNull(key, "staging key"), Objects.requireNonNull(value, "staging value"));
            return this;
        }

        public final Builder staging(Map.Entry<String, ? extends Object> entry) {
            String k = entry.getKey();
            Object v = entry.getValue();
            this.staging.put(Objects.requireNonNull(k, "staging key"), Objects.requireNonNull(v, "staging value"));
            return this;
        }

        public final Builder staging(Map<String, ? extends Object> staging) {
            this.staging.clear();
            return this.putAllStaging(staging);
        }

        public final Builder putAllStaging(Map<String, ? extends Object> staging) {
            for (Map.Entry<String, ? extends Object> entry : staging.entrySet()) {
                String k = entry.getKey();
                Object v = entry.getValue();
                this.staging.put(Objects.requireNonNull(k, "staging key"), Objects.requireNonNull(v, "staging value"));
            }
            return this;
        }

        public final Builder systemProvided(String key, Object value) {
            this.systemProvided.put(Objects.requireNonNull(key, "systemProvided key"), Objects.requireNonNull(value, "systemProvided value"));
            return this;
        }

        public final Builder systemProvided(Map.Entry<String, ? extends Object> entry) {
            String k = entry.getKey();
            Object v = entry.getValue();
            this.systemProvided.put(Objects.requireNonNull(k, "systemProvided key"), Objects.requireNonNull(v, "systemProvided value"));
            return this;
        }

        public final Builder systemProvided(Map<String, ? extends Object> systemProvided) {
            this.systemProvided.clear();
            return this.putAllSystemProvided(systemProvided);
        }

        public final Builder putAllSystemProvided(Map<String, ? extends Object> systemProvided) {
            for (Map.Entry<String, ? extends Object> entry : systemProvided.entrySet()) {
                String k = entry.getKey();
                Object v = entry.getValue();
                this.systemProvided.put(Objects.requireNonNull(k, "systemProvided key"), Objects.requireNonNull(v, "systemProvided value"));
            }
            return this;
        }

        public final Builder userProvided(String key, Object value) {
            this.userProvided.put(Objects.requireNonNull(key, "userProvided key"), Objects.requireNonNull(value, "userProvided value"));
            return this;
        }

        public final Builder userProvided(Map.Entry<String, ? extends Object> entry) {
            String k = entry.getKey();
            Object v = entry.getValue();
            this.userProvided.put(Objects.requireNonNull(k, "userProvided key"), Objects.requireNonNull(v, "userProvided value"));
            return this;
        }

        public final Builder userProvided(Map<String, ? extends Object> userProvided) {
            this.userProvided.clear();
            return this.putAllUserProvided(userProvided);
        }

        public final Builder putAllUserProvided(Map<String, ? extends Object> userProvided) {
            for (Map.Entry<String, ? extends Object> entry : userProvided.entrySet()) {
                String k = entry.getKey();
                Object v = entry.getValue();
                this.userProvided.put(Objects.requireNonNull(k, "userProvided key"), Objects.requireNonNull(v, "userProvided value"));
            }
            return this;
        }

        public ApplicationEnvironments build() {
            return new ApplicationEnvironments(this);
        }
    }
}

