/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.operations.applications;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.operations.applications.AbstractApplicationSummary;
import org.cloudfoundry.operations.applications._ApplicationSummary;

public final class ApplicationSummary
extends _ApplicationSummary {
    private final Integer diskQuota;
    private final String id;
    private final Integer instances;
    private final Integer memoryLimit;
    private final String name;
    private final String requestedState;
    private final Integer runningInstances;
    private final List<String> urls;

    private ApplicationSummary(Builder builder) {
        this.diskQuota = builder.diskQuota;
        this.id = builder.id;
        this.instances = builder.instances;
        this.memoryLimit = builder.memoryLimit;
        this.name = builder.name;
        this.requestedState = builder.requestedState;
        this.runningInstances = builder.runningInstances;
        this.urls = ApplicationSummary.createUnmodifiableList(true, builder.urls);
    }

    @Override
    public Integer getDiskQuota() {
        return this.diskQuota;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Integer getInstances() {
        return this.instances;
    }

    @Override
    public Integer getMemoryLimit() {
        return this.memoryLimit;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getRequestedState() {
        return this.requestedState;
    }

    @Override
    public Integer getRunningInstances() {
        return this.runningInstances;
    }

    @Override
    public List<String> getUrls() {
        return this.urls;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ApplicationSummary && this.equalTo((ApplicationSummary)another);
    }

    private boolean equalTo(ApplicationSummary another) {
        return this.diskQuota.equals(another.diskQuota) && this.id.equals(another.id) && this.instances.equals(another.instances) && this.memoryLimit.equals(another.memoryLimit) && this.name.equals(another.name) && this.requestedState.equals(another.requestedState) && this.runningInstances.equals(another.runningInstances) && this.urls.equals(another.urls);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.diskQuota.hashCode();
        h = h * 17 + this.id.hashCode();
        h = h * 17 + this.instances.hashCode();
        h = h * 17 + this.memoryLimit.hashCode();
        h = h * 17 + this.name.hashCode();
        h = h * 17 + this.requestedState.hashCode();
        h = h * 17 + this.runningInstances.hashCode();
        h = h * 17 + this.urls.hashCode();
        return h;
    }

    public String toString() {
        return "ApplicationSummary{diskQuota=" + this.diskQuota + ", id=" + this.id + ", instances=" + this.instances + ", memoryLimit=" + this.memoryLimit + ", name=" + this.name + ", requestedState=" + this.requestedState + ", runningInstances=" + this.runningInstances + ", urls=" + this.urls + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_DISK_QUOTA = 1L;
        private static final long INIT_BIT_ID = 2L;
        private static final long INIT_BIT_INSTANCES = 4L;
        private static final long INIT_BIT_MEMORY_LIMIT = 8L;
        private static final long INIT_BIT_NAME = 16L;
        private static final long INIT_BIT_REQUESTED_STATE = 32L;
        private static final long INIT_BIT_RUNNING_INSTANCES = 64L;
        private long initBits = 127L;
        private Integer diskQuota;
        private String id;
        private Integer instances;
        private Integer memoryLimit;
        private String name;
        private String requestedState;
        private Integer runningInstances;
        private List<String> urls = new ArrayList<String>();

        private Builder() {
        }

        public final Builder from(AbstractApplicationSummary instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ApplicationSummary instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        final Builder from(_ApplicationSummary instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            if (object instanceof AbstractApplicationSummary) {
                AbstractApplicationSummary instance = (AbstractApplicationSummary)object;
                this.addAllUrls(instance.getUrls());
                this.instances(instance.getInstances());
                this.requestedState(instance.getRequestedState());
                this.name(instance.getName());
                this.memoryLimit(instance.getMemoryLimit());
                this.id(instance.getId());
                this.diskQuota(instance.getDiskQuota());
                this.runningInstances(instance.getRunningInstances());
            }
        }

        public final Builder diskQuota(Integer diskQuota) {
            this.diskQuota = Objects.requireNonNull(diskQuota, "diskQuota");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder instances(Integer instances) {
            this.instances = Objects.requireNonNull(instances, "instances");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder memoryLimit(Integer memoryLimit) {
            this.memoryLimit = Objects.requireNonNull(memoryLimit, "memoryLimit");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder requestedState(String requestedState) {
            this.requestedState = Objects.requireNonNull(requestedState, "requestedState");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public final Builder runningInstances(Integer runningInstances) {
            this.runningInstances = Objects.requireNonNull(runningInstances, "runningInstances");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        public final Builder url(String element) {
            this.urls.add(Objects.requireNonNull(element, "urls element"));
            return this;
        }

        public final Builder url(String ... elements) {
            for (String element : elements) {
                this.urls.add(Objects.requireNonNull(element, "urls element"));
            }
            return this;
        }

        public final Builder urls(Iterable<String> elements) {
            this.urls.clear();
            return this.addAllUrls(elements);
        }

        public final Builder addAllUrls(Iterable<String> elements) {
            for (String element : elements) {
                this.urls.add(Objects.requireNonNull(element, "urls element"));
            }
            return this;
        }

        public ApplicationSummary build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ApplicationSummary(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("diskQuota");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("instances");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("memoryLimit");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("requestedState");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("runningInstances");
            }
            return "Cannot build ApplicationSummary, some of required attributes are not set " + attributes;
        }
    }
}

