/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.operations.applications;

import java.util.Date;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.operations.applications._InstanceDetail;

public final class InstanceDetail
extends _InstanceDetail {
    @Nullable
    private final Double cpu;
    @Nullable
    private final Long diskQuota;
    @Nullable
    private final Long diskUsage;
    @Nullable
    private final Long memoryQuota;
    @Nullable
    private final Long memoryUsage;
    @Nullable
    private final Date since;
    @Nullable
    private final String state;

    private InstanceDetail(Builder builder) {
        this.cpu = builder.cpu;
        this.diskQuota = builder.diskQuota;
        this.diskUsage = builder.diskUsage;
        this.memoryQuota = builder.memoryQuota;
        this.memoryUsage = builder.memoryUsage;
        this.since = builder.since;
        this.state = builder.state;
    }

    @Override
    @Nullable
    public Double getCpu() {
        return this.cpu;
    }

    @Override
    @Nullable
    public Long getDiskQuota() {
        return this.diskQuota;
    }

    @Override
    @Nullable
    public Long getDiskUsage() {
        return this.diskUsage;
    }

    @Override
    @Nullable
    public Long getMemoryQuota() {
        return this.memoryQuota;
    }

    @Override
    @Nullable
    public Long getMemoryUsage() {
        return this.memoryUsage;
    }

    @Override
    @Nullable
    public Date getSince() {
        return this.since;
    }

    @Override
    @Nullable
    public String getState() {
        return this.state;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof InstanceDetail && this.equalTo((InstanceDetail)another);
    }

    private boolean equalTo(InstanceDetail another) {
        return Objects.equals(this.cpu, another.cpu) && Objects.equals(this.diskQuota, another.diskQuota) && Objects.equals(this.diskUsage, another.diskUsage) && Objects.equals(this.memoryQuota, another.memoryQuota) && Objects.equals(this.memoryUsage, another.memoryUsage) && Objects.equals(this.since, another.since) && Objects.equals(this.state, another.state);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Objects.hashCode(this.cpu);
        h = h * 17 + Objects.hashCode(this.diskQuota);
        h = h * 17 + Objects.hashCode(this.diskUsage);
        h = h * 17 + Objects.hashCode(this.memoryQuota);
        h = h * 17 + Objects.hashCode(this.memoryUsage);
        h = h * 17 + Objects.hashCode(this.since);
        h = h * 17 + Objects.hashCode(this.state);
        return h;
    }

    public String toString() {
        return "InstanceDetail{cpu=" + this.cpu + ", diskQuota=" + this.diskQuota + ", diskUsage=" + this.diskUsage + ", memoryQuota=" + this.memoryQuota + ", memoryUsage=" + this.memoryUsage + ", since=" + this.since + ", state=" + this.state + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Double cpu;
        private Long diskQuota;
        private Long diskUsage;
        private Long memoryQuota;
        private Long memoryUsage;
        private Date since;
        private String state;

        private Builder() {
        }

        public final Builder from(InstanceDetail instance) {
            return this.from((_InstanceDetail)instance);
        }

        final Builder from(_InstanceDetail instance) {
            String stateValue;
            Date sinceValue;
            Long memoryUsageValue;
            Long memoryQuotaValue;
            Long diskUsageValue;
            Long diskQuotaValue;
            Objects.requireNonNull(instance, "instance");
            Double cpuValue = instance.getCpu();
            if (cpuValue != null) {
                this.cpu(cpuValue);
            }
            if ((diskQuotaValue = instance.getDiskQuota()) != null) {
                this.diskQuota(diskQuotaValue);
            }
            if ((diskUsageValue = instance.getDiskUsage()) != null) {
                this.diskUsage(diskUsageValue);
            }
            if ((memoryQuotaValue = instance.getMemoryQuota()) != null) {
                this.memoryQuota(memoryQuotaValue);
            }
            if ((memoryUsageValue = instance.getMemoryUsage()) != null) {
                this.memoryUsage(memoryUsageValue);
            }
            if ((sinceValue = instance.getSince()) != null) {
                this.since(sinceValue);
            }
            if ((stateValue = instance.getState()) != null) {
                this.state(stateValue);
            }
            return this;
        }

        public final Builder cpu(@Nullable Double cpu) {
            this.cpu = cpu;
            return this;
        }

        public final Builder diskQuota(@Nullable Long diskQuota) {
            this.diskQuota = diskQuota;
            return this;
        }

        public final Builder diskUsage(@Nullable Long diskUsage) {
            this.diskUsage = diskUsage;
            return this;
        }

        public final Builder memoryQuota(@Nullable Long memoryQuota) {
            this.memoryQuota = memoryQuota;
            return this;
        }

        public final Builder memoryUsage(@Nullable Long memoryUsage) {
            this.memoryUsage = memoryUsage;
            return this;
        }

        public final Builder since(@Nullable Date since) {
            this.since = since;
            return this;
        }

        public final Builder state(@Nullable String state) {
            this.state = state;
            return this;
        }

        public InstanceDetail build() {
            return new InstanceDetail(this);
        }
    }
}

