/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.operations.domains;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.operations.domains._CreateDomainRequest;

public final class CreateDomainRequest
extends _CreateDomainRequest {
    private final String domain;
    private final String organization;

    private CreateDomainRequest(Builder builder) {
        this.domain = builder.domain;
        this.organization = builder.organization;
    }

    @Override
    public String getDomain() {
        return this.domain;
    }

    @Override
    public String getOrganization() {
        return this.organization;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CreateDomainRequest && this.equalTo((CreateDomainRequest)another);
    }

    private boolean equalTo(CreateDomainRequest another) {
        return this.domain.equals(another.domain) && this.organization.equals(another.organization);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.domain.hashCode();
        h = h * 17 + this.organization.hashCode();
        return h;
    }

    public String toString() {
        return "CreateDomainRequest{domain=" + this.domain + ", organization=" + this.organization + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_DOMAIN = 1L;
        private static final long INIT_BIT_ORGANIZATION = 2L;
        private long initBits = 3L;
        private String domain;
        private String organization;

        private Builder() {
        }

        public final Builder from(CreateDomainRequest instance) {
            return this.from((_CreateDomainRequest)instance);
        }

        final Builder from(_CreateDomainRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.domain(instance.getDomain());
            this.organization(instance.getOrganization());
            return this;
        }

        public final Builder domain(String domain) {
            this.domain = Objects.requireNonNull(domain, "domain");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder organization(String organization) {
            this.organization = Objects.requireNonNull(organization, "organization");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public CreateDomainRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new CreateDomainRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("domain");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("organization");
            }
            return "Cannot build CreateDomainRequest, some of required attributes are not set " + attributes;
        }
    }
}

