/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.operations.domains;

import java.util.NoSuchElementException;
import org.cloudfoundry.client.CloudFoundryClient;
import org.cloudfoundry.client.v2.Resource;
import org.cloudfoundry.client.v2.organizations.AssociateOrganizationPrivateDomainRequest;
import org.cloudfoundry.client.v2.organizations.AssociateOrganizationPrivateDomainResponse;
import org.cloudfoundry.client.v2.organizations.ListOrganizationsRequest;
import org.cloudfoundry.client.v2.organizations.OrganizationResource;
import org.cloudfoundry.client.v2.organizations.RemoveOrganizationPrivateDomainRequest;
import org.cloudfoundry.client.v2.privatedomains.CreatePrivateDomainRequest;
import org.cloudfoundry.client.v2.privatedomains.CreatePrivateDomainResponse;
import org.cloudfoundry.client.v2.privatedomains.ListPrivateDomainsRequest;
import org.cloudfoundry.client.v2.privatedomains.PrivateDomainEntity;
import org.cloudfoundry.client.v2.privatedomains.PrivateDomainResource;
import org.cloudfoundry.client.v2.shareddomains.CreateSharedDomainResponse;
import org.cloudfoundry.client.v2.shareddomains.ListSharedDomainsRequest;
import org.cloudfoundry.client.v2.shareddomains.SharedDomainEntity;
import org.cloudfoundry.client.v2.shareddomains.SharedDomainResource;
import org.cloudfoundry.operations.domains.CreateDomainRequest;
import org.cloudfoundry.operations.domains.CreateSharedDomainRequest;
import org.cloudfoundry.operations.domains.Domain;
import org.cloudfoundry.operations.domains.Domains;
import org.cloudfoundry.operations.domains.ShareDomainRequest;
import org.cloudfoundry.operations.domains.Status;
import org.cloudfoundry.operations.domains.UnshareDomainRequest;
import org.cloudfoundry.util.ExceptionUtils;
import org.cloudfoundry.util.PaginationUtils;
import org.cloudfoundry.util.ResourceUtils;
import org.cloudfoundry.util.tuple.TupleUtils;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class DefaultDomains
implements Domains {
    private final Mono<CloudFoundryClient> cloudFoundryClient;

    public DefaultDomains(Mono<CloudFoundryClient> cloudFoundryClient) {
        this.cloudFoundryClient = cloudFoundryClient;
    }

    @Override
    public Mono<Void> create(CreateDomainRequest request) {
        return this.cloudFoundryClient.then(cloudFoundryClient -> Mono.when((Mono)Mono.just((Object)cloudFoundryClient), DefaultDomains.getOrganizationId(cloudFoundryClient, request.getOrganization()))).then(TupleUtils.function((cloudFoundryClient, organizationId) -> DefaultDomains.requestCreateDomain(cloudFoundryClient, request.getDomain(), organizationId))).then();
    }

    @Override
    public Mono<Void> createShared(CreateSharedDomainRequest request) {
        return this.cloudFoundryClient.then(cloudFoundryClient -> DefaultDomains.requestCreateSharedDomain(cloudFoundryClient, request.getDomain())).then();
    }

    @Override
    public Flux<Domain> list() {
        return this.cloudFoundryClient.flatMap(cloudFoundryClient -> DefaultDomains.requestListPrivateDomains(cloudFoundryClient).map(DefaultDomains::toDomain).mergeWith((Publisher)DefaultDomains.requestListSharedDomains(cloudFoundryClient).map(DefaultDomains::toDomain)));
    }

    @Override
    public Mono<Void> share(ShareDomainRequest request) {
        return this.cloudFoundryClient.then(cloudFoundryClient -> Mono.when((Mono)Mono.just((Object)cloudFoundryClient), DefaultDomains.getPrivateDomainId(cloudFoundryClient, request.getDomain()), DefaultDomains.getOrganizationId(cloudFoundryClient, request.getOrganization()))).then(TupleUtils.function(DefaultDomains::requestAssociateOrganizationPrivateDomainRequest)).then();
    }

    @Override
    public Mono<Void> unshare(UnshareDomainRequest request) {
        return this.cloudFoundryClient.then(cloudFoundryClient -> Mono.when((Mono)Mono.just((Object)cloudFoundryClient), DefaultDomains.getPrivateDomainId(cloudFoundryClient, request.getDomain()), DefaultDomains.getOrganizationId(cloudFoundryClient, request.getOrganization()))).then(TupleUtils.function(DefaultDomains::requestRemoveOrganizationPrivateDomainRequest));
    }

    private static Mono<OrganizationResource> getOrganization(CloudFoundryClient cloudFoundryClient, String organization) {
        return DefaultDomains.requestOrganizations(cloudFoundryClient, organization).single().otherwise(NoSuchElementException.class, t -> ExceptionUtils.illegalArgument((String)"Organization %s does not exist", (Object[])new Object[]{organization}));
    }

    private static Mono<String> getOrganizationId(CloudFoundryClient cloudFoundryClient, String organization) {
        return DefaultDomains.getOrganization(cloudFoundryClient, organization).map(ResourceUtils::getId);
    }

    private static Mono<PrivateDomainResource> getPrivateDomain(CloudFoundryClient cloudFoundryClient, String domain) {
        return DefaultDomains.requestListPrivateDomains(cloudFoundryClient, domain).single().otherwise(NoSuchElementException.class, t -> ExceptionUtils.illegalArgument((String)"Private domain %s does not exist", (Object[])new Object[]{domain}));
    }

    private static Mono<String> getPrivateDomainId(CloudFoundryClient cloudFoundryClient, String domain) {
        return DefaultDomains.getPrivateDomain(cloudFoundryClient, domain).map(ResourceUtils::getId);
    }

    private static Mono<AssociateOrganizationPrivateDomainResponse> requestAssociateOrganizationPrivateDomainRequest(CloudFoundryClient cloudFoundryClient, String domainId, String organizationId) {
        return cloudFoundryClient.organizations().associatePrivateDomain(AssociateOrganizationPrivateDomainRequest.builder().organizationId(organizationId).privateDomainId(domainId).build());
    }

    private static Mono<CreatePrivateDomainResponse> requestCreateDomain(CloudFoundryClient cloudFoundryClient, String domain, String organizationId) {
        return cloudFoundryClient.privateDomains().create(CreatePrivateDomainRequest.builder().name(domain).owningOrganizationId(organizationId).build());
    }

    private static Mono<CreateSharedDomainResponse> requestCreateSharedDomain(CloudFoundryClient cloudFoundryClient, String domain) {
        return cloudFoundryClient.sharedDomains().create(org.cloudfoundry.client.v2.shareddomains.CreateSharedDomainRequest.builder().name(domain).build());
    }

    private static Flux<PrivateDomainResource> requestListPrivateDomains(CloudFoundryClient cloudFoundryClient, String domain) {
        return PaginationUtils.requestClientV2Resources(page -> cloudFoundryClient.privateDomains().list(ListPrivateDomainsRequest.builder().name(domain).page(page).build()));
    }

    private static Flux<PrivateDomainResource> requestListPrivateDomains(CloudFoundryClient cloudFoundryClient) {
        return PaginationUtils.requestClientV2Resources(page -> cloudFoundryClient.privateDomains().list(ListPrivateDomainsRequest.builder().page(page).build()));
    }

    private static Flux<SharedDomainResource> requestListSharedDomains(CloudFoundryClient cloudFoundryClient) {
        return PaginationUtils.requestClientV2Resources(page -> cloudFoundryClient.sharedDomains().list(ListSharedDomainsRequest.builder().page(page).build()));
    }

    private static Flux<OrganizationResource> requestOrganizations(CloudFoundryClient cloudFoundryClient, String organization) {
        return PaginationUtils.requestClientV2Resources(page -> cloudFoundryClient.organizations().list(ListOrganizationsRequest.builder().name(organization).page(page).build()));
    }

    private static Mono<Void> requestRemoveOrganizationPrivateDomainRequest(CloudFoundryClient cloudFoundryClient, String domainId, String organizationId) {
        return cloudFoundryClient.organizations().removePrivateDomain(RemoveOrganizationPrivateDomainRequest.builder().organizationId(organizationId).privateDomainId(domainId).build());
    }

    private static Domain toDomain(PrivateDomainResource resource) {
        PrivateDomainEntity entity = (PrivateDomainEntity)ResourceUtils.getEntity((Resource)resource);
        return Domain.builder().id(ResourceUtils.getId((Resource)resource)).name(entity.getName()).status(Status.OWNED).build();
    }

    private static Domain toDomain(SharedDomainResource resource) {
        SharedDomainEntity entity = (SharedDomainEntity)ResourceUtils.getEntity((Resource)resource);
        return Domain.builder().id(ResourceUtils.getId((Resource)resource)).name(entity.getName()).status(Status.SHARED).build();
    }
}

