/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.operations.routes;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.UnaryOperator;
import org.cloudfoundry.client.CloudFoundryClient;
import org.cloudfoundry.client.v2.Resource;
import org.cloudfoundry.client.v2.applications.ApplicationEntity;
import org.cloudfoundry.client.v2.applications.ApplicationResource;
import org.cloudfoundry.client.v2.applications.AssociateApplicationRouteRequest;
import org.cloudfoundry.client.v2.applications.AssociateApplicationRouteResponse;
import org.cloudfoundry.client.v2.applications.RemoveApplicationRouteRequest;
import org.cloudfoundry.client.v2.organizations.ListOrganizationPrivateDomainsRequest;
import org.cloudfoundry.client.v2.organizations.ListOrganizationSpacesRequest;
import org.cloudfoundry.client.v2.privatedomains.PrivateDomainEntity;
import org.cloudfoundry.client.v2.privatedomains.PrivateDomainResource;
import org.cloudfoundry.client.v2.routes.CreateRouteResponse;
import org.cloudfoundry.client.v2.routes.DeleteRouteResponse;
import org.cloudfoundry.client.v2.routes.ListRouteApplicationsRequest;
import org.cloudfoundry.client.v2.routes.ListRoutesRequest;
import org.cloudfoundry.client.v2.routes.RouteEntity;
import org.cloudfoundry.client.v2.routes.RouteExistsRequest;
import org.cloudfoundry.client.v2.routes.RouteResource;
import org.cloudfoundry.client.v2.shareddomains.ListSharedDomainsRequest;
import org.cloudfoundry.client.v2.shareddomains.SharedDomainEntity;
import org.cloudfoundry.client.v2.shareddomains.SharedDomainResource;
import org.cloudfoundry.client.v2.spaces.ListSpaceApplicationsRequest;
import org.cloudfoundry.client.v2.spaces.ListSpaceRoutesRequest;
import org.cloudfoundry.client.v2.spaces.SpaceEntity;
import org.cloudfoundry.client.v2.spaces.SpaceResource;
import org.cloudfoundry.operations.routes.CheckRouteRequest;
import org.cloudfoundry.operations.routes.CreateRouteRequest;
import org.cloudfoundry.operations.routes.DeleteRouteRequest;
import org.cloudfoundry.operations.routes.Level;
import org.cloudfoundry.operations.routes.ListRoutesRequest;
import org.cloudfoundry.operations.routes.MapRouteRequest;
import org.cloudfoundry.operations.routes.Route;
import org.cloudfoundry.operations.routes.Routes;
import org.cloudfoundry.operations.routes.UnmapRouteRequest;
import org.cloudfoundry.util.ExceptionUtils;
import org.cloudfoundry.util.JobUtils;
import org.cloudfoundry.util.OperationUtils;
import org.cloudfoundry.util.PaginationUtils;
import org.cloudfoundry.util.ResourceUtils;
import org.cloudfoundry.util.tuple.TupleUtils;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuples;

public final class DefaultRoutes
implements Routes {
    private final Mono<CloudFoundryClient> cloudFoundryClient;
    private final Mono<String> organizationId;
    private final Mono<String> spaceId;

    public DefaultRoutes(Mono<CloudFoundryClient> cloudFoundryClient, Mono<String> organizationId, Mono<String> spaceId) {
        this.cloudFoundryClient = cloudFoundryClient;
        this.organizationId = organizationId;
        this.spaceId = spaceId;
    }

    @Override
    public Mono<Boolean> check(CheckRouteRequest request) {
        return Mono.when(this.cloudFoundryClient, this.organizationId).then(TupleUtils.function((cloudFoundryClient, organizationId) -> Mono.when((Mono)Mono.just((Object)cloudFoundryClient), DefaultRoutes.getOptionalDomainId(cloudFoundryClient, organizationId, request.getDomain())))).then(TupleUtils.function((cloudFoundryClient, domainId) -> DefaultRoutes.requestRouteExists(cloudFoundryClient, domainId, request.getHost(), request.getPath()))).defaultIfEmpty((Object)false);
    }

    @Override
    public Mono<Void> create(CreateRouteRequest request) {
        return Mono.when(this.cloudFoundryClient, this.organizationId).then(TupleUtils.function((cloudFoundryClient, organizationId) -> Mono.when((Mono)Mono.just((Object)cloudFoundryClient), DefaultRoutes.getSpaceId(cloudFoundryClient, organizationId, request.getSpace()), DefaultRoutes.getDomainId(cloudFoundryClient, organizationId, request.getDomain())))).then(TupleUtils.function((cloudFoundryClient, spaceId, domainId) -> DefaultRoutes.requestCreateRoute(cloudFoundryClient, domainId, request.getHost(), request.getPath(), spaceId))).then();
    }

    @Override
    public Mono<Void> delete(DeleteRouteRequest request) {
        return Mono.when(this.cloudFoundryClient, this.organizationId).then(TupleUtils.function((cloudFoundryClient, organizationId) -> Mono.when((Mono)Mono.just((Object)cloudFoundryClient), DefaultRoutes.getDomainId(cloudFoundryClient, organizationId, request.getDomain())))).then(TupleUtils.function((cloudFoundryClient, domainId) -> Mono.when((Mono)Mono.just((Object)cloudFoundryClient), DefaultRoutes.getRouteId(cloudFoundryClient, request.getHost(), request.getDomain(), domainId, request.getPath())))).then(TupleUtils.function(DefaultRoutes::deleteRoute));
    }

    @Override
    public Mono<Void> deleteOrphanedRoutes() {
        return Mono.when(this.cloudFoundryClient, this.spaceId).flatMap(TupleUtils.function((cloudFoundryClient, spaceId) -> DefaultRoutes.requestSpaceRoutes(cloudFoundryClient, spaceId).map(ResourceUtils::getId).map(routeId -> Tuples.of((Object)cloudFoundryClient, (Object)routeId)))).flatMap(TupleUtils.function((cloudFoundryClient, routeId) -> DefaultRoutes.getApplications(cloudFoundryClient, routeId).map(applicationResources -> Tuples.of((Object)cloudFoundryClient, (Object)applicationResources, (Object)routeId)))).filter(TupleUtils.predicate((cloudFoundryClient, applicationResources, routeId) -> DefaultRoutes.isOrphan(applicationResources))).flatMap(TupleUtils.function((cloudFoundryClient, applicationResources, routeId) -> DefaultRoutes.deleteRoute(cloudFoundryClient, routeId))).then();
    }

    @Override
    public Flux<Route> list(ListRoutesRequest request) {
        return Mono.when(this.cloudFoundryClient, this.organizationId).then(TupleUtils.function((cloudFoundryClient, organizationId) -> Mono.when((Mono)Mono.just((Object)cloudFoundryClient), DefaultRoutes.getAllDomains(cloudFoundryClient, organizationId), DefaultRoutes.getAllSpaces(cloudFoundryClient, organizationId)))).flatMap(TupleUtils.function((cloudFoundryClient, domains, spaces) -> DefaultRoutes.getRoutes(cloudFoundryClient, request, this.organizationId, this.spaceId).map(resource -> Tuples.of((Object)cloudFoundryClient, (Object)domains, (Object)resource, (Object)spaces)))).flatMap(TupleUtils.function((cloudFoundryClient, domains, resource, spaces) -> Mono.when(DefaultRoutes.getApplicationNames(cloudFoundryClient, ResourceUtils.getId((Resource)resource)), DefaultRoutes.getDomainName(domains, ((RouteEntity)ResourceUtils.getEntity((Resource)resource)).getDomainId()), (Mono)Mono.just((Object)resource), DefaultRoutes.getSpaceName(spaces, ((RouteEntity)ResourceUtils.getEntity((Resource)resource)).getSpaceId())))).map(TupleUtils.function(DefaultRoutes::toRoute));
    }

    @Override
    public Mono<Void> map(MapRouteRequest request) {
        return Mono.when(this.cloudFoundryClient, this.organizationId, this.spaceId).then(TupleUtils.function((cloudFoundryClient, organizationId, spaceId) -> Mono.when((Mono)Mono.just((Object)cloudFoundryClient), DefaultRoutes.getOrCreateRoute(cloudFoundryClient, organizationId, spaceId, request.getDomain(), request.getHost(), request.getPath()), DefaultRoutes.getApplicationId(cloudFoundryClient, request.getApplicationName(), spaceId)))).then(TupleUtils.function((cloudFoundryClient, routeId, applicationId) -> DefaultRoutes.requestAssociateRoute(cloudFoundryClient, applicationId, routeId))).then();
    }

    @Override
    public Mono<Void> unmap(UnmapRouteRequest request) {
        return Mono.when(this.cloudFoundryClient, this.organizationId, this.spaceId).then(TupleUtils.function((cloudFoundryClient, organizationId, spaceId) -> Mono.when((Mono)Mono.just((Object)cloudFoundryClient), DefaultRoutes.getApplicationId(cloudFoundryClient, request.getApplicationName(), spaceId), (Mono)DefaultRoutes.getDomainId(cloudFoundryClient, organizationId, request.getDomain()).then(domainId -> DefaultRoutes.getRouteId(cloudFoundryClient, request.getHost(), request.getDomain(), domainId, request.getPath()))))).then(TupleUtils.function(DefaultRoutes::requestRemoveRouteFromApplication));
    }

    private static Mono<Void> deleteRoute(CloudFoundryClient cloudFoundryClient, String routeId) {
        return DefaultRoutes.requestDeleteRoute(cloudFoundryClient, routeId).then(job -> JobUtils.waitForCompletion((CloudFoundryClient)cloudFoundryClient, (Resource)job));
    }

    private static Mono<Map<String, String>> getAllDomains(CloudFoundryClient cloudFoundryClient, String organizationId) {
        return DefaultRoutes.requestAllPrivateDomains(cloudFoundryClient, organizationId).map(resource -> Tuples.of((Object)ResourceUtils.getId((Resource)resource), (Object)((PrivateDomainEntity)ResourceUtils.getEntity((Resource)resource)).getName())).mergeWith((Publisher)DefaultRoutes.requestAllSharedDomains(cloudFoundryClient).map(resource -> Tuples.of((Object)ResourceUtils.getId((Resource)resource), (Object)((SharedDomainEntity)ResourceUtils.getEntity((Resource)resource)).getName()))).collectMap(TupleUtils.function((id, name) -> id), TupleUtils.function((id, name) -> name));
    }

    private static Mono<Map<String, String>> getAllSpaces(CloudFoundryClient cloudFoundryClient, String organizationId) {
        return DefaultRoutes.requestAllSpaces(cloudFoundryClient, organizationId).map(resource -> Tuples.of((Object)ResourceUtils.getId((Resource)resource), (Object)((SpaceEntity)ResourceUtils.getEntity((Resource)resource)).getName())).collectMap(TupleUtils.function((id, name) -> id), TupleUtils.function((id, name) -> name));
    }

    private static Mono<ApplicationResource> getApplication(CloudFoundryClient cloudFoundryClient, String application, String spaceId) {
        return DefaultRoutes.requestApplications(cloudFoundryClient, application, spaceId).single().otherwise(NoSuchElementException.class, t -> ExceptionUtils.illegalArgument((String)"Application %s does not exist", (Object[])new Object[]{application}));
    }

    private static Mono<String> getApplicationId(CloudFoundryClient cloudFoundryClient, String application, String spaceId) {
        return DefaultRoutes.getApplication(cloudFoundryClient, application, spaceId).map(ResourceUtils::getId);
    }

    private static Mono<List<String>> getApplicationNames(CloudFoundryClient cloudFoundryClient, String routeId) {
        return DefaultRoutes.requestApplications(cloudFoundryClient, routeId).map(resource -> ((ApplicationEntity)ResourceUtils.getEntity((Resource)resource)).getName()).collectList();
    }

    private static Mono<List<ApplicationResource>> getApplications(CloudFoundryClient cloudFoundryClient, String routeId) {
        return DefaultRoutes.requestApplications(cloudFoundryClient, routeId).collectList();
    }

    private static Mono<Resource<?>> getDomain(CloudFoundryClient cloudFoundryClient, String organizationId, String domain) {
        return DefaultRoutes.getDomains(cloudFoundryClient, organizationId, domain).single().otherwise(NoSuchElementException.class, t -> ExceptionUtils.illegalArgument((String)"Domain %s does not exist", (Object[])new Object[]{domain}));
    }

    private static Mono<String> getDomainId(CloudFoundryClient cloudFoundryClient, String organizationId, String domain) {
        return DefaultRoutes.getDomain(cloudFoundryClient, organizationId, domain).map(ResourceUtils::getId);
    }

    private static Mono<String> getDomainName(Map<String, String> domains, String domainId) {
        return Mono.just((Object)domains.get(domainId));
    }

    private static Flux<Resource<?>> getDomains(CloudFoundryClient cloudFoundryClient, String organizationId, String domain) {
        return DefaultRoutes.requestPrivateDomains(cloudFoundryClient, organizationId, domain).map(OperationUtils.cast()).switchIfEmpty((Publisher)DefaultRoutes.requestSharedDomains(cloudFoundryClient, domain).map(OperationUtils.cast()));
    }

    private static Mono<String> getOptionalDomainId(CloudFoundryClient cloudFoundryClient, String organizationId, String domain) {
        return DefaultRoutes.getDomains(cloudFoundryClient, organizationId, domain).singleOrEmpty().map(ResourceUtils::getId);
    }

    private static Mono<String> getOrCreateRoute(CloudFoundryClient cloudFoundryClient, String organizationId, String spaceId, String domain, String host, String path) {
        return DefaultRoutes.getDomainId(cloudFoundryClient, organizationId, domain).then(domainId -> DefaultRoutes.requestRoutes(cloudFoundryClient, domainId, host, path).singleOrEmpty().map(OperationUtils.cast()).otherwiseIfEmpty(DefaultRoutes.requestCreateRoute(cloudFoundryClient, domainId, host, path, spaceId))).map(ResourceUtils::getId);
    }

    private static Mono<RouteResource> getRoute(CloudFoundryClient cloudFoundryClient, String host, String domain, String domainId, String path) {
        return DefaultRoutes.requestRoutes(cloudFoundryClient, domainId, host, path).single().otherwise(NoSuchElementException.class, t -> ExceptionUtils.illegalArgument((String)"Route %s.%s does not exist", (Object[])new Object[]{host, domain}));
    }

    private static Mono<String> getRouteId(CloudFoundryClient cloudFoundryClient, String host, String domain, String domainId, String path) {
        return DefaultRoutes.getRoute(cloudFoundryClient, host, domain, domainId, path).map(ResourceUtils::getId);
    }

    private static Flux<RouteResource> getRoutes(CloudFoundryClient cloudFoundryClient, ListRoutesRequest request, Mono<String> organizationId, Mono<String> spaceId) {
        if (Level.ORGANIZATION == request.getLevel()) {
            return organizationId.flatMap(organizationId1 -> DefaultRoutes.requestRoutes(cloudFoundryClient, builder -> builder.organizationId(organizationId1)));
        }
        return spaceId.flatMap(spaceId1 -> DefaultRoutes.requestSpaceRoutes(cloudFoundryClient, spaceId1));
    }

    private static Mono<SpaceResource> getSpace(CloudFoundryClient cloudFoundryClient, String organizationId, String space) {
        return DefaultRoutes.requestSpaces(cloudFoundryClient, organizationId, space).single().otherwise(NoSuchElementException.class, t -> ExceptionUtils.illegalArgument((String)"Space %s does not exist", (Object[])new Object[]{space}));
    }

    private static Mono<String> getSpaceId(CloudFoundryClient cloudFoundryClient, String organizationId, String space) {
        return DefaultRoutes.getSpace(cloudFoundryClient, organizationId, space).map(ResourceUtils::getId);
    }

    private static Mono<String> getSpaceName(Map<String, String> spaces, String spaceId) {
        return Mono.just((Object)spaces.get(spaceId));
    }

    private static boolean isOrphan(List<ApplicationResource> applications) {
        return applications.isEmpty();
    }

    private static Flux<PrivateDomainResource> requestAllPrivateDomains(CloudFoundryClient cloudFoundryClient, String organizationId) {
        return PaginationUtils.requestClientV2Resources(page -> cloudFoundryClient.organizations().listPrivateDomains(ListOrganizationPrivateDomainsRequest.builder().organizationId(organizationId).page(page).build()));
    }

    private static Flux<SharedDomainResource> requestAllSharedDomains(CloudFoundryClient cloudFoundryClient) {
        return PaginationUtils.requestClientV2Resources(page -> cloudFoundryClient.sharedDomains().list(ListSharedDomainsRequest.builder().page(page).build()));
    }

    private static Flux<SpaceResource> requestAllSpaces(CloudFoundryClient cloudFoundryClient, String organizationId) {
        return PaginationUtils.requestClientV2Resources(page -> cloudFoundryClient.organizations().listSpaces(ListOrganizationSpacesRequest.builder().organizationId(organizationId).page(page).build()));
    }

    private static Flux<ApplicationResource> requestApplications(CloudFoundryClient cloudFoundryClient, String routeId) {
        return PaginationUtils.requestClientV2Resources(page -> cloudFoundryClient.routes().listApplications(ListRouteApplicationsRequest.builder().routeId(routeId).page(page).build()));
    }

    private static Flux<ApplicationResource> requestApplications(CloudFoundryClient cloudFoundryClient, String application, String spaceId) {
        return PaginationUtils.requestClientV2Resources(page -> cloudFoundryClient.spaces().listApplications(ListSpaceApplicationsRequest.builder().name(application).page(page).spaceId(spaceId).build()));
    }

    private static Mono<AssociateApplicationRouteResponse> requestAssociateRoute(CloudFoundryClient cloudFoundryClient, String applicationId, String routeId) {
        return cloudFoundryClient.applicationsV2().associateRoute(AssociateApplicationRouteRequest.builder().applicationId(applicationId).routeId(routeId).build());
    }

    private static Mono<CreateRouteResponse> requestCreateRoute(CloudFoundryClient cloudFoundryClient, String domainId, String host, String path, String spaceId) {
        return cloudFoundryClient.routes().create(org.cloudfoundry.client.v2.routes.CreateRouteRequest.builder().domainId(domainId).host(host).path(path).spaceId(spaceId).build());
    }

    private static Mono<DeleteRouteResponse> requestDeleteRoute(CloudFoundryClient cloudFoundryClient, String routeId) {
        return cloudFoundryClient.routes().delete(org.cloudfoundry.client.v2.routes.DeleteRouteRequest.builder().async(Boolean.valueOf(true)).routeId(routeId).build());
    }

    private static Flux<PrivateDomainResource> requestPrivateDomains(CloudFoundryClient cloudFoundryClient, String organizationId, String domain) {
        return PaginationUtils.requestClientV2Resources(page -> cloudFoundryClient.organizations().listPrivateDomains(ListOrganizationPrivateDomainsRequest.builder().organizationId(organizationId).name(domain).page(page).build()));
    }

    private static Mono<Void> requestRemoveRouteFromApplication(CloudFoundryClient cloudFoundryClient, String applicationId, String routeId) {
        return cloudFoundryClient.applicationsV2().removeRoute(RemoveApplicationRouteRequest.builder().applicationId(applicationId).routeId(routeId).build());
    }

    private static Mono<Boolean> requestRouteExists(CloudFoundryClient cloudFoundryClient, String domainId, String host, String path) {
        return cloudFoundryClient.routes().exists(RouteExistsRequest.builder().domainId(domainId).host(host).path(path).build());
    }

    private static Flux<RouteResource> requestRoutes(CloudFoundryClient cloudFoundryClient, UnaryOperator<ListRoutesRequest.Builder> modifier) {
        ListRoutesRequest.Builder listBuilder = (ListRoutesRequest.Builder)modifier.apply(org.cloudfoundry.client.v2.routes.ListRoutesRequest.builder());
        return PaginationUtils.requestClientV2Resources(page -> cloudFoundryClient.routes().list(listBuilder.page(page).build()));
    }

    private static Flux<RouteResource> requestRoutes(CloudFoundryClient cloudFoundryClient, String domainId, String host, String path) {
        return DefaultRoutes.requestRoutes(cloudFoundryClient, builder -> builder.domainId(domainId).hosts((Iterable)Optional.ofNullable(host).map(Collections::singletonList).orElse(null)).paths((Iterable)Optional.ofNullable(path).map(Collections::singletonList).orElse(null)));
    }

    private static Flux<SharedDomainResource> requestSharedDomains(CloudFoundryClient cloudFoundryClient, String domain) {
        return PaginationUtils.requestClientV2Resources(page -> cloudFoundryClient.sharedDomains().list(ListSharedDomainsRequest.builder().name(domain).page(page).build()));
    }

    private static Flux<RouteResource> requestSpaceRoutes(CloudFoundryClient cloudFoundryClient, String spaceId) {
        return PaginationUtils.requestClientV2Resources(page -> cloudFoundryClient.spaces().listRoutes(ListSpaceRoutesRequest.builder().spaceId(spaceId).page(page).build()));
    }

    private static Flux<SpaceResource> requestSpaces(CloudFoundryClient cloudFoundryClient, String organizationId, String space) {
        return PaginationUtils.requestClientV2Resources(page -> cloudFoundryClient.organizations().listSpaces(ListOrganizationSpacesRequest.builder().organizationId(organizationId).name(space).page(page).build()));
    }

    private static Route toRoute(List<String> applications, String domain, RouteResource resource, String space) {
        RouteEntity entity = (RouteEntity)ResourceUtils.getEntity((Resource)resource);
        return Route.builder().applications(applications).domain(domain).host(entity.getHost()).id(ResourceUtils.getId((Resource)resource)).path(entity.getPath()).space(space).build();
    }
}

