/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.operations.routes;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.operations.routes._DeleteRouteRequest;

public final class DeleteRouteRequest
extends _DeleteRouteRequest {
    private final String domain;
    @Nullable
    private final String host;
    @Nullable
    private final String path;

    private DeleteRouteRequest(Builder builder) {
        this.domain = builder.domain;
        this.host = builder.host;
        this.path = builder.path;
    }

    @Override
    public String getDomain() {
        return this.domain;
    }

    @Override
    @Nullable
    public String getHost() {
        return this.host;
    }

    @Override
    @Nullable
    public String getPath() {
        return this.path;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof DeleteRouteRequest && this.equalTo((DeleteRouteRequest)another);
    }

    private boolean equalTo(DeleteRouteRequest another) {
        return this.domain.equals(another.domain) && Objects.equals(this.host, another.host) && Objects.equals(this.path, another.path);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.domain.hashCode();
        h = h * 17 + Objects.hashCode(this.host);
        h = h * 17 + Objects.hashCode(this.path);
        return h;
    }

    public String toString() {
        return "DeleteRouteRequest{domain=" + this.domain + ", host=" + this.host + ", path=" + this.path + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_DOMAIN = 1L;
        private long initBits = 1L;
        private String domain;
        private String host;
        private String path;

        private Builder() {
        }

        public final Builder from(DeleteRouteRequest instance) {
            return this.from((_DeleteRouteRequest)instance);
        }

        final Builder from(_DeleteRouteRequest instance) {
            String pathValue;
            Objects.requireNonNull(instance, "instance");
            this.domain(instance.getDomain());
            String hostValue = instance.getHost();
            if (hostValue != null) {
                this.host(hostValue);
            }
            if ((pathValue = instance.getPath()) != null) {
                this.path(pathValue);
            }
            return this;
        }

        public final Builder domain(String domain) {
            this.domain = Objects.requireNonNull(domain, "domain");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder host(@Nullable String host) {
            this.host = host;
            return this;
        }

        public final Builder path(@Nullable String path) {
            this.path = path;
            return this;
        }

        public DeleteRouteRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new DeleteRouteRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("domain");
            }
            return "Cannot build DeleteRouteRequest, some of required attributes are not set " + attributes;
        }
    }
}

