/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.operations.routes;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.operations.routes._MapRouteRequest;

public final class MapRouteRequest
extends _MapRouteRequest {
    private final String applicationName;
    private final String domain;
    @Nullable
    private final String host;
    @Nullable
    private final String path;

    private MapRouteRequest(Builder builder) {
        this.applicationName = builder.applicationName;
        this.domain = builder.domain;
        this.host = builder.host;
        this.path = builder.path;
    }

    @Override
    public String getApplicationName() {
        return this.applicationName;
    }

    @Override
    public String getDomain() {
        return this.domain;
    }

    @Override
    @Nullable
    public String getHost() {
        return this.host;
    }

    @Override
    @Nullable
    public String getPath() {
        return this.path;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof MapRouteRequest && this.equalTo((MapRouteRequest)another);
    }

    private boolean equalTo(MapRouteRequest another) {
        return this.applicationName.equals(another.applicationName) && this.domain.equals(another.domain) && Objects.equals(this.host, another.host) && Objects.equals(this.path, another.path);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.applicationName.hashCode();
        h = h * 17 + this.domain.hashCode();
        h = h * 17 + Objects.hashCode(this.host);
        h = h * 17 + Objects.hashCode(this.path);
        return h;
    }

    public String toString() {
        return "MapRouteRequest{applicationName=" + this.applicationName + ", domain=" + this.domain + ", host=" + this.host + ", path=" + this.path + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_APPLICATION_NAME = 1L;
        private static final long INIT_BIT_DOMAIN = 2L;
        private long initBits = 3L;
        private String applicationName;
        private String domain;
        private String host;
        private String path;

        private Builder() {
        }

        public final Builder from(MapRouteRequest instance) {
            return this.from((_MapRouteRequest)instance);
        }

        final Builder from(_MapRouteRequest instance) {
            String pathValue;
            Objects.requireNonNull(instance, "instance");
            this.applicationName(instance.getApplicationName());
            this.domain(instance.getDomain());
            String hostValue = instance.getHost();
            if (hostValue != null) {
                this.host(hostValue);
            }
            if ((pathValue = instance.getPath()) != null) {
                this.path(pathValue);
            }
            return this;
        }

        public final Builder applicationName(String applicationName) {
            this.applicationName = Objects.requireNonNull(applicationName, "applicationName");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder domain(String domain) {
            this.domain = Objects.requireNonNull(domain, "domain");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder host(@Nullable String host) {
            this.host = host;
            return this;
        }

        public final Builder path(@Nullable String path) {
            this.path = path;
            return this;
        }

        public MapRouteRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new MapRouteRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("applicationName");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("domain");
            }
            return "Cannot build MapRouteRequest, some of required attributes are not set " + attributes;
        }
    }
}

