/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.operations.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.operations.services._CreateServiceInstanceRequest;

public final class CreateServiceInstanceRequest
extends _CreateServiceInstanceRequest {
    @Nullable
    private final Map<String, Object> parameters;
    private final String planName;
    private final String serviceInstanceName;
    private final String serviceName;
    @Nullable
    private final List<String> tags;

    private CreateServiceInstanceRequest(Builder builder) {
        this.parameters = builder.parameters == null ? null : CreateServiceInstanceRequest.createUnmodifiableMap(false, false, builder.parameters);
        this.planName = builder.planName;
        this.serviceInstanceName = builder.serviceInstanceName;
        this.serviceName = builder.serviceName;
        this.tags = builder.tags == null ? null : CreateServiceInstanceRequest.createUnmodifiableList(true, builder.tags);
    }

    @Override
    @Nullable
    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    @Override
    public String getPlanName() {
        return this.planName;
    }

    @Override
    public String getServiceInstanceName() {
        return this.serviceInstanceName;
    }

    @Override
    public String getServiceName() {
        return this.serviceName;
    }

    @Override
    @Nullable
    public List<String> getTags() {
        return this.tags;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CreateServiceInstanceRequest && this.equalTo((CreateServiceInstanceRequest)another);
    }

    private boolean equalTo(CreateServiceInstanceRequest another) {
        return Objects.equals(this.parameters, another.parameters) && this.planName.equals(another.planName) && this.serviceInstanceName.equals(another.serviceInstanceName) && this.serviceName.equals(another.serviceName) && Objects.equals(this.tags, another.tags);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Objects.hashCode(this.parameters);
        h = h * 17 + this.planName.hashCode();
        h = h * 17 + this.serviceInstanceName.hashCode();
        h = h * 17 + this.serviceName.hashCode();
        h = h * 17 + Objects.hashCode(this.tags);
        return h;
    }

    public String toString() {
        return "CreateServiceInstanceRequest{parameters=" + this.parameters + ", planName=" + this.planName + ", serviceInstanceName=" + this.serviceInstanceName + ", serviceName=" + this.serviceName + ", tags=" + this.tags + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    public static final class Builder {
        private static final long INIT_BIT_PLAN_NAME = 1L;
        private static final long INIT_BIT_SERVICE_INSTANCE_NAME = 2L;
        private static final long INIT_BIT_SERVICE_NAME = 4L;
        private long initBits = 7L;
        private Map<String, Object> parameters = null;
        private String planName;
        private String serviceInstanceName;
        private String serviceName;
        private List<String> tags = null;

        private Builder() {
        }

        public final Builder from(CreateServiceInstanceRequest instance) {
            return this.from((_CreateServiceInstanceRequest)instance);
        }

        final Builder from(_CreateServiceInstanceRequest instance) {
            Objects.requireNonNull(instance, "instance");
            Map<String, Object> parametersValue = instance.getParameters();
            if (parametersValue != null) {
                this.putAllParameters(parametersValue);
            }
            this.planName(instance.getPlanName());
            this.serviceInstanceName(instance.getServiceInstanceName());
            this.serviceName(instance.getServiceName());
            List<String> tagsValue = instance.getTags();
            if (tagsValue != null) {
                this.addAllTags(tagsValue);
            }
            return this;
        }

        public final Builder parameter(String key, Object value) {
            if (this.parameters == null) {
                this.parameters = new LinkedHashMap<String, Object>();
            }
            this.parameters.put(Objects.requireNonNull(key, "parameters key"), Objects.requireNonNull(value, "parameters value"));
            return this;
        }

        public final Builder parameter(Map.Entry<String, ? extends Object> entry) {
            if (this.parameters == null) {
                this.parameters = new LinkedHashMap<String, Object>();
            }
            String k = entry.getKey();
            Object v = entry.getValue();
            this.parameters.put(Objects.requireNonNull(k, "parameters key"), Objects.requireNonNull(v, "parameters value"));
            return this;
        }

        public final Builder parameters(@Nullable Map<String, ? extends Object> parameters) {
            if (parameters == null) {
                this.parameters = null;
                return this;
            }
            this.parameters = new LinkedHashMap<String, Object>();
            return this.putAllParameters(parameters);
        }

        public final Builder putAllParameters(Map<String, ? extends Object> parameters) {
            if (this.parameters == null) {
                this.parameters = new LinkedHashMap<String, Object>();
            }
            for (Map.Entry<String, ? extends Object> entry : parameters.entrySet()) {
                String k = entry.getKey();
                Object v = entry.getValue();
                this.parameters.put(Objects.requireNonNull(k, "parameters key"), Objects.requireNonNull(v, "parameters value"));
            }
            return this;
        }

        public final Builder planName(String planName) {
            this.planName = Objects.requireNonNull(planName, "planName");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder serviceInstanceName(String serviceInstanceName) {
            this.serviceInstanceName = Objects.requireNonNull(serviceInstanceName, "serviceInstanceName");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder serviceName(String serviceName) {
            this.serviceName = Objects.requireNonNull(serviceName, "serviceName");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder tag(String element) {
            if (this.tags == null) {
                this.tags = new ArrayList<String>();
            }
            this.tags.add(Objects.requireNonNull(element, "tags element"));
            return this;
        }

        public final Builder tag(String ... elements) {
            if (this.tags == null) {
                this.tags = new ArrayList<String>();
            }
            for (String element : elements) {
                this.tags.add(Objects.requireNonNull(element, "tags element"));
            }
            return this;
        }

        public final Builder tags(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.tags = null;
                return this;
            }
            this.tags = new ArrayList<String>();
            return this.addAllTags(elements);
        }

        public final Builder addAllTags(Iterable<String> elements) {
            Objects.requireNonNull(elements, "tags element");
            if (this.tags == null) {
                this.tags = new ArrayList<String>();
            }
            for (String element : elements) {
                this.tags.add(Objects.requireNonNull(element, "tags element"));
            }
            return this;
        }

        public CreateServiceInstanceRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new CreateServiceInstanceRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("planName");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("serviceInstanceName");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("serviceName");
            }
            return "Cannot build CreateServiceInstanceRequest, some of required attributes are not set " + attributes;
        }
    }
}

