/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.operations.services;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.operations.services._DeleteServiceKeyRequest;

public final class DeleteServiceKeyRequest
extends _DeleteServiceKeyRequest {
    private final String serviceInstanceName;
    private final String serviceKeyName;

    private DeleteServiceKeyRequest(Builder builder) {
        this.serviceInstanceName = builder.serviceInstanceName;
        this.serviceKeyName = builder.serviceKeyName;
    }

    @Override
    public String getServiceInstanceName() {
        return this.serviceInstanceName;
    }

    @Override
    public String getServiceKeyName() {
        return this.serviceKeyName;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof DeleteServiceKeyRequest && this.equalTo((DeleteServiceKeyRequest)another);
    }

    private boolean equalTo(DeleteServiceKeyRequest another) {
        return this.serviceInstanceName.equals(another.serviceInstanceName) && this.serviceKeyName.equals(another.serviceKeyName);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.serviceInstanceName.hashCode();
        h = h * 17 + this.serviceKeyName.hashCode();
        return h;
    }

    public String toString() {
        return "DeleteServiceKeyRequest{serviceInstanceName=" + this.serviceInstanceName + ", serviceKeyName=" + this.serviceKeyName + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_SERVICE_INSTANCE_NAME = 1L;
        private static final long INIT_BIT_SERVICE_KEY_NAME = 2L;
        private long initBits = 3L;
        private String serviceInstanceName;
        private String serviceKeyName;

        private Builder() {
        }

        public final Builder from(DeleteServiceKeyRequest instance) {
            return this.from((_DeleteServiceKeyRequest)instance);
        }

        final Builder from(_DeleteServiceKeyRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.serviceInstanceName(instance.getServiceInstanceName());
            this.serviceKeyName(instance.getServiceKeyName());
            return this;
        }

        public final Builder serviceInstanceName(String serviceInstanceName) {
            this.serviceInstanceName = Objects.requireNonNull(serviceInstanceName, "serviceInstanceName");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder serviceKeyName(String serviceKeyName) {
            this.serviceKeyName = Objects.requireNonNull(serviceKeyName, "serviceKeyName");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public DeleteServiceKeyRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new DeleteServiceKeyRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("serviceInstanceName");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("serviceKeyName");
            }
            return "Cannot build DeleteServiceKeyRequest, some of required attributes are not set " + attributes;
        }
    }
}

