/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.operations.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.operations.services.ServiceInstanceType;
import org.cloudfoundry.operations.services._ServiceInstance;

public final class ServiceInstance
extends _ServiceInstance {
    private final List<String> applications;
    @Nullable
    private final String dashboardUrl;
    @Nullable
    private final String description;
    @Nullable
    private final String documentationUrl;
    private final String id;
    @Nullable
    private final String lastOperation;
    @Nullable
    private final String message;
    private final String name;
    @Nullable
    private final String plan;
    @Nullable
    private final String service;
    @Nullable
    private final String startedAt;
    @Nullable
    private final String status;
    @Nullable
    private final List<String> tags;
    private final ServiceInstanceType type;
    @Nullable
    private final String updatedAt;

    private ServiceInstance(Builder builder) {
        this.applications = ServiceInstance.createUnmodifiableList(true, builder.applications);
        this.dashboardUrl = builder.dashboardUrl;
        this.description = builder.description;
        this.documentationUrl = builder.documentationUrl;
        this.id = builder.id;
        this.lastOperation = builder.lastOperation;
        this.message = builder.message;
        this.name = builder.name;
        this.plan = builder.plan;
        this.service = builder.service;
        this.startedAt = builder.startedAt;
        this.status = builder.status;
        this.tags = builder.tags == null ? null : ServiceInstance.createUnmodifiableList(true, builder.tags);
        this.type = builder.type;
        this.updatedAt = builder.updatedAt;
    }

    @Override
    public List<String> getApplications() {
        return this.applications;
    }

    @Override
    @Nullable
    public String getDashboardUrl() {
        return this.dashboardUrl;
    }

    @Override
    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Override
    @Nullable
    public String getDocumentationUrl() {
        return this.documentationUrl;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    @Nullable
    public String getLastOperation() {
        return this.lastOperation;
    }

    @Override
    @Nullable
    public String getMessage() {
        return this.message;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public String getPlan() {
        return this.plan;
    }

    @Override
    @Nullable
    public String getService() {
        return this.service;
    }

    @Override
    @Nullable
    public String getStartedAt() {
        return this.startedAt;
    }

    @Override
    @Nullable
    public String getStatus() {
        return this.status;
    }

    @Override
    @Nullable
    public List<String> getTags() {
        return this.tags;
    }

    @Override
    public ServiceInstanceType getType() {
        return this.type;
    }

    @Override
    @Nullable
    public String getUpdatedAt() {
        return this.updatedAt;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ServiceInstance && this.equalTo((ServiceInstance)another);
    }

    private boolean equalTo(ServiceInstance another) {
        return this.applications.equals(another.applications) && Objects.equals(this.dashboardUrl, another.dashboardUrl) && Objects.equals(this.description, another.description) && Objects.equals(this.documentationUrl, another.documentationUrl) && this.id.equals(another.id) && Objects.equals(this.lastOperation, another.lastOperation) && Objects.equals(this.message, another.message) && this.name.equals(another.name) && Objects.equals(this.plan, another.plan) && Objects.equals(this.service, another.service) && Objects.equals(this.startedAt, another.startedAt) && Objects.equals(this.status, another.status) && Objects.equals(this.tags, another.tags) && this.type.equals((Object)another.type) && Objects.equals(this.updatedAt, another.updatedAt);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.applications.hashCode();
        h = h * 17 + Objects.hashCode(this.dashboardUrl);
        h = h * 17 + Objects.hashCode(this.description);
        h = h * 17 + Objects.hashCode(this.documentationUrl);
        h = h * 17 + this.id.hashCode();
        h = h * 17 + Objects.hashCode(this.lastOperation);
        h = h * 17 + Objects.hashCode(this.message);
        h = h * 17 + this.name.hashCode();
        h = h * 17 + Objects.hashCode(this.plan);
        h = h * 17 + Objects.hashCode(this.service);
        h = h * 17 + Objects.hashCode(this.startedAt);
        h = h * 17 + Objects.hashCode(this.status);
        h = h * 17 + Objects.hashCode(this.tags);
        h = h * 17 + this.type.hashCode();
        h = h * 17 + Objects.hashCode(this.updatedAt);
        return h;
    }

    public String toString() {
        return "ServiceInstance{applications=" + this.applications + ", dashboardUrl=" + this.dashboardUrl + ", description=" + this.description + ", documentationUrl=" + this.documentationUrl + ", id=" + this.id + ", lastOperation=" + this.lastOperation + ", message=" + this.message + ", name=" + this.name + ", plan=" + this.plan + ", service=" + this.service + ", startedAt=" + this.startedAt + ", status=" + this.status + ", tags=" + this.tags + ", type=" + (Object)((Object)this.type) + ", updatedAt=" + this.updatedAt + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_NAME = 2L;
        private static final long INIT_BIT_TYPE = 4L;
        private long initBits = 7L;
        private List<String> applications = new ArrayList<String>();
        private String dashboardUrl;
        private String description;
        private String documentationUrl;
        private String id;
        private String lastOperation;
        private String message;
        private String name;
        private String plan;
        private String service;
        private String startedAt;
        private String status;
        private List<String> tags = null;
        private ServiceInstanceType type;
        private String updatedAt;

        private Builder() {
        }

        public final Builder from(ServiceInstance instance) {
            return this.from((_ServiceInstance)instance);
        }

        final Builder from(_ServiceInstance instance) {
            List<String> tagsValue;
            String statusValue;
            String startedAtValue;
            String serviceValue;
            String messageValue;
            String documentationUrlValue;
            String descriptionValue;
            Objects.requireNonNull(instance, "instance");
            this.addAllApplications(instance.getApplications());
            String dashboardUrlValue = instance.getDashboardUrl();
            if (dashboardUrlValue != null) {
                this.dashboardUrl(dashboardUrlValue);
            }
            if ((descriptionValue = instance.getDescription()) != null) {
                this.description(descriptionValue);
            }
            if ((documentationUrlValue = instance.getDocumentationUrl()) != null) {
                this.documentationUrl(documentationUrlValue);
            }
            this.id(instance.getId());
            String lastOperationValue = instance.getLastOperation();
            if (lastOperationValue != null) {
                this.lastOperation(lastOperationValue);
            }
            if ((messageValue = instance.getMessage()) != null) {
                this.message(messageValue);
            }
            this.name(instance.getName());
            String planValue = instance.getPlan();
            if (planValue != null) {
                this.plan(planValue);
            }
            if ((serviceValue = instance.getService()) != null) {
                this.service(serviceValue);
            }
            if ((startedAtValue = instance.getStartedAt()) != null) {
                this.startedAt(startedAtValue);
            }
            if ((statusValue = instance.getStatus()) != null) {
                this.status(statusValue);
            }
            if ((tagsValue = instance.getTags()) != null) {
                this.addAllTags(tagsValue);
            }
            this.type(instance.getType());
            String updatedAtValue = instance.getUpdatedAt();
            if (updatedAtValue != null) {
                this.updatedAt(updatedAtValue);
            }
            return this;
        }

        public final Builder application(String element) {
            this.applications.add(Objects.requireNonNull(element, "applications element"));
            return this;
        }

        public final Builder application(String ... elements) {
            for (String element : elements) {
                this.applications.add(Objects.requireNonNull(element, "applications element"));
            }
            return this;
        }

        public final Builder applications(Iterable<String> elements) {
            this.applications.clear();
            return this.addAllApplications(elements);
        }

        public final Builder addAllApplications(Iterable<String> elements) {
            for (String element : elements) {
                this.applications.add(Objects.requireNonNull(element, "applications element"));
            }
            return this;
        }

        public final Builder dashboardUrl(@Nullable String dashboardUrl) {
            this.dashboardUrl = dashboardUrl;
            return this;
        }

        public final Builder description(@Nullable String description) {
            this.description = description;
            return this;
        }

        public final Builder documentationUrl(@Nullable String documentationUrl) {
            this.documentationUrl = documentationUrl;
            return this;
        }

        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder lastOperation(@Nullable String lastOperation) {
            this.lastOperation = lastOperation;
            return this;
        }

        public final Builder message(@Nullable String message) {
            this.message = message;
            return this;
        }

        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder plan(@Nullable String plan) {
            this.plan = plan;
            return this;
        }

        public final Builder service(@Nullable String service) {
            this.service = service;
            return this;
        }

        public final Builder startedAt(@Nullable String startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final Builder status(@Nullable String status) {
            this.status = status;
            return this;
        }

        public final Builder tag(String element) {
            if (this.tags == null) {
                this.tags = new ArrayList<String>();
            }
            this.tags.add(Objects.requireNonNull(element, "tags element"));
            return this;
        }

        public final Builder tag(String ... elements) {
            if (this.tags == null) {
                this.tags = new ArrayList<String>();
            }
            for (String element : elements) {
                this.tags.add(Objects.requireNonNull(element, "tags element"));
            }
            return this;
        }

        public final Builder tags(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.tags = null;
                return this;
            }
            this.tags = new ArrayList<String>();
            return this.addAllTags(elements);
        }

        public final Builder addAllTags(Iterable<String> elements) {
            Objects.requireNonNull(elements, "tags element");
            if (this.tags == null) {
                this.tags = new ArrayList<String>();
            }
            for (String element : elements) {
                this.tags.add(Objects.requireNonNull(element, "tags element"));
            }
            return this;
        }

        public final Builder type(ServiceInstanceType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder updatedAt(@Nullable String updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public ServiceInstance build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ServiceInstance(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("type");
            }
            return "Cannot build ServiceInstance, some of required attributes are not set " + attributes;
        }
    }
}

