/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.operations.services;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.operations.services._UnbindServiceInstanceRequest;

public final class UnbindServiceInstanceRequest
extends _UnbindServiceInstanceRequest {
    private final String applicationName;
    private final String serviceInstanceName;

    private UnbindServiceInstanceRequest(Builder builder) {
        this.applicationName = builder.applicationName;
        this.serviceInstanceName = builder.serviceInstanceName;
    }

    @Override
    public String getApplicationName() {
        return this.applicationName;
    }

    @Override
    public String getServiceInstanceName() {
        return this.serviceInstanceName;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof UnbindServiceInstanceRequest && this.equalTo((UnbindServiceInstanceRequest)another);
    }

    private boolean equalTo(UnbindServiceInstanceRequest another) {
        return this.applicationName.equals(another.applicationName) && this.serviceInstanceName.equals(another.serviceInstanceName);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.applicationName.hashCode();
        h = h * 17 + this.serviceInstanceName.hashCode();
        return h;
    }

    public String toString() {
        return "UnbindServiceInstanceRequest{applicationName=" + this.applicationName + ", serviceInstanceName=" + this.serviceInstanceName + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_APPLICATION_NAME = 1L;
        private static final long INIT_BIT_SERVICE_INSTANCE_NAME = 2L;
        private long initBits = 3L;
        private String applicationName;
        private String serviceInstanceName;

        private Builder() {
        }

        public final Builder from(UnbindServiceInstanceRequest instance) {
            return this.from((_UnbindServiceInstanceRequest)instance);
        }

        final Builder from(_UnbindServiceInstanceRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.applicationName(instance.getApplicationName());
            this.serviceInstanceName(instance.getServiceInstanceName());
            return this;
        }

        public final Builder applicationName(String applicationName) {
            this.applicationName = Objects.requireNonNull(applicationName, "applicationName");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder serviceInstanceName(String serviceInstanceName) {
            this.serviceInstanceName = Objects.requireNonNull(serviceInstanceName, "serviceInstanceName");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public UnbindServiceInstanceRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new UnbindServiceInstanceRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("applicationName");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("serviceInstanceName");
            }
            return "Cannot build UnbindServiceInstanceRequest, some of required attributes are not set " + attributes;
        }
    }
}

