package org.cloudfoundry.operations.services;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * Immutable implementation of {@link _BindServiceInstanceRequest}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code BindServiceInstanceRequest.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_BindServiceInstanceRequest"})
public final class BindServiceInstanceRequest
    extends org.cloudfoundry.operations.services._BindServiceInstanceRequest {
  private final String applicationName;
  private final @Nullable Map<String, Object> parameters;
  private final String serviceInstanceName;

  private BindServiceInstanceRequest(BindServiceInstanceRequest.Builder builder) {
    this.applicationName = builder.applicationName;
    this.parameters = builder.parameters == null ? null : createUnmodifiableMap(false, false, builder.parameters);
    this.serviceInstanceName = builder.serviceInstanceName;
  }

  /**
   * The name of the application to bind
   */
  @Override
  public String getApplicationName() {
    return applicationName;
  }

  /**
   * The parameters for the service binding
   */
  @Override
  public @Nullable Map<String, Object> getParameters() {
    return parameters;
  }

  /**
   * The name of the service instance to bind
   */
  @Override
  public String getServiceInstanceName() {
    return serviceInstanceName;
  }

  /**
   * This instance is equal to all instances of {@code BindServiceInstanceRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof BindServiceInstanceRequest
        && equalTo((BindServiceInstanceRequest) another);
  }

  private boolean equalTo(BindServiceInstanceRequest another) {
    return applicationName.equals(another.applicationName)
        && Objects.equals(parameters, another.parameters)
        && serviceInstanceName.equals(another.serviceInstanceName);
  }

  /**
   * Computes a hash code from attributes: {@code applicationName}, {@code parameters}, {@code serviceInstanceName}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + applicationName.hashCode();
    h = h * 17 + Objects.hashCode(parameters);
    h = h * 17 + serviceInstanceName.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code BindServiceInstanceRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "BindServiceInstanceRequest{"
        + "applicationName=" + applicationName
        + ", parameters=" + parameters
        + ", serviceInstanceName=" + serviceInstanceName
        + "}";
  }

  /**
   * Creates a builder for {@link BindServiceInstanceRequest BindServiceInstanceRequest}.
   * @return A new BindServiceInstanceRequest builder
   */
  public static BindServiceInstanceRequest.Builder builder() {
    return new BindServiceInstanceRequest.Builder();
  }

  /**
   * Builds instances of type {@link BindServiceInstanceRequest BindServiceInstanceRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_APPLICATION_NAME = 0x1L;
    private static final long INIT_BIT_SERVICE_INSTANCE_NAME = 0x2L;
    private long initBits = 0x3L;

    private String applicationName;
    private Map<String, Object> parameters = null;
    private String serviceInstanceName;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code BindServiceInstanceRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(BindServiceInstanceRequest instance) {
      return from((_BindServiceInstanceRequest) instance);
    }

    /**
     * Copy abstract value type {@code _BindServiceInstanceRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_BindServiceInstanceRequest instance) {
      Objects.requireNonNull(instance, "instance");
      applicationName(instance.getApplicationName());
      Map<String, Object> parametersValue = instance.getParameters();
      if (parametersValue != null) {
        putAllParameters(parametersValue);
      }
      serviceInstanceName(instance.getServiceInstanceName());
      return this;
    }

    /**
     * Initializes the value for the {@link _BindServiceInstanceRequest#getApplicationName() applicationName} attribute.
     * @param applicationName The value for applicationName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationName(String applicationName) {
      this.applicationName = Objects.requireNonNull(applicationName, "applicationName");
      initBits &= ~INIT_BIT_APPLICATION_NAME;
      return this;
    }

    /**
     * Put one entry to the {@link _BindServiceInstanceRequest#getParameters() parameters} map.
     * @param key The key in the parameters map
     * @param value The associated value in the parameters map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder parameter(String key, Object value) {
      if (this.parameters == null) {
        this.parameters = new LinkedHashMap<String, Object>();
      }
      this.parameters.put(
          Objects.requireNonNull(key, "parameters key"),
          Objects.requireNonNull(value, "parameters value"));
      return this;
    }

    /**
     * Put one entry to the {@link _BindServiceInstanceRequest#getParameters() parameters} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder parameter(Map.Entry<String, ? extends Object> entry) {
      if (this.parameters == null) {
        this.parameters = new LinkedHashMap<String, Object>();
      }
      String k = entry.getKey();
      Object v = entry.getValue();
      this.parameters.put(
          Objects.requireNonNull(k, "parameters key"),
          Objects.requireNonNull(v, "parameters value"));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link _BindServiceInstanceRequest#getParameters() parameters} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param parameters The entries that will be added to the parameters map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder parameters(@Nullable Map<String, ? extends Object> parameters) {
      if (parameters == null) {
        this.parameters = null;
        return this;
      }
      this.parameters = new LinkedHashMap<String, Object>();
      return putAllParameters(parameters);
    }

    /**
     * Put all mappings from the specified map as entries to {@link _BindServiceInstanceRequest#getParameters() parameters} map. Nulls are not permitted
     * @param parameters The entries that will be added to the parameters map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllParameters(Map<String, ? extends Object> parameters) {
      if (this.parameters == null) {
        this.parameters = new LinkedHashMap<String, Object>();
      }
      for (Map.Entry<String, ? extends Object> entry : parameters.entrySet()) {
        String k = entry.getKey();
        Object v = entry.getValue();
        this.parameters.put(
            Objects.requireNonNull(k, "parameters key"),
            Objects.requireNonNull(v, "parameters value"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _BindServiceInstanceRequest#getServiceInstanceName() serviceInstanceName} attribute.
     * @param serviceInstanceName The value for serviceInstanceName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceInstanceName(String serviceInstanceName) {
      this.serviceInstanceName = Objects.requireNonNull(serviceInstanceName, "serviceInstanceName");
      initBits &= ~INIT_BIT_SERVICE_INSTANCE_NAME;
      return this;
    }

    /**
     * Builds a new {@link BindServiceInstanceRequest BindServiceInstanceRequest}.
     * @return An immutable instance of BindServiceInstanceRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public BindServiceInstanceRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new BindServiceInstanceRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_APPLICATION_NAME) != 0) attributes.add("applicationName");
      if ((initBits & INIT_BIT_SERVICE_INSTANCE_NAME) != 0) attributes.add("serviceInstanceName");
      return "Cannot build BindServiceInstanceRequest, some of required attributes are not set " + attributes;
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
