package org.cloudfoundry.operations.applications;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link _ApplicationEnvironments}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ApplicationEnvironments.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_ApplicationEnvironments"})
public final class ApplicationEnvironments
    extends org.cloudfoundry.operations.applications._ApplicationEnvironments {
  private final Map<String, Object> running;
  private final Map<String, Object> staging;
  private final Map<String, Object> systemProvided;
  private final Map<String, Object> userProvided;

  private ApplicationEnvironments(ApplicationEnvironments.Builder builder) {
    this.running = createUnmodifiableMap(false, false, builder.running);
    this.staging = createUnmodifiableMap(false, false, builder.staging);
    this.systemProvided = createUnmodifiableMap(false, false, builder.systemProvided);
    this.userProvided = createUnmodifiableMap(false, false, builder.userProvided);
  }

  /**
   * The running environment variables
   */
  @Override
  public Map<String, Object> getRunning() {
    return running;
  }

  /**
   * The staging environment variables
   */
  @Override
  public Map<String, Object> getStaging() {
    return staging;
  }

  /**
   * The system provided environment variables
   */
  @Override
  public Map<String, Object> getSystemProvided() {
    return systemProvided;
  }

  /**
   * The user defined environment variables
   */
  @Override
  public Map<String, Object> getUserProvided() {
    return userProvided;
  }

  /**
   * This instance is equal to all instances of {@code ApplicationEnvironments} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ApplicationEnvironments
        && equalTo((ApplicationEnvironments) another);
  }

  private boolean equalTo(ApplicationEnvironments another) {
    return running.equals(another.running)
        && staging.equals(another.staging)
        && systemProvided.equals(another.systemProvided)
        && userProvided.equals(another.userProvided);
  }

  /**
   * Computes a hash code from attributes: {@code running}, {@code staging}, {@code systemProvided}, {@code userProvided}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + running.hashCode();
    h = h * 17 + staging.hashCode();
    h = h * 17 + systemProvided.hashCode();
    h = h * 17 + userProvided.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ApplicationEnvironments} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ApplicationEnvironments{"
        + "running=" + running
        + ", staging=" + staging
        + ", systemProvided=" + systemProvided
        + ", userProvided=" + userProvided
        + "}";
  }

  /**
   * Creates a builder for {@link ApplicationEnvironments ApplicationEnvironments}.
   * @return A new ApplicationEnvironments builder
   */
  public static ApplicationEnvironments.Builder builder() {
    return new ApplicationEnvironments.Builder();
  }

  /**
   * Builds instances of type {@link ApplicationEnvironments ApplicationEnvironments}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private Map<String, Object> running = new LinkedHashMap<String, Object>();
    private Map<String, Object> staging = new LinkedHashMap<String, Object>();
    private Map<String, Object> systemProvided = new LinkedHashMap<String, Object>();
    private Map<String, Object> userProvided = new LinkedHashMap<String, Object>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ApplicationEnvironments} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ApplicationEnvironments instance) {
      return from((_ApplicationEnvironments) instance);
    }

    /**
     * Copy abstract value type {@code _ApplicationEnvironments} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ApplicationEnvironments instance) {
      Objects.requireNonNull(instance, "instance");
      putAllRunning(instance.getRunning());
      putAllStaging(instance.getStaging());
      putAllSystemProvided(instance.getSystemProvided());
      putAllUserProvided(instance.getUserProvided());
      return this;
    }

    /**
     * Put one entry to the {@link _ApplicationEnvironments#getRunning() running} map.
     * @param key The key in the running map
     * @param value The associated value in the running map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder running(String key, Object value) {
      this.running.put(
          Objects.requireNonNull(key, "running key"),
          Objects.requireNonNull(value, "running value"));
      return this;
    }

    /**
     * Put one entry to the {@link _ApplicationEnvironments#getRunning() running} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder running(Map.Entry<String, ? extends Object> entry) {
      String k = entry.getKey();
      Object v = entry.getValue();
      this.running.put(
          Objects.requireNonNull(k, "running key"),
          Objects.requireNonNull(v, "running value"));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link _ApplicationEnvironments#getRunning() running} map. Nulls are not permitted
     * @param running The entries that will be added to the running map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder running(Map<String, ? extends Object> running) {
      this.running.clear();
      return putAllRunning(running);
    }

    /**
     * Put all mappings from the specified map as entries to {@link _ApplicationEnvironments#getRunning() running} map. Nulls are not permitted
     * @param running The entries that will be added to the running map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllRunning(Map<String, ? extends Object> running) {
      for (Map.Entry<String, ? extends Object> entry : running.entrySet()) {
        String k = entry.getKey();
        Object v = entry.getValue();
        this.running.put(
            Objects.requireNonNull(k, "running key"),
            Objects.requireNonNull(v, "running value"));
      }
      return this;
    }

    /**
     * Put one entry to the {@link _ApplicationEnvironments#getStaging() staging} map.
     * @param key The key in the staging map
     * @param value The associated value in the staging map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder staging(String key, Object value) {
      this.staging.put(
          Objects.requireNonNull(key, "staging key"),
          Objects.requireNonNull(value, "staging value"));
      return this;
    }

    /**
     * Put one entry to the {@link _ApplicationEnvironments#getStaging() staging} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder staging(Map.Entry<String, ? extends Object> entry) {
      String k = entry.getKey();
      Object v = entry.getValue();
      this.staging.put(
          Objects.requireNonNull(k, "staging key"),
          Objects.requireNonNull(v, "staging value"));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link _ApplicationEnvironments#getStaging() staging} map. Nulls are not permitted
     * @param staging The entries that will be added to the staging map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder staging(Map<String, ? extends Object> staging) {
      this.staging.clear();
      return putAllStaging(staging);
    }

    /**
     * Put all mappings from the specified map as entries to {@link _ApplicationEnvironments#getStaging() staging} map. Nulls are not permitted
     * @param staging The entries that will be added to the staging map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllStaging(Map<String, ? extends Object> staging) {
      for (Map.Entry<String, ? extends Object> entry : staging.entrySet()) {
        String k = entry.getKey();
        Object v = entry.getValue();
        this.staging.put(
            Objects.requireNonNull(k, "staging key"),
            Objects.requireNonNull(v, "staging value"));
      }
      return this;
    }

    /**
     * Put one entry to the {@link _ApplicationEnvironments#getSystemProvided() systemProvided} map.
     * @param key The key in the systemProvided map
     * @param value The associated value in the systemProvided map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder systemProvided(String key, Object value) {
      this.systemProvided.put(
          Objects.requireNonNull(key, "systemProvided key"),
          Objects.requireNonNull(value, "systemProvided value"));
      return this;
    }

    /**
     * Put one entry to the {@link _ApplicationEnvironments#getSystemProvided() systemProvided} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder systemProvided(Map.Entry<String, ? extends Object> entry) {
      String k = entry.getKey();
      Object v = entry.getValue();
      this.systemProvided.put(
          Objects.requireNonNull(k, "systemProvided key"),
          Objects.requireNonNull(v, "systemProvided value"));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link _ApplicationEnvironments#getSystemProvided() systemProvided} map. Nulls are not permitted
     * @param systemProvided The entries that will be added to the systemProvided map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder systemProvided(Map<String, ? extends Object> systemProvided) {
      this.systemProvided.clear();
      return putAllSystemProvided(systemProvided);
    }

    /**
     * Put all mappings from the specified map as entries to {@link _ApplicationEnvironments#getSystemProvided() systemProvided} map. Nulls are not permitted
     * @param systemProvided The entries that will be added to the systemProvided map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllSystemProvided(Map<String, ? extends Object> systemProvided) {
      for (Map.Entry<String, ? extends Object> entry : systemProvided.entrySet()) {
        String k = entry.getKey();
        Object v = entry.getValue();
        this.systemProvided.put(
            Objects.requireNonNull(k, "systemProvided key"),
            Objects.requireNonNull(v, "systemProvided value"));
      }
      return this;
    }

    /**
     * Put one entry to the {@link _ApplicationEnvironments#getUserProvided() userProvided} map.
     * @param key The key in the userProvided map
     * @param value The associated value in the userProvided map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder userProvided(String key, Object value) {
      this.userProvided.put(
          Objects.requireNonNull(key, "userProvided key"),
          Objects.requireNonNull(value, "userProvided value"));
      return this;
    }

    /**
     * Put one entry to the {@link _ApplicationEnvironments#getUserProvided() userProvided} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder userProvided(Map.Entry<String, ? extends Object> entry) {
      String k = entry.getKey();
      Object v = entry.getValue();
      this.userProvided.put(
          Objects.requireNonNull(k, "userProvided key"),
          Objects.requireNonNull(v, "userProvided value"));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link _ApplicationEnvironments#getUserProvided() userProvided} map. Nulls are not permitted
     * @param userProvided The entries that will be added to the userProvided map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder userProvided(Map<String, ? extends Object> userProvided) {
      this.userProvided.clear();
      return putAllUserProvided(userProvided);
    }

    /**
     * Put all mappings from the specified map as entries to {@link _ApplicationEnvironments#getUserProvided() userProvided} map. Nulls are not permitted
     * @param userProvided The entries that will be added to the userProvided map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllUserProvided(Map<String, ? extends Object> userProvided) {
      for (Map.Entry<String, ? extends Object> entry : userProvided.entrySet()) {
        String k = entry.getKey();
        Object v = entry.getValue();
        this.userProvided.put(
            Objects.requireNonNull(k, "userProvided key"),
            Objects.requireNonNull(v, "userProvided value"));
      }
      return this;
    }

    /**
     * Builds a new {@link ApplicationEnvironments ApplicationEnvironments}.
     * @return An immutable instance of ApplicationEnvironments
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ApplicationEnvironments build() {
      return new ApplicationEnvironments(this);
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
