package org.cloudfoundry.operations.applications;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * Immutable implementation of {@link _ApplicationEvent}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ApplicationEvent.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_ApplicationEvent"})
public final class ApplicationEvent extends org.cloudfoundry.operations.applications._ApplicationEvent {
  private final String actor;
  private final String description;
  private final String event;
  private final String id;
  private final @Nullable Date time;

  private ApplicationEvent(ApplicationEvent.Builder builder) {
    this.actor = builder.actor;
    this.description = builder.description;
    this.event = builder.event;
    this.id = builder.id;
    this.time = builder.time;
  }

  /**
   * The actor
   */
  @Override
  public String getActor() {
    return actor;
  }

  /**
   * The description
   */
  @Override
  public String getDescription() {
    return description;
  }

  /**
   * The event
   */
  @Override
  public String getEvent() {
    return event;
  }

  /**
   * The id
   */
  @Override
  public String getId() {
    return id;
  }

  /**
   * The time
   */
  @Override
  public @Nullable Date getTime() {
    return time;
  }

  /**
   * This instance is equal to all instances of {@code ApplicationEvent} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ApplicationEvent
        && equalTo((ApplicationEvent) another);
  }

  private boolean equalTo(ApplicationEvent another) {
    return actor.equals(another.actor)
        && description.equals(another.description)
        && event.equals(another.event)
        && id.equals(another.id)
        && Objects.equals(time, another.time);
  }

  /**
   * Computes a hash code from attributes: {@code actor}, {@code description}, {@code event}, {@code id}, {@code time}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + actor.hashCode();
    h = h * 17 + description.hashCode();
    h = h * 17 + event.hashCode();
    h = h * 17 + id.hashCode();
    h = h * 17 + Objects.hashCode(time);
    return h;
  }

  /**
   * Prints the immutable value {@code ApplicationEvent} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ApplicationEvent{"
        + "actor=" + actor
        + ", description=" + description
        + ", event=" + event
        + ", id=" + id
        + ", time=" + time
        + "}";
  }

  /**
   * Creates a builder for {@link ApplicationEvent ApplicationEvent}.
   * @return A new ApplicationEvent builder
   */
  public static ApplicationEvent.Builder builder() {
    return new ApplicationEvent.Builder();
  }

  /**
   * Builds instances of type {@link ApplicationEvent ApplicationEvent}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_ACTOR = 0x1L;
    private static final long INIT_BIT_DESCRIPTION = 0x2L;
    private static final long INIT_BIT_EVENT = 0x4L;
    private static final long INIT_BIT_ID = 0x8L;
    private long initBits = 0xfL;

    private String actor;
    private String description;
    private String event;
    private String id;
    private Date time;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ApplicationEvent} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ApplicationEvent instance) {
      return from((_ApplicationEvent) instance);
    }

    /**
     * Copy abstract value type {@code _ApplicationEvent} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ApplicationEvent instance) {
      Objects.requireNonNull(instance, "instance");
      actor(instance.getActor());
      description(instance.getDescription());
      event(instance.getEvent());
      id(instance.getId());
      Date timeValue = instance.getTime();
      if (timeValue != null) {
        time(timeValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _ApplicationEvent#getActor() actor} attribute.
     * @param actor The value for actor 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder actor(String actor) {
      this.actor = Objects.requireNonNull(actor, "actor");
      initBits &= ~INIT_BIT_ACTOR;
      return this;
    }

    /**
     * Initializes the value for the {@link _ApplicationEvent#getDescription() description} attribute.
     * @param description The value for description 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder description(String description) {
      this.description = Objects.requireNonNull(description, "description");
      initBits &= ~INIT_BIT_DESCRIPTION;
      return this;
    }

    /**
     * Initializes the value for the {@link _ApplicationEvent#getEvent() event} attribute.
     * @param event The value for event 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder event(String event) {
      this.event = Objects.requireNonNull(event, "event");
      initBits &= ~INIT_BIT_EVENT;
      return this;
    }

    /**
     * Initializes the value for the {@link _ApplicationEvent#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link _ApplicationEvent#getTime() time} attribute.
     * @param time The value for time (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder time(@Nullable Date time) {
      this.time = time;
      return this;
    }

    /**
     * Builds a new {@link ApplicationEvent ApplicationEvent}.
     * @return An immutable instance of ApplicationEvent
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ApplicationEvent build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ApplicationEvent(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_ACTOR) != 0) attributes.add("actor");
      if ((initBits & INIT_BIT_DESCRIPTION) != 0) attributes.add("description");
      if ((initBits & INIT_BIT_EVENT) != 0) attributes.add("event");
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      return "Cannot build ApplicationEvent, some of required attributes are not set " + attributes;
    }
  }
}
