package org.cloudfoundry.operations.organizations;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * Immutable implementation of {@link _CreateOrganizationRequest}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code CreateOrganizationRequest.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_CreateOrganizationRequest"})
public final class CreateOrganizationRequest
    extends org.cloudfoundry.operations.organizations._CreateOrganizationRequest {
  private final String organizationName;
  private final @Nullable String quotaDefinitionName;

  private CreateOrganizationRequest(CreateOrganizationRequest.Builder builder) {
    this.organizationName = builder.organizationName;
    this.quotaDefinitionName = builder.quotaDefinitionName;
  }

  /**
   * The organization name
   */
  @Override
  public String getOrganizationName() {
    return organizationName;
  }

  /**
   * The quota definition name
   */
  @Override
  public @Nullable String getQuotaDefinitionName() {
    return quotaDefinitionName;
  }

  /**
   * This instance is equal to all instances of {@code CreateOrganizationRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof CreateOrganizationRequest
        && equalTo((CreateOrganizationRequest) another);
  }

  private boolean equalTo(CreateOrganizationRequest another) {
    return organizationName.equals(another.organizationName)
        && Objects.equals(quotaDefinitionName, another.quotaDefinitionName);
  }

  /**
   * Computes a hash code from attributes: {@code organizationName}, {@code quotaDefinitionName}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + organizationName.hashCode();
    h = h * 17 + Objects.hashCode(quotaDefinitionName);
    return h;
  }

  /**
   * Prints the immutable value {@code CreateOrganizationRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CreateOrganizationRequest{"
        + "organizationName=" + organizationName
        + ", quotaDefinitionName=" + quotaDefinitionName
        + "}";
  }

  /**
   * Creates a builder for {@link CreateOrganizationRequest CreateOrganizationRequest}.
   * @return A new CreateOrganizationRequest builder
   */
  public static CreateOrganizationRequest.Builder builder() {
    return new CreateOrganizationRequest.Builder();
  }

  /**
   * Builds instances of type {@link CreateOrganizationRequest CreateOrganizationRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_ORGANIZATION_NAME = 0x1L;
    private long initBits = 0x1L;

    private String organizationName;
    private String quotaDefinitionName;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CreateOrganizationRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CreateOrganizationRequest instance) {
      return from((_CreateOrganizationRequest) instance);
    }

    /**
     * Copy abstract value type {@code _CreateOrganizationRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_CreateOrganizationRequest instance) {
      Objects.requireNonNull(instance, "instance");
      organizationName(instance.getOrganizationName());
      String quotaDefinitionNameValue = instance.getQuotaDefinitionName();
      if (quotaDefinitionNameValue != null) {
        quotaDefinitionName(quotaDefinitionNameValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateOrganizationRequest#getOrganizationName() organizationName} attribute.
     * @param organizationName The value for organizationName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationName(String organizationName) {
      this.organizationName = Objects.requireNonNull(organizationName, "organizationName");
      initBits &= ~INIT_BIT_ORGANIZATION_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateOrganizationRequest#getQuotaDefinitionName() quotaDefinitionName} attribute.
     * @param quotaDefinitionName The value for quotaDefinitionName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder quotaDefinitionName(@Nullable String quotaDefinitionName) {
      this.quotaDefinitionName = quotaDefinitionName;
      return this;
    }

    /**
     * Builds a new {@link CreateOrganizationRequest CreateOrganizationRequest}.
     * @return An immutable instance of CreateOrganizationRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public CreateOrganizationRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new CreateOrganizationRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_ORGANIZATION_NAME) != 0) attributes.add("organizationName");
      return "Cannot build CreateOrganizationRequest, some of required attributes are not set " + attributes;
    }
  }
}
