/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.operations.serviceadmin;

import java.util.NoSuchElementException;
import java.util.Optional;
import org.cloudfoundry.client.CloudFoundryClient;
import org.cloudfoundry.client.v2.Resource;
import org.cloudfoundry.client.v2.servicebrokers.CreateServiceBrokerResponse;
import org.cloudfoundry.client.v2.servicebrokers.ListServiceBrokersRequest;
import org.cloudfoundry.client.v2.servicebrokers.ServiceBrokerEntity;
import org.cloudfoundry.client.v2.servicebrokers.ServiceBrokerResource;
import org.cloudfoundry.operations.serviceadmin.CreateServiceBrokerRequest;
import org.cloudfoundry.operations.serviceadmin.DeleteServiceBrokerRequest;
import org.cloudfoundry.operations.serviceadmin.ServiceAdmin;
import org.cloudfoundry.operations.serviceadmin.ServiceBroker;
import org.cloudfoundry.operations.util.OperationsLogging;
import org.cloudfoundry.util.ExceptionUtils;
import org.cloudfoundry.util.PaginationUtils;
import org.cloudfoundry.util.ResourceUtils;
import org.cloudfoundry.util.tuple.TupleUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class DefaultServiceAdmin
implements ServiceAdmin {
    private final Mono<CloudFoundryClient> cloudFoundryClient;
    private final Mono<String> spaceId;

    public DefaultServiceAdmin(Mono<CloudFoundryClient> cloudFoundryClient, Mono<String> spaceId) {
        this.cloudFoundryClient = cloudFoundryClient;
        this.spaceId = spaceId;
    }

    @Override
    public Mono<Void> create(CreateServiceBrokerRequest request) {
        return Mono.when(this.cloudFoundryClient, this.spaceId).then(TupleUtils.function((cloudFoundryClient, spaceId) -> DefaultServiceAdmin.requestCreateServiceBroker(cloudFoundryClient, request.getName(), request.getUrl(), request.getUsername(), request.getPassword(), request.getSpaceScoped(), spaceId))).then().transform(OperationsLogging.log("Create Service Broker")).checkpoint();
    }

    @Override
    public Mono<Void> delete(DeleteServiceBrokerRequest request) {
        return this.cloudFoundryClient.then(cloudFoundryClient -> Mono.when((Mono)Mono.just((Object)cloudFoundryClient), DefaultServiceAdmin.getServiceBrokerId(cloudFoundryClient, request.getName()))).then(TupleUtils.function(DefaultServiceAdmin::requestDeleteServiceBroker)).transform(OperationsLogging.log("Delete Service Broker")).checkpoint();
    }

    @Override
    public Flux<ServiceBroker> list() {
        return this.cloudFoundryClient.flatMapMany(DefaultServiceAdmin::requestServiceBrokers).map(this::toServiceBroker).transform(OperationsLogging.log("List Service Brokers")).checkpoint();
    }

    private static Mono<ServiceBrokerResource> getServiceBroker(CloudFoundryClient cloudFoundryClient, String serviceBrokerName) {
        return DefaultServiceAdmin.requestListServiceBrokers(cloudFoundryClient, serviceBrokerName).single().onErrorResume(NoSuchElementException.class, t -> ExceptionUtils.illegalArgument((String)"Service Broker %s does not exist", (Object[])new Object[]{serviceBrokerName}));
    }

    private static Mono<String> getServiceBrokerId(CloudFoundryClient cloudFoundryClient, String serviceBrokerName) {
        return DefaultServiceAdmin.getServiceBroker(cloudFoundryClient, serviceBrokerName).map(ResourceUtils::getId);
    }

    private static Mono<CreateServiceBrokerResponse> requestCreateServiceBroker(CloudFoundryClient cloudFoundryClient, String name, String url, String username, String password, Boolean isSpaceScoped, String spaceId) {
        return cloudFoundryClient.serviceBrokers().create(org.cloudfoundry.client.v2.servicebrokers.CreateServiceBrokerRequest.builder().name(name).brokerUrl(url).authenticationUsername(username).authenticationPassword(password).spaceId(Optional.ofNullable(isSpaceScoped).orElse(false) != false ? spaceId : null).build());
    }

    private static Mono<Void> requestDeleteServiceBroker(CloudFoundryClient cloudFoundryClient, String serviceBrokerId) {
        return cloudFoundryClient.serviceBrokers().delete(org.cloudfoundry.client.v2.servicebrokers.DeleteServiceBrokerRequest.builder().serviceBrokerId(serviceBrokerId).build());
    }

    private static Flux<ServiceBrokerResource> requestListServiceBrokers(CloudFoundryClient cloudFoundryClient, String serviceBrokerName) {
        return PaginationUtils.requestClientV2Resources(page -> cloudFoundryClient.serviceBrokers().list(ListServiceBrokersRequest.builder().name(serviceBrokerName).page(page).build()));
    }

    private static Flux<ServiceBrokerResource> requestServiceBrokers(CloudFoundryClient cloudFoundryClient) {
        return PaginationUtils.requestClientV2Resources(page -> cloudFoundryClient.serviceBrokers().list(ListServiceBrokersRequest.builder().page(page).build()));
    }

    private ServiceBroker toServiceBroker(ServiceBrokerResource resource) {
        ServiceBrokerEntity entity = (ServiceBrokerEntity)ResourceUtils.getEntity((Resource)resource);
        return ServiceBroker.builder().id(ResourceUtils.getId((Resource)resource)).name(entity.getName()).url(entity.getBrokerUrl()).build();
    }
}

