/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.operations.serviceadmin;

import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.cloudfoundry.client.CloudFoundryClient;
import org.cloudfoundry.client.v2.Resource;
import org.cloudfoundry.client.v2.organizations.GetOrganizationRequest;
import org.cloudfoundry.client.v2.organizations.GetOrganizationResponse;
import org.cloudfoundry.client.v2.organizations.ListOrganizationsRequest;
import org.cloudfoundry.client.v2.organizations.OrganizationEntity;
import org.cloudfoundry.client.v2.organizations.OrganizationResource;
import org.cloudfoundry.client.v2.servicebrokers.CreateServiceBrokerResponse;
import org.cloudfoundry.client.v2.servicebrokers.ListServiceBrokersRequest;
import org.cloudfoundry.client.v2.servicebrokers.ServiceBrokerEntity;
import org.cloudfoundry.client.v2.servicebrokers.ServiceBrokerResource;
import org.cloudfoundry.client.v2.serviceplans.ListServicePlansRequest;
import org.cloudfoundry.client.v2.serviceplans.ServicePlanEntity;
import org.cloudfoundry.client.v2.serviceplans.ServicePlanResource;
import org.cloudfoundry.client.v2.serviceplans.UpdateServicePlanRequest;
import org.cloudfoundry.client.v2.serviceplans.UpdateServicePlanResponse;
import org.cloudfoundry.client.v2.serviceplanvisibilities.CreateServicePlanVisibilityRequest;
import org.cloudfoundry.client.v2.serviceplanvisibilities.CreateServicePlanVisibilityResponse;
import org.cloudfoundry.client.v2.serviceplanvisibilities.DeleteServicePlanVisibilityRequest;
import org.cloudfoundry.client.v2.serviceplanvisibilities.DeleteServicePlanVisibilityResponse;
import org.cloudfoundry.client.v2.serviceplanvisibilities.ListServicePlanVisibilitiesRequest;
import org.cloudfoundry.client.v2.serviceplanvisibilities.ServicePlanVisibilityResource;
import org.cloudfoundry.client.v2.services.ListServicesRequest;
import org.cloudfoundry.client.v2.services.ServiceEntity;
import org.cloudfoundry.client.v2.services.ServiceResource;
import org.cloudfoundry.operations.serviceadmin.Access;
import org.cloudfoundry.operations.serviceadmin.CreateServiceBrokerRequest;
import org.cloudfoundry.operations.serviceadmin.DeleteServiceBrokerRequest;
import org.cloudfoundry.operations.serviceadmin.DisableServiceAccessRequest;
import org.cloudfoundry.operations.serviceadmin.EnableServiceAccessRequest;
import org.cloudfoundry.operations.serviceadmin.ListServiceAccessSettingsRequest;
import org.cloudfoundry.operations.serviceadmin.ServiceAccess;
import org.cloudfoundry.operations.serviceadmin.ServiceAdmin;
import org.cloudfoundry.operations.serviceadmin.ServiceBroker;
import org.cloudfoundry.operations.util.OperationsLogging;
import org.cloudfoundry.util.ExceptionUtils;
import org.cloudfoundry.util.JobUtils;
import org.cloudfoundry.util.PaginationUtils;
import org.cloudfoundry.util.ResourceUtils;
import org.cloudfoundry.util.tuple.TupleUtils;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuples;

public final class DefaultServiceAdmin
implements ServiceAdmin {
    private final Mono<CloudFoundryClient> cloudFoundryClient;
    private final Mono<String> spaceId;

    public DefaultServiceAdmin(Mono<CloudFoundryClient> cloudFoundryClient, Mono<String> spaceId) {
        this.cloudFoundryClient = cloudFoundryClient;
        this.spaceId = spaceId;
    }

    @Override
    public Mono<Void> create(CreateServiceBrokerRequest request) {
        return Mono.when(this.cloudFoundryClient, this.spaceId).then(TupleUtils.function((cloudFoundryClient, spaceId) -> DefaultServiceAdmin.requestCreateServiceBroker(cloudFoundryClient, request.getName(), request.getUrl(), request.getUsername(), request.getPassword(), request.getSpaceScoped(), spaceId))).then().transform(OperationsLogging.log("Create Service Broker")).checkpoint();
    }

    @Override
    public Mono<Void> delete(DeleteServiceBrokerRequest request) {
        return this.cloudFoundryClient.then(cloudFoundryClient -> Mono.when((Mono)Mono.just((Object)cloudFoundryClient), DefaultServiceAdmin.getServiceBrokerId(cloudFoundryClient, request.getName()))).then(TupleUtils.function(DefaultServiceAdmin::requestDeleteServiceBroker)).transform(OperationsLogging.log("Delete Service Broker")).checkpoint();
    }

    @Override
    public Mono<Void> disableServiceAccess(DisableServiceAccessRequest request) {
        return this.cloudFoundryClient.then(cloudFoundryClient -> Mono.when((Mono)Mono.just((Object)cloudFoundryClient), DefaultServiceAdmin.getServiceId(cloudFoundryClient, request.getServiceName()))).then(TupleUtils.function((cloudFoundryClient, serviceId) -> Mono.when((Mono)Mono.just((Object)cloudFoundryClient), DefaultServiceAdmin.getServicePlans(cloudFoundryClient, serviceId)))).then(TupleUtils.function((cloudFoundryClient, servicePlans) -> Mono.when(DefaultServiceAdmin.updateServicePlanVisibilities(cloudFoundryClient, request, (List<ServicePlanResource>)servicePlans), DefaultServiceAdmin.updateServicePlansPublicStatus(cloudFoundryClient, request, (List<ServicePlanResource>)servicePlans)))).then().transform(OperationsLogging.log("Disable Service Access")).checkpoint();
    }

    @Override
    public Mono<Void> enableServiceAccess(EnableServiceAccessRequest request) {
        return this.cloudFoundryClient.then(cloudFoundryClient -> Mono.when((Mono)Mono.just((Object)cloudFoundryClient), DefaultServiceAdmin.getServiceId(cloudFoundryClient, request.getServiceName()))).then(TupleUtils.function((cloudFoundryClient, serviceId) -> Mono.when((Mono)Mono.just((Object)cloudFoundryClient), DefaultServiceAdmin.getServicePlans(cloudFoundryClient, serviceId)))).then(TupleUtils.function((cloudFoundryClient, servicePlans) -> Mono.when(DefaultServiceAdmin.updateServicePlanVisibilities(cloudFoundryClient, request, (List<ServicePlanResource>)servicePlans), DefaultServiceAdmin.updateServicePlansPublicStatus(cloudFoundryClient, request, (List<ServicePlanResource>)servicePlans)))).then().transform(OperationsLogging.log("Enable Service Access")).checkpoint();
    }

    @Override
    public Flux<ServiceBroker> list() {
        return this.cloudFoundryClient.flatMapMany(DefaultServiceAdmin::requestListServiceBrokers).map(this::toServiceBroker).transform(OperationsLogging.log("List Service Brokers")).checkpoint();
    }

    @Override
    public Flux<ServiceAccess> listServiceAccessSettings(ListServiceAccessSettingsRequest request) {
        return this.cloudFoundryClient.then(cloudFoundryClient -> Mono.when((Mono)Mono.just((Object)cloudFoundryClient), DefaultServiceAdmin.listServiceBrokers(cloudFoundryClient), (Mono)Mono.just((Object)request), DefaultServiceAdmin.requestListServicePlanVisibilities(cloudFoundryClient))).flatMapMany(TupleUtils.function(DefaultServiceAdmin::collectServiceAccessSettings)).transform(OperationsLogging.log("List Service Access Settings")).checkpoint();
    }

    private static Flux<ServiceAccess> collectServiceAccessSettings(CloudFoundryClient cloudFoundryClient, List<ServiceBrokerResource> brokers, ListServiceAccessSettingsRequest request, List<ServicePlanVisibilityResource> visibilities) {
        List<String> brokerIds = brokers.stream().filter(DefaultServiceAdmin.isRequiredServiceBroker(request.getBrokerName())).map(ResourceUtils::getId).collect(Collectors.toList());
        if (brokerIds.size() == 0) {
            throw new IllegalArgumentException(String.format("Service Broker %s not found", request.getBrokerName()));
        }
        return Mono.when(DefaultServiceAdmin.validateOrganization(cloudFoundryClient, request.getOrganizationName()), DefaultServiceAdmin.validateService(cloudFoundryClient, request.getServiceName())).thenMany(DefaultServiceAdmin.requestListServices(cloudFoundryClient, brokerIds)).filter(service -> DefaultServiceAdmin.isVisibleService(request, service)).collectList().flatMapMany(services -> DefaultServiceAdmin.getServicePlans(cloudFoundryClient, services).map(servicePlan -> Tuples.of((Object)services, (Object)servicePlan))).flatMap(TupleUtils.function((services, servicePlan) -> DefaultServiceAdmin.getOrganizationNames(cloudFoundryClient, servicePlan, visibilities).map(organizationNames -> Tuples.of((Object)organizationNames, (Object)services, (Object)servicePlan)))).filter(TupleUtils.predicate((organizationNames, services, servicePlan) -> DefaultServiceAdmin.isVisibleOrganization(organizationNames, request.getOrganizationName(), servicePlan))).map(TupleUtils.function((organizationNames, services, servicePlan) -> DefaultServiceAdmin.toServiceAccess(brokers, organizationNames, services, servicePlan)));
    }

    private static Mono<String> getOrganizationId(CloudFoundryClient cloudFoundryClient, String organizationName) {
        return DefaultServiceAdmin.requestListOrganizations(cloudFoundryClient, organizationName).singleOrEmpty().map(ResourceUtils::getId).switchIfEmpty(ExceptionUtils.illegalArgument((String)"Organization %s not found", (Object[])new Object[]{organizationName}));
    }

    private static Mono<List<String>> getOrganizationNames(CloudFoundryClient cloudFoundryClient, ServicePlanResource servicePlan, List<ServicePlanVisibilityResource> visibilities) {
        if (visibilities == null || visibilities.size() == 0) {
            return Mono.just(Collections.emptyList());
        }
        return Flux.fromIterable(visibilities).filter(visibility -> servicePlan.getMetadata().getId().equals(visibility.getEntity().getServicePlanId())).flatMap(visibility -> DefaultServiceAdmin.requestGetOrganization(cloudFoundryClient, visibility.getEntity().getOrganizationId())).map(organization -> ((OrganizationEntity)ResourceUtils.getEntity((Resource)organization)).getName()).collectList();
    }

    private static Mono<ServiceBrokerResource> getServiceBroker(CloudFoundryClient cloudFoundryClient, String serviceBrokerName) {
        return DefaultServiceAdmin.requestListServiceBrokers(cloudFoundryClient, serviceBrokerName).single().onErrorResume(NoSuchElementException.class, t -> ExceptionUtils.illegalArgument((String)"Service Broker %s not found", (Object[])new Object[]{serviceBrokerName}));
    }

    private static Mono<String> getServiceBrokerId(CloudFoundryClient cloudFoundryClient, String serviceBrokerName) {
        return DefaultServiceAdmin.getServiceBroker(cloudFoundryClient, serviceBrokerName).map(ResourceUtils::getId);
    }

    private static Mono<String> getServiceId(CloudFoundryClient cloudFoundryClient, String serviceName) {
        return DefaultServiceAdmin.requestListServices(cloudFoundryClient, serviceName).singleOrEmpty().map(ResourceUtils::getId).switchIfEmpty(ExceptionUtils.illegalArgument((String)"Service offering %s not found", (Object[])new Object[]{serviceName}));
    }

    private static Mono<List<ServicePlanResource>> getServicePlans(CloudFoundryClient cloudFoundryClient, String serviceId) {
        return DefaultServiceAdmin.requestListServicePlans(cloudFoundryClient, Collections.singletonList(serviceId)).collectList();
    }

    private static Flux<ServicePlanResource> getServicePlans(CloudFoundryClient cloudFoundryClient, List<ServiceResource> services) {
        List<String> serviceIds = services.stream().map(ResourceUtils::getId).collect(Collectors.toList());
        return DefaultServiceAdmin.requestListServicePlans(cloudFoundryClient, serviceIds);
    }

    private static Predicate<ServiceBrokerResource> isRequiredServiceBroker(String brokerName) {
        if (brokerName == null || brokerName.isEmpty()) {
            return broker -> true;
        }
        return broker -> brokerName.equals(((ServiceBrokerEntity)ResourceUtils.getEntity((Resource)broker)).getName());
    }

    private static boolean isUpdateableServicePlan(String servicePlanName, ServicePlanResource servicePlan) {
        return servicePlanName == null || servicePlanName.isEmpty() || servicePlanName.equals(((ServicePlanEntity)ResourceUtils.getEntity((Resource)servicePlan)).getName());
    }

    private static boolean isVisibleOrganization(List<String> organizationNames, String requiredOrganization, ServicePlanResource servicePlan) {
        return ((ServicePlanEntity)ResourceUtils.getEntity((Resource)servicePlan)).getPubliclyVisible() != false || requiredOrganization == null || requiredOrganization.isEmpty() || organizationNames != null && organizationNames.contains(requiredOrganization);
    }

    private static boolean isVisibleService(ListServiceAccessSettingsRequest request, ServiceResource service) {
        return request.getServiceName() == null || request.getServiceName().isEmpty() || request.getServiceName().equals(((ServiceEntity)ResourceUtils.getEntity((Resource)service)).getLabel());
    }

    private static Mono<List<ServiceBrokerResource>> listServiceBrokers(CloudFoundryClient cloudFoundryClient) {
        return DefaultServiceAdmin.requestListServiceBrokers(cloudFoundryClient).switchIfEmpty((Publisher)ExceptionUtils.illegalArgument((String)"No Service Brokers found", (Object[])new Object[0])).collectList();
    }

    private static Flux<String> listServicePlanVisibilityIds(CloudFoundryClient cloudFoundryClient, List<String> servicePlanIds) {
        return DefaultServiceAdmin.requestListServicePlanVisibilities(cloudFoundryClient, servicePlanIds).map(ResourceUtils::getId);
    }

    private static Flux<String> listServicePlanVisibilityIds(CloudFoundryClient cloudFoundryClient, String organizationId, List<String> servicePlanIds) {
        return DefaultServiceAdmin.requestListServicePlanVisibilities(cloudFoundryClient, organizationId, servicePlanIds).map(ResourceUtils::getId);
    }

    private static Mono<CreateServiceBrokerResponse> requestCreateServiceBroker(CloudFoundryClient cloudFoundryClient, String name, String url, String username, String password, Boolean isSpaceScoped, String spaceId) {
        return cloudFoundryClient.serviceBrokers().create(org.cloudfoundry.client.v2.servicebrokers.CreateServiceBrokerRequest.builder().name(name).brokerUrl(url).authenticationUsername(username).authenticationPassword(password).spaceId(Optional.ofNullable(isSpaceScoped).orElse(false) != false ? spaceId : null).build());
    }

    private static Mono<CreateServicePlanVisibilityResponse> requestCreateServicePlanVisibility(CloudFoundryClient cloudFoundryClient, String organizationId, String servicePlanId) {
        return cloudFoundryClient.servicePlanVisibilities().create(CreateServicePlanVisibilityRequest.builder().organizationId(organizationId).servicePlanId(servicePlanId).build());
    }

    private static Mono<Void> requestDeleteServiceBroker(CloudFoundryClient cloudFoundryClient, String serviceBrokerId) {
        return cloudFoundryClient.serviceBrokers().delete(org.cloudfoundry.client.v2.servicebrokers.DeleteServiceBrokerRequest.builder().serviceBrokerId(serviceBrokerId).build());
    }

    private static Mono<DeleteServicePlanVisibilityResponse> requestDeleteServicePlanVisibility(CloudFoundryClient cloudFoundryClient, String visibilityId) {
        return cloudFoundryClient.servicePlanVisibilities().delete(DeleteServicePlanVisibilityRequest.builder().async(Boolean.valueOf(true)).servicePlanVisibilityId(visibilityId).build());
    }

    private static Mono<GetOrganizationResponse> requestGetOrganization(CloudFoundryClient cloudFoundryClient, String organizationId) {
        return cloudFoundryClient.organizations().get(GetOrganizationRequest.builder().organizationId(organizationId).build());
    }

    private static Flux<OrganizationResource> requestListOrganizations(CloudFoundryClient cloudFoundryClient, String organizationName) {
        return PaginationUtils.requestClientV2Resources(page -> cloudFoundryClient.organizations().list(ListOrganizationsRequest.builder().name(organizationName).page(page).build()));
    }

    private static Flux<ServiceBrokerResource> requestListServiceBrokers(CloudFoundryClient cloudFoundryClient) {
        return PaginationUtils.requestClientV2Resources(page -> cloudFoundryClient.serviceBrokers().list(ListServiceBrokersRequest.builder().page(page).build()));
    }

    private static Flux<ServiceBrokerResource> requestListServiceBrokers(CloudFoundryClient cloudFoundryClient, String serviceBrokerName) {
        return PaginationUtils.requestClientV2Resources(page -> cloudFoundryClient.serviceBrokers().list(ListServiceBrokersRequest.builder().name(serviceBrokerName).page(page).build()));
    }

    private static Mono<List<ServicePlanVisibilityResource>> requestListServicePlanVisibilities(CloudFoundryClient cloudFoundryClient) {
        return PaginationUtils.requestClientV2Resources(page -> cloudFoundryClient.servicePlanVisibilities().list(ListServicePlanVisibilitiesRequest.builder().page(page).build())).collectList();
    }

    private static Flux<ServicePlanVisibilityResource> requestListServicePlanVisibilities(CloudFoundryClient cloudFoundryClient, List<String> servicePlanIds) {
        return PaginationUtils.requestClientV2Resources(page -> cloudFoundryClient.servicePlanVisibilities().list(ListServicePlanVisibilitiesRequest.builder().page(page).servicePlanIds((Iterable)servicePlanIds).build()));
    }

    private static Flux<ServicePlanVisibilityResource> requestListServicePlanVisibilities(CloudFoundryClient cloudFoundryClient, String organizationId, List<String> servicePlanIds) {
        return PaginationUtils.requestClientV2Resources(page -> cloudFoundryClient.servicePlanVisibilities().list(ListServicePlanVisibilitiesRequest.builder().organizationId(organizationId).page(page).servicePlanIds((Iterable)servicePlanIds).build()));
    }

    private static Flux<ServicePlanResource> requestListServicePlans(CloudFoundryClient cloudFoundryClient, List<String> services) {
        return PaginationUtils.requestClientV2Resources(page -> cloudFoundryClient.servicePlans().list(ListServicePlansRequest.builder().page(page).serviceIds((Iterable)services).build()));
    }

    private static Flux<ServiceResource> requestListServices(CloudFoundryClient cloudFoundryClient, List<String> brokerIds) {
        return PaginationUtils.requestClientV2Resources(page -> cloudFoundryClient.services().list(ListServicesRequest.builder().page(page).serviceBrokerIds((Iterable)brokerIds).build()));
    }

    private static Flux<ServiceResource> requestListServices(CloudFoundryClient cloudFoundryClient, String serviceName) {
        return PaginationUtils.requestClientV2Resources(page -> cloudFoundryClient.services().list(ListServicesRequest.builder().page(page).label(serviceName).build()));
    }

    private static Mono<UpdateServicePlanResponse> requestUpdateServicePlanPublicStatus(CloudFoundryClient cloudFoundryClient, boolean publiclyVisible, String servicePlanId) {
        return cloudFoundryClient.servicePlans().update(UpdateServicePlanRequest.builder().publiclyVisible(Boolean.valueOf(publiclyVisible)).servicePlanId(servicePlanId).build());
    }

    private static ServiceAccess toServiceAccess(List<ServiceBrokerResource> brokers, List<String> organizationNames, List<ServiceResource> services, ServicePlanResource servicePlan) {
        Access access = Access.NONE;
        if (organizationNames != null && organizationNames.size() > 0) {
            access = Access.LIMITED;
        }
        if (((ServicePlanEntity)ResourceUtils.getEntity((Resource)servicePlan)).getPubliclyVisible().booleanValue()) {
            access = Access.ALL;
        }
        String servicePlanName = ((ServicePlanEntity)ResourceUtils.getEntity((Resource)servicePlan)).getName();
        ServiceResource service = services.stream().filter(item -> ResourceUtils.getId((Resource)item).equals(servicePlan.getEntity().getServiceId())).findFirst().orElseThrow(() -> new IllegalStateException(String.format("Unable to find service for %s", servicePlanName)));
        String serviceName = ((ServiceEntity)ResourceUtils.getEntity((Resource)service)).getLabel();
        String brokerName = brokers.stream().filter(broker -> ResourceUtils.getId((Resource)broker).equals(((ServiceEntity)ResourceUtils.getEntity((Resource)service)).getServiceBrokerId())).map(broker -> ((ServiceBrokerEntity)ResourceUtils.getEntity((Resource)broker)).getName()).findFirst().orElseThrow(() -> new IllegalStateException(String.format("Unable to find broker for %s", serviceName)));
        return ServiceAccess.builder().access(access).brokerName(brokerName).organizationNames(organizationNames).planName(servicePlanName).serviceName(serviceName).build();
    }

    private static Mono<Void> updateServicePlanVisibilities(CloudFoundryClient cloudFoundryClient, EnableServiceAccessRequest request, List<ServicePlanResource> servicePlans) {
        List<String> servicePlanIds = servicePlans.stream().filter(servicePlan -> DefaultServiceAdmin.isUpdateableServicePlan(request.getServicePlanName(), servicePlan)).map(ResourceUtils::getId).collect(Collectors.toList());
        if (request.getOrganizationName() != null && !request.getOrganizationName().isEmpty()) {
            return DefaultServiceAdmin.getOrganizationId(cloudFoundryClient, request.getOrganizationName()).flatMapMany(organizationId -> Flux.fromIterable((Iterable)servicePlanIds).flatMap(servicePlanId -> DefaultServiceAdmin.requestCreateServicePlanVisibility(cloudFoundryClient, organizationId, servicePlanId))).then();
        }
        return DefaultServiceAdmin.listServicePlanVisibilityIds(cloudFoundryClient, servicePlanIds).flatMap(visibilityId -> DefaultServiceAdmin.requestDeleteServicePlanVisibility(cloudFoundryClient, visibilityId).then(job -> JobUtils.waitForCompletion((CloudFoundryClient)cloudFoundryClient, (Duration)request.getCompletionTimeout(), (Resource)job))).then();
    }

    private static Mono<Void> updateServicePlanVisibilities(CloudFoundryClient cloudFoundryClient, DisableServiceAccessRequest request, List<ServicePlanResource> servicePlans) {
        List<String> servicePlanIds = servicePlans.stream().filter(servicePlan -> DefaultServiceAdmin.isUpdateableServicePlan(request.getServicePlanName(), servicePlan)).map(ResourceUtils::getId).collect(Collectors.toList());
        if (request.getOrganizationName() != null && !request.getOrganizationName().isEmpty()) {
            return DefaultServiceAdmin.getOrganizationId(cloudFoundryClient, request.getOrganizationName()).then(organizationId -> DefaultServiceAdmin.listServicePlanVisibilityIds(cloudFoundryClient, organizationId, servicePlanIds).flatMap(visibilityId -> DefaultServiceAdmin.requestDeleteServicePlanVisibility(cloudFoundryClient, visibilityId).then(job -> JobUtils.waitForCompletion((CloudFoundryClient)cloudFoundryClient, (Duration)request.getCompletionTimeout(), (Resource)job))).then());
        }
        return DefaultServiceAdmin.listServicePlanVisibilityIds(cloudFoundryClient, servicePlanIds).flatMap(visibilityId -> DefaultServiceAdmin.requestDeleteServicePlanVisibility(cloudFoundryClient, visibilityId).then(job -> JobUtils.waitForCompletion((CloudFoundryClient)cloudFoundryClient, (Duration)request.getCompletionTimeout(), (Resource)job))).then();
    }

    private static Mono<Void> updateServicePlansPublicStatus(CloudFoundryClient cloudFoundryClient, DisableServiceAccessRequest request, List<ServicePlanResource> servicePlans) {
        if (request.getOrganizationName() != null && !request.getOrganizationName().isEmpty()) {
            return Mono.empty();
        }
        if (request.getServicePlanName() != null && !request.getServicePlanName().isEmpty()) {
            return Mono.empty();
        }
        return Flux.fromIterable(servicePlans).filter(servicePlan -> ((ServicePlanEntity)ResourceUtils.getEntity((Resource)servicePlan)).getPubliclyVisible()).flatMap(servicePlan -> DefaultServiceAdmin.requestUpdateServicePlanPublicStatus(cloudFoundryClient, false, ResourceUtils.getId((Resource)servicePlan))).then();
    }

    private static Mono<Void> updateServicePlansPublicStatus(CloudFoundryClient cloudFoundryClient, EnableServiceAccessRequest request, List<ServicePlanResource> servicePlans) {
        if (request.getOrganizationName() != null && !request.getOrganizationName().isEmpty()) {
            return Mono.empty();
        }
        return Flux.fromIterable(servicePlans).filter(servicePlan -> ((ServicePlanEntity)ResourceUtils.getEntity((Resource)servicePlan)).getPubliclyVisible() == false).flatMap(servicePlan -> DefaultServiceAdmin.requestUpdateServicePlanPublicStatus(cloudFoundryClient, true, ResourceUtils.getId((Resource)servicePlan))).then();
    }

    private static Mono<Void> validateOrganization(CloudFoundryClient cloudFoundryClient, String organizationName) {
        if (organizationName != null) {
            return DefaultServiceAdmin.requestListOrganizations(cloudFoundryClient, organizationName).switchIfEmpty((Publisher)ExceptionUtils.illegalArgument((String)"Organization %s not found", (Object[])new Object[]{organizationName})).then();
        }
        return Mono.empty();
    }

    private static Mono<Void> validateService(CloudFoundryClient cloudFoundryClient, String serviceName) {
        if (serviceName != null) {
            return DefaultServiceAdmin.requestListServices(cloudFoundryClient, serviceName).switchIfEmpty((Publisher)ExceptionUtils.illegalArgument((String)"Service %s not found", (Object[])new Object[]{serviceName})).then();
        }
        return Mono.empty();
    }

    private ServiceBroker toServiceBroker(ServiceBrokerResource resource) {
        ServiceBrokerEntity entity = (ServiceBrokerEntity)ResourceUtils.getEntity((Resource)resource);
        return ServiceBroker.builder().id(ResourceUtils.getId((Resource)resource)).name(entity.getName()).url(entity.getBrokerUrl()).build();
    }
}

