/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.operations.spaceadmin;

import java.util.NoSuchElementException;
import org.cloudfoundry.client.CloudFoundryClient;
import org.cloudfoundry.client.v2.Resource;
import org.cloudfoundry.client.v2.organizations.ListOrganizationSpaceQuotaDefinitionsRequest;
import org.cloudfoundry.client.v2.spacequotadefinitions.SpaceQuotaDefinitionEntity;
import org.cloudfoundry.client.v2.spacequotadefinitions.SpaceQuotaDefinitionResource;
import org.cloudfoundry.operations.spaceadmin.GetSpaceQuotaRequest;
import org.cloudfoundry.operations.spaceadmin.SpaceAdmin;
import org.cloudfoundry.operations.spaceadmin.SpaceQuota;
import org.cloudfoundry.operations.util.OperationsLogging;
import org.cloudfoundry.util.ExceptionUtils;
import org.cloudfoundry.util.PaginationUtils;
import org.cloudfoundry.util.ResourceUtils;
import org.cloudfoundry.util.tuple.TupleUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class DefaultSpaceAdmin
implements SpaceAdmin {
    private final Mono<CloudFoundryClient> cloudFoundryClient;
    private final Mono<String> organizationId;

    public DefaultSpaceAdmin(Mono<CloudFoundryClient> cloudFoundryClient, Mono<String> organizationId) {
        this.cloudFoundryClient = cloudFoundryClient;
        this.organizationId = organizationId;
    }

    @Override
    public Mono<SpaceQuota> get(GetSpaceQuotaRequest request) {
        return Mono.when(this.cloudFoundryClient, this.organizationId).then(TupleUtils.function((cloudFoundryClient, organizationId) -> DefaultSpaceAdmin.getSpaceQuotaDefinition(cloudFoundryClient, organizationId, request.getName()))).map(DefaultSpaceAdmin::toSpaceQuota).transform(OperationsLogging.log("Get Space Quota")).checkpoint();
    }

    @Override
    public Flux<SpaceQuota> listQuotas() {
        return Mono.when(this.cloudFoundryClient, this.organizationId).flatMapMany(TupleUtils.function(DefaultSpaceAdmin::requestSpaceQuotaDefinitions)).map(DefaultSpaceAdmin::toSpaceQuota).transform(OperationsLogging.log("List Space Quota")).checkpoint();
    }

    private static Mono<SpaceQuotaDefinitionResource> getSpaceQuotaDefinition(CloudFoundryClient cloudFoundryClient, String organizationId, String name) {
        return DefaultSpaceAdmin.requestSpaceQuotaDefinitions(cloudFoundryClient, organizationId).filter(resource -> name.equals(((SpaceQuotaDefinitionEntity)ResourceUtils.getEntity((Resource)resource)).getName())).single().onErrorResume(NoSuchElementException.class, t -> ExceptionUtils.illegalArgument((String)"Space Quota %s does not exist", (Object[])new Object[]{name}));
    }

    private static Flux<SpaceQuotaDefinitionResource> requestSpaceQuotaDefinitions(CloudFoundryClient cloudFoundryClient, String organizationId) {
        return PaginationUtils.requestClientV2Resources(page -> cloudFoundryClient.organizations().listSpaceQuotaDefinitions(ListOrganizationSpaceQuotaDefinitionsRequest.builder().organizationId(organizationId).page(page).build()));
    }

    private static SpaceQuota toSpaceQuota(SpaceQuotaDefinitionResource resource) {
        SpaceQuotaDefinitionEntity entity = (SpaceQuotaDefinitionEntity)ResourceUtils.getEntity((Resource)resource);
        return SpaceQuota.builder().id(ResourceUtils.getId((Resource)resource)).instanceMemoryLimit(entity.getInstanceMemoryLimit()).name(entity.getName()).organizationId(entity.getOrganizationId()).paidServicePlans(entity.getNonBasicServicesAllowed()).totalMemoryLimit(entity.getMemoryLimit()).totalRoutes(entity.getTotalRoutes()).totalServiceInstances(entity.getTotalServices()).build();
    }
}

