/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.operations.applications;

import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.cloudfoundry.operations.applications.DecomposedRoute;
import org.cloudfoundry.operations.applications.DomainSummary;
import reactor.core.publisher.Mono;

final class RouteUtils {
    private RouteUtils() {
    }

    static Mono<DecomposedRoute> decomposeRoute(List<DomainSummary> availableDomains, String route, String routePath) {
        String domain = null;
        String host = null;
        String path = null;
        Integer port = null;
        String routeWithoutSuffix = route;
        if (availableDomains.size() == 0) {
            throw new IllegalArgumentException(String.format("The route %s did not match any existing domains", route));
        }
        List sortedDomains = availableDomains.stream().sorted(Comparator.comparingInt(domainSummary -> domainSummary.getName().length()).reversed()).collect(Collectors.toList());
        if (route.contains("/")) {
            int index = route.indexOf("/");
            path = routePath != null ? routePath : route.substring(index);
            routeWithoutSuffix = route.substring(0, index);
        } else if (RouteUtils.hasPort(route).booleanValue()) {
            port = RouteUtils.getPort(route);
            routeWithoutSuffix = route.substring(0, route.indexOf(":"));
        }
        for (DomainSummary item : sortedDomains) {
            if (!routeWithoutSuffix.contains(item.getName())) continue;
            domain = item.getName();
            if (domain.length() >= routeWithoutSuffix.length()) break;
            host = routeWithoutSuffix.substring(0, routeWithoutSuffix.lastIndexOf(domain) - 1);
            break;
        }
        if (domain == null) {
            throw new IllegalArgumentException(String.format("The route %s did not match any existing domains", route));
        }
        if ((host != null || path != null) && port != null) {
            throw new IllegalArgumentException(String.format("The route %s is invalid: Host/path cannot be set with port", route));
        }
        return Mono.just((Object)DecomposedRoute.builder().domain(domain).host(host).path(path).port(port).build());
    }

    private static Integer getPort(String route) {
        Pattern pattern = Pattern.compile(":\\d+$");
        Matcher matcher = pattern.matcher(route);
        matcher.find();
        return Integer.valueOf(route.substring(matcher.start() + 1, matcher.end()));
    }

    private static Boolean hasPort(String route) {
        Pattern pattern = Pattern.compile("^.+?:\\d+$");
        Matcher matcher = pattern.matcher(route);
        return matcher.matches();
    }
}

