package org.cloudfoundry.operations.applications;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * The request options for the delete application operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_DeleteApplicationRequest"})
public final class DeleteApplicationRequest
    extends org.cloudfoundry.operations.applications._DeleteApplicationRequest {
  private final @Nullable Boolean deleteRoutes;
  private final String name;

  private DeleteApplicationRequest(DeleteApplicationRequest.Builder builder) {
    this.deleteRoutes = builder.deleteRoutes;
    this.name = builder.name;
  }

  /**
   * Whether to delete mapped routes
   */
  @Override
  public @Nullable Boolean getDeleteRoutes() {
    return deleteRoutes;
  }

  /**
   * The application name
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * This instance is equal to all instances of {@code DeleteApplicationRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof DeleteApplicationRequest
        && equalTo((DeleteApplicationRequest) another);
  }

  private boolean equalTo(DeleteApplicationRequest another) {
    return Objects.equals(deleteRoutes, another.deleteRoutes)
        && name.equals(another.name);
  }

  /**
   * Computes a hash code from attributes: {@code deleteRoutes}, {@code name}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(deleteRoutes);
    h = h * 17 + name.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code DeleteApplicationRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DeleteApplicationRequest{"
        + "deleteRoutes=" + deleteRoutes
        + ", name=" + name
        + "}";
  }

  /**
   * Creates a builder for {@link DeleteApplicationRequest DeleteApplicationRequest}.
   * @return A new DeleteApplicationRequest builder
   */
  public static DeleteApplicationRequest.Builder builder() {
    return new DeleteApplicationRequest.Builder();
  }

  /**
   * Builds instances of type {@link DeleteApplicationRequest DeleteApplicationRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private long initBits = 0x1L;

    private Boolean deleteRoutes;
    private String name;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DeleteApplicationRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DeleteApplicationRequest instance) {
      return from((_DeleteApplicationRequest) instance);
    }

    /**
     * Copy abstract value type {@code _DeleteApplicationRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_DeleteApplicationRequest instance) {
      Objects.requireNonNull(instance, "instance");
      Boolean deleteRoutesValue = instance.getDeleteRoutes();
      if (deleteRoutesValue != null) {
        deleteRoutes(deleteRoutesValue);
      }
      name(instance.getName());
      return this;
    }

    /**
     * Initializes the value for the {@link _DeleteApplicationRequest#getDeleteRoutes() deleteRoutes} attribute.
     * @param deleteRoutes The value for deleteRoutes (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder deleteRoutes(@Nullable Boolean deleteRoutes) {
      this.deleteRoutes = deleteRoutes;
      return this;
    }

    /**
     * Initializes the value for the {@link _DeleteApplicationRequest#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Builds a new {@link DeleteApplicationRequest DeleteApplicationRequest}.
     * @return An immutable instance of DeleteApplicationRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public DeleteApplicationRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new DeleteApplicationRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build DeleteApplicationRequest, some of required attributes are not set " + attributes;
    }
  }
}
