package org.cloudfoundry.operations.applications;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * The request options for the scale application operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_ScaleApplicationRequest"})
public final class ScaleApplicationRequest
    extends org.cloudfoundry.operations.applications._ScaleApplicationRequest {
  private final @Nullable Integer diskLimit;
  private final @Nullable Integer instances;
  private final @Nullable Integer memoryLimit;
  private final String name;
  private final @Nullable Duration stagingTimeout;
  private final @Nullable Duration startupTimeout;

  private ScaleApplicationRequest(ScaleApplicationRequest.Builder builder) {
    this.diskLimit = builder.diskLimit;
    this.instances = builder.instances;
    this.memoryLimit = builder.memoryLimit;
    this.name = builder.name;
    this.stagingTimeout = builder.stagingTimeout;
    this.startupTimeout = builder.startupTimeout;
  }

  /**
   * The disk limit in MB
   */
  @Override
  public @Nullable Integer getDiskLimit() {
    return diskLimit;
  }

  /**
   * The number of instances
   */
  @Override
  public @Nullable Integer getInstances() {
    return instances;
  }

  /**
   * The memory limit in MB
   */
  @Override
  public @Nullable Integer getMemoryLimit() {
    return memoryLimit;
  }

  /**
   * The name of the application
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * How long to wait for staging
   */
  @Override
  public @Nullable Duration getStagingTimeout() {
    return stagingTimeout;
  }

  /**
   * How long to wait for startup
   */
  @Override
  public @Nullable Duration getStartupTimeout() {
    return startupTimeout;
  }

  /**
   * This instance is equal to all instances of {@code ScaleApplicationRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ScaleApplicationRequest
        && equalTo((ScaleApplicationRequest) another);
  }

  private boolean equalTo(ScaleApplicationRequest another) {
    return Objects.equals(diskLimit, another.diskLimit)
        && Objects.equals(instances, another.instances)
        && Objects.equals(memoryLimit, another.memoryLimit)
        && name.equals(another.name)
        && Objects.equals(stagingTimeout, another.stagingTimeout)
        && Objects.equals(startupTimeout, another.startupTimeout);
  }

  /**
   * Computes a hash code from attributes: {@code diskLimit}, {@code instances}, {@code memoryLimit}, {@code name}, {@code stagingTimeout}, {@code startupTimeout}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(diskLimit);
    h = h * 17 + Objects.hashCode(instances);
    h = h * 17 + Objects.hashCode(memoryLimit);
    h = h * 17 + name.hashCode();
    h = h * 17 + Objects.hashCode(stagingTimeout);
    h = h * 17 + Objects.hashCode(startupTimeout);
    return h;
  }

  /**
   * Prints the immutable value {@code ScaleApplicationRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ScaleApplicationRequest{"
        + "diskLimit=" + diskLimit
        + ", instances=" + instances
        + ", memoryLimit=" + memoryLimit
        + ", name=" + name
        + ", stagingTimeout=" + stagingTimeout
        + ", startupTimeout=" + startupTimeout
        + "}";
  }

  /**
   * Creates a builder for {@link ScaleApplicationRequest ScaleApplicationRequest}.
   * @return A new ScaleApplicationRequest builder
   */
  public static ScaleApplicationRequest.Builder builder() {
    return new ScaleApplicationRequest.Builder();
  }

  /**
   * Builds instances of type {@link ScaleApplicationRequest ScaleApplicationRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private long initBits = 0x1L;

    private Integer diskLimit;
    private Integer instances;
    private Integer memoryLimit;
    private String name;
    private Duration stagingTimeout;
    private Duration startupTimeout;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ScaleApplicationRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ScaleApplicationRequest instance) {
      return from((_ScaleApplicationRequest) instance);
    }

    /**
     * Copy abstract value type {@code _ScaleApplicationRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ScaleApplicationRequest instance) {
      Objects.requireNonNull(instance, "instance");
      Integer diskLimitValue = instance.getDiskLimit();
      if (diskLimitValue != null) {
        diskLimit(diskLimitValue);
      }
      Integer instancesValue = instance.getInstances();
      if (instancesValue != null) {
        instances(instancesValue);
      }
      Integer memoryLimitValue = instance.getMemoryLimit();
      if (memoryLimitValue != null) {
        memoryLimit(memoryLimitValue);
      }
      name(instance.getName());
      Duration stagingTimeoutValue = instance.getStagingTimeout();
      if (stagingTimeoutValue != null) {
        stagingTimeout(stagingTimeoutValue);
      }
      Duration startupTimeoutValue = instance.getStartupTimeout();
      if (startupTimeoutValue != null) {
        startupTimeout(startupTimeoutValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _ScaleApplicationRequest#getDiskLimit() diskLimit} attribute.
     * @param diskLimit The value for diskLimit (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder diskLimit(@Nullable Integer diskLimit) {
      this.diskLimit = diskLimit;
      return this;
    }

    /**
     * Initializes the value for the {@link _ScaleApplicationRequest#getInstances() instances} attribute.
     * @param instances The value for instances (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder instances(@Nullable Integer instances) {
      this.instances = instances;
      return this;
    }

    /**
     * Initializes the value for the {@link _ScaleApplicationRequest#getMemoryLimit() memoryLimit} attribute.
     * @param memoryLimit The value for memoryLimit (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder memoryLimit(@Nullable Integer memoryLimit) {
      this.memoryLimit = memoryLimit;
      return this;
    }

    /**
     * Initializes the value for the {@link _ScaleApplicationRequest#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link _ScaleApplicationRequest#getStagingTimeout() stagingTimeout} attribute.
     * @param stagingTimeout The value for stagingTimeout (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder stagingTimeout(@Nullable Duration stagingTimeout) {
      this.stagingTimeout = stagingTimeout;
      return this;
    }

    /**
     * Initializes the value for the {@link _ScaleApplicationRequest#getStartupTimeout() startupTimeout} attribute.
     * @param startupTimeout The value for startupTimeout (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder startupTimeout(@Nullable Duration startupTimeout) {
      this.startupTimeout = startupTimeout;
      return this;
    }

    /**
     * Builds a new {@link ScaleApplicationRequest ScaleApplicationRequest}.
     * @return An immutable instance of ScaleApplicationRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ScaleApplicationRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ScaleApplicationRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build ScaleApplicationRequest, some of required attributes are not set " + attributes;
    }
  }
}
