/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.operations.applications;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.operations.applications._CopySourceApplicationRequest;

public final class CopySourceApplicationRequest
extends _CopySourceApplicationRequest {
    private final String name;
    @Nullable
    private final Boolean restart;
    @Nullable
    private final Duration stagingTimeout;
    @Nullable
    private final Duration startupTimeout;
    private final String targetName;
    @Nullable
    private final String targetOrganization;
    @Nullable
    private final String targetSpace;

    private CopySourceApplicationRequest(Builder builder) {
        this.name = builder.name;
        this.restart = builder.restart;
        this.stagingTimeout = builder.stagingTimeout;
        this.startupTimeout = builder.startupTimeout;
        this.targetName = builder.targetName;
        this.targetOrganization = builder.targetOrganization;
        this.targetSpace = builder.targetSpace;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public Boolean getRestart() {
        return this.restart;
    }

    @Override
    @Nullable
    public Duration getStagingTimeout() {
        return this.stagingTimeout;
    }

    @Override
    @Nullable
    public Duration getStartupTimeout() {
        return this.startupTimeout;
    }

    @Override
    public String getTargetName() {
        return this.targetName;
    }

    @Override
    @Nullable
    public String getTargetOrganization() {
        return this.targetOrganization;
    }

    @Override
    @Nullable
    public String getTargetSpace() {
        return this.targetSpace;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CopySourceApplicationRequest && this.equalTo((CopySourceApplicationRequest)another);
    }

    private boolean equalTo(CopySourceApplicationRequest another) {
        return this.name.equals(another.name) && Objects.equals(this.restart, another.restart) && Objects.equals(this.stagingTimeout, another.stagingTimeout) && Objects.equals(this.startupTimeout, another.startupTimeout) && this.targetName.equals(another.targetName) && Objects.equals(this.targetOrganization, another.targetOrganization) && Objects.equals(this.targetSpace, another.targetSpace);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.name.hashCode();
        h = h * 17 + Objects.hashCode(this.restart);
        h = h * 17 + Objects.hashCode(this.stagingTimeout);
        h = h * 17 + Objects.hashCode(this.startupTimeout);
        h = h * 17 + this.targetName.hashCode();
        h = h * 17 + Objects.hashCode(this.targetOrganization);
        h = h * 17 + Objects.hashCode(this.targetSpace);
        return h;
    }

    public String toString() {
        return "CopySourceApplicationRequest{name=" + this.name + ", restart=" + this.restart + ", stagingTimeout=" + this.stagingTimeout + ", startupTimeout=" + this.startupTimeout + ", targetName=" + this.targetName + ", targetOrganization=" + this.targetOrganization + ", targetSpace=" + this.targetSpace + "}";
    }

    private static CopySourceApplicationRequest validate(CopySourceApplicationRequest instance) {
        instance.check();
        return instance;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_TARGET_NAME = 2L;
        private long initBits = 3L;
        private String name;
        private Boolean restart;
        private Duration stagingTimeout;
        private Duration startupTimeout;
        private String targetName;
        private String targetOrganization;
        private String targetSpace;

        private Builder() {
        }

        public final Builder from(CopySourceApplicationRequest instance) {
            return this.from((_CopySourceApplicationRequest)instance);
        }

        final Builder from(_CopySourceApplicationRequest instance) {
            String targetSpaceValue;
            Duration startupTimeoutValue;
            Duration stagingTimeoutValue;
            Objects.requireNonNull(instance, "instance");
            this.name(instance.getName());
            Boolean restartValue = instance.getRestart();
            if (restartValue != null) {
                this.restart(restartValue);
            }
            if ((stagingTimeoutValue = instance.getStagingTimeout()) != null) {
                this.stagingTimeout(stagingTimeoutValue);
            }
            if ((startupTimeoutValue = instance.getStartupTimeout()) != null) {
                this.startupTimeout(startupTimeoutValue);
            }
            this.targetName(instance.getTargetName());
            String targetOrganizationValue = instance.getTargetOrganization();
            if (targetOrganizationValue != null) {
                this.targetOrganization(targetOrganizationValue);
            }
            if ((targetSpaceValue = instance.getTargetSpace()) != null) {
                this.targetSpace(targetSpaceValue);
            }
            return this;
        }

        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder restart(@Nullable Boolean restart) {
            this.restart = restart;
            return this;
        }

        public final Builder stagingTimeout(@Nullable Duration stagingTimeout) {
            this.stagingTimeout = stagingTimeout;
            return this;
        }

        public final Builder startupTimeout(@Nullable Duration startupTimeout) {
            this.startupTimeout = startupTimeout;
            return this;
        }

        public final Builder targetName(String targetName) {
            this.targetName = Objects.requireNonNull(targetName, "targetName");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder targetOrganization(@Nullable String targetOrganization) {
            this.targetOrganization = targetOrganization;
            return this;
        }

        public final Builder targetSpace(@Nullable String targetSpace) {
            this.targetSpace = targetSpace;
            return this;
        }

        public CopySourceApplicationRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return CopySourceApplicationRequest.validate(new CopySourceApplicationRequest(this));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("targetName");
            }
            return "Cannot build CopySourceApplicationRequest, some of required attributes are not set " + attributes;
        }
    }
}

