/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.operations.applications;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.operations.applications._ScaleApplicationRequest;

public final class ScaleApplicationRequest
extends _ScaleApplicationRequest {
    @Nullable
    private final Integer diskLimit;
    @Nullable
    private final Integer instances;
    @Nullable
    private final Integer memoryLimit;
    private final String name;
    @Nullable
    private final Duration stagingTimeout;
    @Nullable
    private final Duration startupTimeout;

    private ScaleApplicationRequest(Builder builder) {
        this.diskLimit = builder.diskLimit;
        this.instances = builder.instances;
        this.memoryLimit = builder.memoryLimit;
        this.name = builder.name;
        this.stagingTimeout = builder.stagingTimeout;
        this.startupTimeout = builder.startupTimeout;
    }

    @Override
    @Nullable
    public Integer getDiskLimit() {
        return this.diskLimit;
    }

    @Override
    @Nullable
    public Integer getInstances() {
        return this.instances;
    }

    @Override
    @Nullable
    public Integer getMemoryLimit() {
        return this.memoryLimit;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public Duration getStagingTimeout() {
        return this.stagingTimeout;
    }

    @Override
    @Nullable
    public Duration getStartupTimeout() {
        return this.startupTimeout;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ScaleApplicationRequest && this.equalTo((ScaleApplicationRequest)another);
    }

    private boolean equalTo(ScaleApplicationRequest another) {
        return Objects.equals(this.diskLimit, another.diskLimit) && Objects.equals(this.instances, another.instances) && Objects.equals(this.memoryLimit, another.memoryLimit) && this.name.equals(another.name) && Objects.equals(this.stagingTimeout, another.stagingTimeout) && Objects.equals(this.startupTimeout, another.startupTimeout);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Objects.hashCode(this.diskLimit);
        h = h * 17 + Objects.hashCode(this.instances);
        h = h * 17 + Objects.hashCode(this.memoryLimit);
        h = h * 17 + this.name.hashCode();
        h = h * 17 + Objects.hashCode(this.stagingTimeout);
        h = h * 17 + Objects.hashCode(this.startupTimeout);
        return h;
    }

    public String toString() {
        return "ScaleApplicationRequest{diskLimit=" + this.diskLimit + ", instances=" + this.instances + ", memoryLimit=" + this.memoryLimit + ", name=" + this.name + ", stagingTimeout=" + this.stagingTimeout + ", startupTimeout=" + this.startupTimeout + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private long initBits = 1L;
        private Integer diskLimit;
        private Integer instances;
        private Integer memoryLimit;
        private String name;
        private Duration stagingTimeout;
        private Duration startupTimeout;

        private Builder() {
        }

        public final Builder from(ScaleApplicationRequest instance) {
            return this.from((_ScaleApplicationRequest)instance);
        }

        final Builder from(_ScaleApplicationRequest instance) {
            Duration startupTimeoutValue;
            Integer memoryLimitValue;
            Integer instancesValue;
            Objects.requireNonNull(instance, "instance");
            Integer diskLimitValue = instance.getDiskLimit();
            if (diskLimitValue != null) {
                this.diskLimit(diskLimitValue);
            }
            if ((instancesValue = instance.getInstances()) != null) {
                this.instances(instancesValue);
            }
            if ((memoryLimitValue = instance.getMemoryLimit()) != null) {
                this.memoryLimit(memoryLimitValue);
            }
            this.name(instance.getName());
            Duration stagingTimeoutValue = instance.getStagingTimeout();
            if (stagingTimeoutValue != null) {
                this.stagingTimeout(stagingTimeoutValue);
            }
            if ((startupTimeoutValue = instance.getStartupTimeout()) != null) {
                this.startupTimeout(startupTimeoutValue);
            }
            return this;
        }

        public final Builder diskLimit(@Nullable Integer diskLimit) {
            this.diskLimit = diskLimit;
            return this;
        }

        public final Builder instances(@Nullable Integer instances) {
            this.instances = instances;
            return this;
        }

        public final Builder memoryLimit(@Nullable Integer memoryLimit) {
            this.memoryLimit = memoryLimit;
            return this;
        }

        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder stagingTimeout(@Nullable Duration stagingTimeout) {
            this.stagingTimeout = stagingTimeout;
            return this;
        }

        public final Builder startupTimeout(@Nullable Duration startupTimeout) {
            this.startupTimeout = startupTimeout;
            return this;
        }

        public ScaleApplicationRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ScaleApplicationRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build ScaleApplicationRequest, some of required attributes are not set " + attributes;
        }
    }
}

