/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.operations.applications;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.operations.applications._StartApplicationRequest;

public final class StartApplicationRequest
extends _StartApplicationRequest {
    private final String name;
    @Nullable
    private final Duration stagingTimeout;
    @Nullable
    private final Duration startupTimeout;

    private StartApplicationRequest(Builder builder) {
        this.name = builder.name;
        this.stagingTimeout = builder.stagingTimeout;
        this.startupTimeout = builder.startupTimeout;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public Duration getStagingTimeout() {
        return this.stagingTimeout;
    }

    @Override
    @Nullable
    public Duration getStartupTimeout() {
        return this.startupTimeout;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof StartApplicationRequest && this.equalTo((StartApplicationRequest)another);
    }

    private boolean equalTo(StartApplicationRequest another) {
        return this.name.equals(another.name) && Objects.equals(this.stagingTimeout, another.stagingTimeout) && Objects.equals(this.startupTimeout, another.startupTimeout);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.name.hashCode();
        h = h * 17 + Objects.hashCode(this.stagingTimeout);
        h = h * 17 + Objects.hashCode(this.startupTimeout);
        return h;
    }

    public String toString() {
        return "StartApplicationRequest{name=" + this.name + ", stagingTimeout=" + this.stagingTimeout + ", startupTimeout=" + this.startupTimeout + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private long initBits = 1L;
        private String name;
        private Duration stagingTimeout;
        private Duration startupTimeout;

        private Builder() {
        }

        public final Builder from(StartApplicationRequest instance) {
            return this.from((_StartApplicationRequest)instance);
        }

        final Builder from(_StartApplicationRequest instance) {
            Duration startupTimeoutValue;
            Objects.requireNonNull(instance, "instance");
            this.name(instance.getName());
            Duration stagingTimeoutValue = instance.getStagingTimeout();
            if (stagingTimeoutValue != null) {
                this.stagingTimeout(stagingTimeoutValue);
            }
            if ((startupTimeoutValue = instance.getStartupTimeout()) != null) {
                this.startupTimeout(startupTimeoutValue);
            }
            return this;
        }

        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder stagingTimeout(@Nullable Duration stagingTimeout) {
            this.stagingTimeout = stagingTimeout;
            return this;
        }

        public final Builder startupTimeout(@Nullable Duration startupTimeout) {
            this.startupTimeout = startupTimeout;
            return this;
        }

        public StartApplicationRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new StartApplicationRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build StartApplicationRequest, some of required attributes are not set " + attributes;
        }
    }
}

