/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.operations.domains;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.operations.domains._ShareDomainRequest;

public final class ShareDomainRequest
extends _ShareDomainRequest {
    private final String domain;
    private final String organization;

    private ShareDomainRequest(Builder builder) {
        this.domain = builder.domain;
        this.organization = builder.organization;
    }

    @Override
    public String getDomain() {
        return this.domain;
    }

    @Override
    public String getOrganization() {
        return this.organization;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ShareDomainRequest && this.equalTo((ShareDomainRequest)another);
    }

    private boolean equalTo(ShareDomainRequest another) {
        return this.domain.equals(another.domain) && this.organization.equals(another.organization);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.domain.hashCode();
        h = h * 17 + this.organization.hashCode();
        return h;
    }

    public String toString() {
        return "ShareDomainRequest{domain=" + this.domain + ", organization=" + this.organization + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_DOMAIN = 1L;
        private static final long INIT_BIT_ORGANIZATION = 2L;
        private long initBits = 3L;
        private String domain;
        private String organization;

        private Builder() {
        }

        public final Builder from(ShareDomainRequest instance) {
            return this.from((_ShareDomainRequest)instance);
        }

        final Builder from(_ShareDomainRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.domain(instance.getDomain());
            this.organization(instance.getOrganization());
            return this;
        }

        public final Builder domain(String domain) {
            this.domain = Objects.requireNonNull(domain, "domain");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder organization(String organization) {
            this.organization = Objects.requireNonNull(organization, "organization");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ShareDomainRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ShareDomainRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("domain");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("organization");
            }
            return "Cannot build ShareDomainRequest, some of required attributes are not set " + attributes;
        }
    }
}

