/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.operations.routes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.operations.routes._Route;

public final class Route
extends _Route {
    private final List<String> applications;
    private final String domain;
    private final String host;
    private final String id;
    private final String path;
    private final String space;

    private Route(Builder builder) {
        this.applications = Route.createUnmodifiableList(true, builder.applications);
        this.domain = builder.domain;
        this.host = builder.host;
        this.id = builder.id;
        this.path = builder.path;
        this.space = builder.space;
    }

    @Override
    public List<String> getApplications() {
        return this.applications;
    }

    @Override
    public String getDomain() {
        return this.domain;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getSpace() {
        return this.space;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Route && this.equalTo((Route)another);
    }

    private boolean equalTo(Route another) {
        return this.applications.equals(another.applications) && this.domain.equals(another.domain) && this.host.equals(another.host) && this.id.equals(another.id) && this.path.equals(another.path) && this.space.equals(another.space);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.applications.hashCode();
        h = h * 17 + this.domain.hashCode();
        h = h * 17 + this.host.hashCode();
        h = h * 17 + this.id.hashCode();
        h = h * 17 + this.path.hashCode();
        h = h * 17 + this.space.hashCode();
        return h;
    }

    public String toString() {
        return "Route{applications=" + this.applications + ", domain=" + this.domain + ", host=" + this.host + ", id=" + this.id + ", path=" + this.path + ", space=" + this.space + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_DOMAIN = 1L;
        private static final long INIT_BIT_HOST = 2L;
        private static final long INIT_BIT_ID = 4L;
        private static final long INIT_BIT_PATH = 8L;
        private static final long INIT_BIT_SPACE = 16L;
        private long initBits = 31L;
        private List<String> applications = new ArrayList<String>();
        private String domain;
        private String host;
        private String id;
        private String path;
        private String space;

        private Builder() {
        }

        public final Builder from(Route instance) {
            return this.from((_Route)instance);
        }

        final Builder from(_Route instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllApplications(instance.getApplications());
            this.domain(instance.getDomain());
            this.host(instance.getHost());
            this.id(instance.getId());
            this.path(instance.getPath());
            this.space(instance.getSpace());
            return this;
        }

        public final Builder application(String element) {
            this.applications.add(Objects.requireNonNull(element, "applications element"));
            return this;
        }

        public final Builder application(String ... elements) {
            for (String element : elements) {
                this.applications.add(Objects.requireNonNull(element, "applications element"));
            }
            return this;
        }

        public final Builder applications(Iterable<String> elements) {
            this.applications.clear();
            return this.addAllApplications(elements);
        }

        public final Builder addAllApplications(Iterable<String> elements) {
            for (String element : elements) {
                this.applications.add(Objects.requireNonNull(element, "applications element"));
            }
            return this;
        }

        public final Builder domain(String domain) {
            this.domain = Objects.requireNonNull(domain, "domain");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder host(String host) {
            this.host = Objects.requireNonNull(host, "host");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder path(String path) {
            this.path = Objects.requireNonNull(path, "path");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder space(String space) {
            this.space = Objects.requireNonNull(space, "space");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public Route build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new Route(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("domain");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("host");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("path");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("space");
            }
            return "Cannot build Route, some of required attributes are not set " + attributes;
        }
    }
}

