/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.operations.services;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.operations.services._CreateUserProvidedServiceInstanceRequest;

public final class CreateUserProvidedServiceInstanceRequest
extends _CreateUserProvidedServiceInstanceRequest {
    @Nullable
    private final Map<String, Object> credentials;
    private final String name;
    @Nullable
    private final String routeServiceUrl;
    @Nullable
    private final String syslogDrainUrl;

    private CreateUserProvidedServiceInstanceRequest(Builder builder) {
        this.credentials = builder.credentials == null ? null : CreateUserProvidedServiceInstanceRequest.createUnmodifiableMap(false, false, builder.credentials);
        this.name = builder.name;
        this.routeServiceUrl = builder.routeServiceUrl;
        this.syslogDrainUrl = builder.syslogDrainUrl;
    }

    @Override
    @Nullable
    public Map<String, Object> getCredentials() {
        return this.credentials;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public String getRouteServiceUrl() {
        return this.routeServiceUrl;
    }

    @Override
    @Nullable
    public String getSyslogDrainUrl() {
        return this.syslogDrainUrl;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CreateUserProvidedServiceInstanceRequest && this.equalTo((CreateUserProvidedServiceInstanceRequest)another);
    }

    private boolean equalTo(CreateUserProvidedServiceInstanceRequest another) {
        return Objects.equals(this.credentials, another.credentials) && this.name.equals(another.name) && Objects.equals(this.routeServiceUrl, another.routeServiceUrl) && Objects.equals(this.syslogDrainUrl, another.syslogDrainUrl);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Objects.hashCode(this.credentials);
        h = h * 17 + this.name.hashCode();
        h = h * 17 + Objects.hashCode(this.routeServiceUrl);
        h = h * 17 + Objects.hashCode(this.syslogDrainUrl);
        return h;
    }

    public String toString() {
        return "CreateUserProvidedServiceInstanceRequest{credentials=" + this.credentials + ", name=" + this.name + ", routeServiceUrl=" + this.routeServiceUrl + ", syslogDrainUrl=" + this.syslogDrainUrl + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private long initBits = 1L;
        private Map<String, Object> credentials = null;
        private String name;
        private String routeServiceUrl;
        private String syslogDrainUrl;

        private Builder() {
        }

        public final Builder from(CreateUserProvidedServiceInstanceRequest instance) {
            return this.from((_CreateUserProvidedServiceInstanceRequest)instance);
        }

        final Builder from(_CreateUserProvidedServiceInstanceRequest instance) {
            String syslogDrainUrlValue;
            Objects.requireNonNull(instance, "instance");
            Map<String, Object> credentialsValue = instance.getCredentials();
            if (credentialsValue != null) {
                this.putAllCredentials(credentialsValue);
            }
            this.name(instance.getName());
            String routeServiceUrlValue = instance.getRouteServiceUrl();
            if (routeServiceUrlValue != null) {
                this.routeServiceUrl(routeServiceUrlValue);
            }
            if ((syslogDrainUrlValue = instance.getSyslogDrainUrl()) != null) {
                this.syslogDrainUrl(syslogDrainUrlValue);
            }
            return this;
        }

        public final Builder credential(String key, Object value) {
            if (this.credentials == null) {
                this.credentials = new LinkedHashMap<String, Object>();
            }
            this.credentials.put(key, value);
            return this;
        }

        public final Builder credential(Map.Entry<String, ? extends Object> entry) {
            if (this.credentials == null) {
                this.credentials = new LinkedHashMap<String, Object>();
            }
            String k = entry.getKey();
            Object v = entry.getValue();
            this.credentials.put(k, v);
            return this;
        }

        public final Builder credentials(@Nullable Map<String, ? extends Object> credentials) {
            if (credentials == null) {
                this.credentials = null;
                return this;
            }
            this.credentials = new LinkedHashMap<String, Object>();
            return this.putAllCredentials(credentials);
        }

        public final Builder putAllCredentials(Map<String, ? extends Object> credentials) {
            if (this.credentials == null) {
                this.credentials = new LinkedHashMap<String, Object>();
            }
            for (Map.Entry<String, ? extends Object> entry : credentials.entrySet()) {
                String k = entry.getKey();
                Object v = entry.getValue();
                this.credentials.put(k, v);
            }
            return this;
        }

        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder routeServiceUrl(@Nullable String routeServiceUrl) {
            this.routeServiceUrl = routeServiceUrl;
            return this;
        }

        public final Builder syslogDrainUrl(@Nullable String syslogDrainUrl) {
            this.syslogDrainUrl = syslogDrainUrl;
            return this;
        }

        public CreateUserProvidedServiceInstanceRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new CreateUserProvidedServiceInstanceRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build CreateUserProvidedServiceInstanceRequest, some of required attributes are not set " + attributes;
        }
    }
}

